/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.utils;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.SubjectAltName;
import java.util.Enumeration;
import java.util.Vector;

public class X500Utils {
    private static final boolean DEBUG = false;

    public static String[] getCommonName(X509Certificate cert) {
        String[] commonNames = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            commonNames = subject.getRDNs(ObjectID.commonName);
        }
        return commonNames;
    }

    public static String[] getCountry(X509Certificate cert) {
        String[] country = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            country = subject.getRDNs(ObjectID.country);
        }
        return country;
    }

    public static String[] getEMail(X509Certificate cert) {
        String[] emails = null;
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            emails = subject.getRDNs(ObjectID.emailAddress);
        }
        if (emails == null) {
            emails = new String[]{};
        }
        ObjectID subAltName_OID = new ObjectID("2.5.29.17");
        Vector<Object> emailVector = new Vector<Object>();
        try {
            SubjectAltName subjectalt = (SubjectAltName)cert.getExtension(subAltName_OID);
            if (subjectalt != null) {
                GeneralNames generalNames = subjectalt.getGeneralNames();
                Enumeration e2 = generalNames.getNames();
                while (e2.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)e2.nextElement();
                    if (generalName.getType() != GeneralName.rfc822Name) continue;
                    emailVector.addElement(generalName.getName());
                }
            }
        }
        catch (X509ExtensionInitException subjectalt) {
            // empty catch block
        }
        emailVector.trimToSize();
        String[] result = new String[emails.length + emailVector.size()];
        System.arraycopy(emails, 0, result, 0, emails.length);
        for (int i = 0; i < emailVector.size(); ++i) {
            result[emails.length + i] = (String)emailVector.elementAt(i);
        }
        for (int j = 0; j < result.length; ++j) {
            result[j] = result[j].trim();
            result[j] = result[j].toLowerCase();
        }
        return result;
    }

    public static String[] getURL(X509Certificate cert) {
        ObjectID subAltName_OID = new ObjectID("2.5.29.17");
        Vector<Object> uRLVector = new Vector<Object>();
        try {
            SubjectAltName subjectalt = (SubjectAltName)cert.getExtension(subAltName_OID);
            if (subjectalt != null) {
                GeneralNames generalNames = subjectalt.getGeneralNames();
                Enumeration e2 = generalNames.getNames();
                while (e2.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)e2.nextElement();
                    if (generalName.getType() != GeneralName.uniformResourceIdentifier) continue;
                    uRLVector.addElement(generalName.getName());
                }
            }
        }
        catch (X509ExtensionInitException subjectalt) {
            // empty catch block
        }
        uRLVector.trimToSize();
        String[] result = new String[uRLVector.size()];
        for (int i = 0; i < uRLVector.size(); ++i) {
            result[i] = (String)uRLVector.elementAt(i);
        }
        for (int j = 0; j < result.length; ++j) {
            result[j] = result[j].trim();
            result[j] = result[j].toLowerCase();
        }
        return result;
    }

    public static String[] getLocality(X509Certificate cert) {
        String[] locality = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            locality = subject.getRDNs(ObjectID.locality);
        }
        return locality;
    }

    public static String[] getOrganization(X509Certificate cert) {
        String[] organizations = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            organizations = subject.getRDNs(ObjectID.organization);
        }
        return organizations;
    }

    public static String[] getOrganizationalUnit(X509Certificate cert) {
        String[] organizationalUnits = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            organizationalUnits = subject.getRDNs(ObjectID.organizationalUnit);
        }
        return organizationalUnits;
    }

    public static String[] getState(X509Certificate cert) {
        String[] state = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            state = subject.getRDNs(ObjectID.stateOrProvince);
        }
        return state;
    }

    public static String[] getStreet(X509Certificate cert) {
        String[] streetAddress = new String[]{};
        Name subject = (Name)cert.getSubjectDN();
        if (subject != null) {
            streetAddress = subject.getRDNs(ObjectID.streetAddress);
        }
        return streetAddress;
    }

    public static String[] splitCommonName(String commonName) {
        String cn = commonName.trim();
        int splitPosition = cn.lastIndexOf(" ");
        String[] result = new String[2];
        result[0] = cn.substring(0, splitPosition);
        result[0] = result[0].trim();
        result[1] = cn.substring(splitPosition + 1);
        return result;
    }

    public static String[] parseRDN(Name rdn) {
        ObjectID objID;
        Vector<String> vector = new Vector<String>();
        int i = 0;
        String[] name = rdn.getRDNs(ObjectID.country);
        if (name != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Country: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.locality)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Locality: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.stateOrProvince)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("State: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.organization)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Organization: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.organizationalUnit)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Organizational Unit: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.commonName)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Common Name: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.surName)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Surname: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.givenName)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Given Name: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.initials)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Initials: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.generationQualifier)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Generation Qualifier: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.title)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Title: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.dnQualifier)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Domain Name: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.emailAddress)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Email: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(objID = new ObjectID("2.5.4.41"))) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Name: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.domainComponent)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("DomainComponent: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.streetAddress)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Street: ").concat(String.valueOf(name[i].trim())));
            }
        }
        if ((name = rdn.getRDNs(ObjectID.uniqueIdentifier)) != null) {
            for (i = 0; i < name.length; ++i) {
                vector.addElement(String.valueOf("Unique Identifier: ").concat(String.valueOf(name[i].trim())));
            }
        }
        String[] result = new String[vector.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = (String)vector.elementAt(i);
        }
        return result;
    }

    public static String[] parseGeneralNames(GeneralNames gns) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = gns.getNames();
        while (enumeration.hasMoreElements()) {
            GeneralName gn = (GeneralName)enumeration.nextElement();
            if (gn.getType() == GeneralName.directoryName) {
                vector.addElement(String.valueOf("Directory Name: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.dNSName) {
                vector.addElement(String.valueOf("DNS Name: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.ediPartyName) {
                vector.addElement(String.valueOf("EDI Party Name: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.iPAddress) {
                vector.addElement(String.valueOf("IP-Address: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.otherName) {
                vector.addElement(String.valueOf("Other Name: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.registeredID) {
                vector.addElement(String.valueOf("Registered ID: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.rfc822Name) {
                vector.addElement(String.valueOf("Email: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() == GeneralName.uniformResourceIdentifier) {
                vector.addElement(String.valueOf("URI: ").concat(String.valueOf((String)gn.getName())));
            }
            if (gn.getType() != GeneralName.x400Address) continue;
            vector.addElement(String.valueOf("X.400 Address: ").concat(String.valueOf((String)gn.getName())));
        }
        String[] result = new String[vector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)vector.elementAt(i);
        }
        return result;
    }
}

