/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.utils;

import iaik.apps.trustmanager.TrustmanagerPolicyException;
import iaik.apps.trustmanager.demo.DebugEnv;
import iaik.security.cipher.SecretKey;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;

public final class Integrity {
    private static boolean DEBUG = false;
    private static int ITERATION_COUNT = 100;
    private static int DERIVED_KEY_LENGTH = 32;
    private static int SALT_LENGTH = 16;
    private static byte[] pwd_bytes = null;
    private static byte[] salt = null;
    private static boolean pBEKeyUpdated = false;
    private static SecretKey pBEKey = null;
    private static byte[] newSalt = null;
    private static SecretKey newPBEKey = null;
    private static boolean useNewSalt = false;
    private static SecRandom random = null;

    public static void setPassword(char[] pwd) throws TrustmanagerPolicyException {
        pwd_bytes = null;
        salt = null;
        pBEKeyUpdated = false;
        pBEKey = null;
        newSalt = null;
        newPBEKey = null;
        useNewSalt = false;
        if (DEBUG) {
            pwd_bytes = Integrity.charArrayToByteArray("Hannes".toCharArray());
            return;
        }
        pwd_bytes = Integrity.charArrayToByteArray(pwd);
        Integrity.deleteCharArray(pwd);
        if (DEBUG) {
            System.out.println("iaik.apps.trustmanager.utils.Integrity has now been initialized. ");
        }
    }

    public static boolean isInitialized() {
        return pwd_bytes != null;
    }

    public static void changePassword(char[] currentpwd, char[] newpwd) throws TrustmanagerPolicyException {
        if (DEBUG) {
            pwd_bytes = Integrity.charArrayToByteArray("Hannes".toCharArray());
            newSalt = DebugEnv.SALT;
            pBEKeyUpdated = true;
            newPBEKey = new SecretKey(DebugEnv.PKCS5KEY, "RAW");
            return;
        }
        byte[] currentpwd_bytes = Integrity.charArrayToByteArray(currentpwd);
        if (!CryptoUtils.equalsBlock((byte[])pwd_bytes, (byte[])currentpwd_bytes)) {
            throw new TrustmanagerPolicyException("Current password is not valid. ");
        }
        int digit = 0;
        int smallLetter = 0;
        int bigLetter = 0;
        int specialChar = 0;
        if (newpwd == null || newpwd.length < 6) {
            throw new TrustmanagerPolicyException("Password is too short. Must consist of at least 6 characters. ");
        }
        for (int i = 0; i < newpwd.length; ++i) {
            if (Character.isLetter(newpwd[i])) {
                if (Character.isLowerCase(newpwd[i])) {
                    ++smallLetter;
                    continue;
                }
                ++bigLetter;
                continue;
            }
            if (Character.isDigit(newpwd[i])) {
                ++digit;
                continue;
            }
            ++specialChar;
        }
        if (specialChar == 0 && bigLetter == 0 && digit == 0) {
            throw new TrustmanagerPolicyException("Do not use only small letters for your password. Please enter a new one. ");
        }
        pwd_bytes = Integrity.charArrayToByteArray(newpwd);
        newSalt = null;
        pBEKeyUpdated = false;
        newPBEKey = null;
        pBEKey = null;
        salt = null;
        useNewSalt = false;
        byte[] saltMio = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 56, 55, 54, 53, 52, 51, 50};
        Integrity.updatePBEKey(saltMio);
        Integrity.deleteCharArray(currentpwd);
        Integrity.deleteCharArray(newpwd);
    }

    private static void generatePBEKey() {
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance("PBKDF2", "IAIK");
        }
        catch (Exception e2) {
            throw new InternalErrorException(String.valueOf("Could not instantiate PKCS#5 key generator from provider IAIK: ").concat(String.valueOf(e2.getMessage())));
        }
        PBEKeyAndParameterSpec keyParameter = useNewSalt ? new PBEKeyAndParameterSpec(pwd_bytes, newSalt, ITERATION_COUNT, DERIVED_KEY_LENGTH) : new PBEKeyAndParameterSpec(pwd_bytes, salt, ITERATION_COUNT, DERIVED_KEY_LENGTH);
        try {
            keyGenerator.init((AlgorithmParameterSpec)keyParameter, null);
        }
        catch (InvalidAlgorithmParameterException e3) {
            throw new InternalErrorException(String.valueOf("Parameters for PKCS#5-PBKDF2 algorithm are not correct: ").concat(String.valueOf(e3.getMessage())));
        }
        if (useNewSalt) {
            newPBEKey = (SecretKey)keyGenerator.generateKey();
        } else {
            pBEKey = (SecretKey)keyGenerator.generateKey();
        }
    }

    public static byte[] updatePBEKey(byte[] saltValue) {
        if (pwd_bytes == null) {
            throw new InternalErrorException("Trustmanager is not initialized with a proper password. ");
        }
        if (saltValue == null) {
            useNewSalt = true;
            if (DEBUG) {
                newSalt = DebugEnv.SALT;
                newPBEKey = new SecretKey(DebugEnv.PKCS5KEY, "RAW");
                pBEKeyUpdated = true;
                return newSalt;
            }
            if (pBEKeyUpdated) {
                return newSalt;
            }
            if (random == null) {
                random = (SecRandom)SecRandom.getDefault();
            }
            newSalt = new byte[SALT_LENGTH];
            random.nextBytes(newSalt);
            Integrity.generatePBEKey();
            pBEKeyUpdated = true;
            return newSalt;
        }
        useNewSalt = false;
        if (saltValue.length != SALT_LENGTH) {
            throw new InternalErrorException("Invalid salt specified. ");
        }
        if (salt != null && CryptoUtils.equalsBlock((byte[])saltValue, (byte[])salt)) {
            return saltValue;
        }
        if (DEBUG) {
            salt = DebugEnv.SALT;
            pBEKey = new SecretKey(DebugEnv.PKCS5KEY, "RAW");
            return salt;
        }
        salt = saltValue;
        Integrity.generatePBEKey();
        return salt;
    }

    public static byte[] makeHMAC(byte[] msg) {
        Mac hMAC;
        Integrity.isInitialized();
        try {
            hMAC = Mac.getInstance("HMAC/SHA", "IAIK");
            if (useNewSalt) {
                hMAC.init((Key)newPBEKey);
            } else {
                hMAC.init((Key)pBEKey);
            }
        }
        catch (Exception e2) {
            throw new InternalErrorException(String.valueOf("Could not instantiate or initialize SHA-1 from provider IAIK: ").concat(String.valueOf(e2.getMessage())));
        }
        return hMAC.doFinal(msg);
    }

    public static boolean compare(byte[] msg, byte[] hMAC) {
        if (salt == null || pwd_bytes == null) {
            throw new InternalErrorException("Password or salt are not initialized. ");
        }
        byte[] newHMAC = Integrity.makeHMAC(msg);
        return CryptoUtils.equalsBlock((byte[])newHMAC, (byte[])hMAC);
    }

    public static void deleteCharArray(char[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = 48;
            }
        }
    }

    public static boolean areEqual(char[] array1, char[] array2) {
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] charArrayToByteArray(char[] array) {
        if (array == null) {
            return null;
        }
        byte[] result = new byte[2 * array.length];
        for (int i = 0; i < array.length; ++i) {
            int num = array[i];
            byte part1 = (byte)(num & 0xFF);
            byte part2 = (byte)((num >>>= 8) & 0xFF);
            result[i * 2] = part1;
            result[i * 2 + 1] = part2;
        }
        return result;
    }
}

