/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.trust;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.utils.InternalErrorException;
import iaik.x509.extensions.ReasonCode;
import java.math.BigInteger;
import java.util.Date;

public final class RevocationInfo
implements ASN1Type {
    protected boolean isRevoked = false;
    protected Date this_update = null;
    protected Date next_update = null;
    protected Date revoked_since = null;
    protected Date invalid_since = null;
    protected int reasonCode = ReasonCode.unspecified;

    public void setRevoked() {
        this.isRevoked = true;
    }

    public void clearRevoked() {
        this.isRevoked = false;
    }

    public boolean isRevoked() {
        return this.isRevoked;
    }

    public void setThisUpdate(Date date) {
        this.this_update = date;
    }

    public Date getThisUpdate() {
        return this.this_update;
    }

    public void setNextUpdate(Date date) {
        this.next_update = date;
    }

    public Date getNextUpdate() {
        return this.next_update;
    }

    public void setRevokedSince(Date date) {
        this.revoked_since = date;
    }

    public Date getRevokedSince() {
        return this.revoked_since;
    }

    public void setInvalidSince(Date date) {
        this.invalid_since = date;
    }

    public Date getInvalidSince() {
        return this.invalid_since;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(int reasonCode) {
        this.reasonCode = reasonCode;
    }

    public void decode(ASN1Object obj) throws CodingException {
        try {
            BOOLEAN isRevoked_ASN1 = (BOOLEAN)((SEQUENCE)obj).getComponentAt(0);
            this.isRevoked = (Boolean)isRevoked_ASN1.getValue();
            INTEGER this_update_ASN1 = (INTEGER)((SEQUENCE)obj).getComponentAt(1);
            BigInteger this_update_BigInteger = (BigInteger)this_update_ASN1.getValue();
            this.this_update = new Date(this_update_BigInteger.longValue());
            this.next_update = null;
            this.revoked_since = null;
            this.invalid_since = null;
            this.reasonCode = ReasonCode.unspecified;
            int count = obj.countComponents();
            for (int i = 2; i < count; ++i) {
                CON_SPEC temp = (CON_SPEC)((SEQUENCE)obj).getComponentAt(i);
                int tag = temp.getAsnType().getTag();
                BigInteger date_BigInteger = (BigInteger)((INTEGER)temp.getValue()).getValue();
                if (tag == 0) {
                    this.next_update = new Date(date_BigInteger.longValue());
                    continue;
                }
                if (tag == 1) {
                    this.revoked_since = new Date(date_BigInteger.longValue());
                    continue;
                }
                if (tag == 2) {
                    this.invalid_since = new Date(date_BigInteger.longValue());
                    continue;
                }
                this.reasonCode = date_BigInteger.intValue();
            }
        }
        catch (Exception e2) {
            throw new CodingException("Not an ASN.1 encoded RevocationInfo object. ");
        }
    }

    public ASN1Object toASN1Object() {
        CON_SPEC tempCON;
        if (this.this_update == null) {
            throw new InternalErrorException("RevocationInfo is not initialized properly. ");
        }
        SEQUENCE seq = new SEQUENCE();
        BOOLEAN tempBOOL = new BOOLEAN(this.isRevoked);
        seq.addComponent((ASN1Object)tempBOOL);
        INTEGER this_update_ASN1 = new INTEGER(BigInteger.valueOf(this.this_update.getTime()));
        seq.addComponent((ASN1Object)this_update_ASN1);
        if (this.next_update != null) {
            INTEGER next_update_ASN1 = new INTEGER(BigInteger.valueOf(this.next_update.getTime()));
            tempCON = new CON_SPEC(0, (ASN1Object)next_update_ASN1, false);
            seq.addComponent((ASN1Object)tempCON);
        }
        if (this.revoked_since != null) {
            INTEGER revoked_since_ASN1 = new INTEGER(BigInteger.valueOf(this.revoked_since.getTime()));
            tempCON = new CON_SPEC(1, (ASN1Object)revoked_since_ASN1, false);
            seq.addComponent((ASN1Object)tempCON);
        }
        if (this.invalid_since != null) {
            INTEGER invalid_since_ASN1 = new INTEGER(BigInteger.valueOf(this.invalid_since.getTime()));
            tempCON = new CON_SPEC(2, (ASN1Object)invalid_since_ASN1, false);
            seq.addComponent((ASN1Object)tempCON);
        }
        if (this.reasonCode != ReasonCode.unspecified) {
            INTEGER reasonCode_ASN1 = new INTEGER(this.reasonCode);
            tempCON = new CON_SPEC(3, (ASN1Object)reasonCode_ASN1, false);
            seq.addComponent((ASN1Object)tempCON);
        }
        return seq;
    }
}

