/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.trust;

import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.SubjectAltName;
import java.math.BigInteger;

public final class CertIdentifier
implements ASN1Type {
    protected boolean initialized = false;
    protected byte[] certHash = null;
    protected BigInteger serialNumber = null;
    protected Name issuer = null;
    protected Name subject = null;
    protected GeneralNames subjectAltName = null;

    public CertIdentifier() {
    }

    public CertIdentifier(X509Certificate cert) {
        this.certHash = TrustmanagerUtils.makeCertHash(cert);
        this.serialNumber = cert.getSerialNumber();
        this.issuer = (Name)cert.getIssuerDN();
        this.subject = (Name)cert.getSubjectDN();
        ObjectID subAltName_OID = new ObjectID("2.5.29.17");
        try {
            SubjectAltName sAN = (SubjectAltName)cert.getExtension(subAltName_OID);
            this.subjectAltName = sAN != null ? sAN.getGeneralNames() : null;
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            // empty catch block
        }
        this.initialized = true;
    }

    public byte[] getCertHash() {
        if (this.initialized) {
            return this.certHash;
        }
        throw new InternalErrorException("CertIdentifier not initialized yet. ");
    }

    public BigInteger getSerialNumber() {
        if (this.initialized) {
            return this.serialNumber;
        }
        throw new InternalErrorException("CertIdentifier not initialized yet. ");
    }

    public Name getIssuer() {
        if (this.initialized) {
            return this.issuer;
        }
        throw new InternalErrorException("CertIdentifier not initialized yet. ");
    }

    public Name getSubject() {
        if (this.initialized) {
            return this.subject;
        }
        throw new InternalErrorException("CertIdentifier not initialized yet. ");
    }

    public GeneralNames getSubjectAltName() {
        if (this.initialized) {
            return this.subjectAltName;
        }
        throw new InternalErrorException("CertIdentifier not initialized yet. ");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void decode(ASN1Object obj) throws CodingException {
        try {
            this.initialized = false;
            OCTET_STRING certHash_ASN1 = (OCTET_STRING)obj.getComponentAt(0);
            this.certHash = (byte[])certHash_ASN1.getValue();
            INTEGER serialNumber_ASN1 = (INTEGER)obj.getComponentAt(1);
            this.serialNumber = (BigInteger)serialNumber_ASN1.getValue();
            ASN1Object issuer_ASN1 = obj.getComponentAt(2);
            this.issuer = new Name();
            this.issuer.decode(issuer_ASN1);
            CON_SPEC name1_ASN1 = (CON_SPEC)obj.getComponentAt(3);
            if (name1_ASN1.getAsnType().getTag() == 0) {
                this.subject = new Name(name1_ASN1.getComponentAt(0));
            } else {
                this.subjectAltName = new GeneralNames(name1_ASN1.getComponentAt(0));
            }
            if (obj.countComponents() > 4) {
                CON_SPEC name2_ASN1 = (CON_SPEC)obj.getComponentAt(4);
                this.subjectAltName = new GeneralNames(name2_ASN1.getComponentAt(0));
            }
        }
        catch (Exception e2) {
            throw new CodingException("Not an ASN.1 encoded CertIdentifier object. ");
        }
        this.initialized = true;
    }

    public ASN1Object toASN1Object() {
        if (this.initialized) {
            SEQUENCE certID = new SEQUENCE();
            OCTET_STRING certHash_ASN1 = new OCTET_STRING(this.certHash);
            certID.addComponent((ASN1Object)certHash_ASN1);
            INTEGER serialNumber_ASN1 = new INTEGER(this.serialNumber);
            certID.addComponent((ASN1Object)serialNumber_ASN1);
            certID.addComponent(this.issuer.toASN1Object());
            if (this.subject != null) {
                CON_SPEC subject_CON = new CON_SPEC(0, this.subject.toASN1Object(), false);
                certID.addComponent((ASN1Object)subject_CON);
            }
            if (this.subjectAltName != null) {
                ASN1Object subjectAltName_ASN1 = null;
                try {
                    subjectAltName_ASN1 = this.subjectAltName.toASN1Object();
                }
                catch (CodingException e2) {
                    throw new InternalErrorException(e2.getMessage());
                }
                CON_SPEC subjectAltName_CON = new CON_SPEC(1, subjectAltName_ASN1, false);
                certID.addComponent((ASN1Object)subjectAltName_CON);
            }
            return certID;
        }
        throw new InternalErrorException("CertIdentifier not initialized yet. ");
    }
}

