/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.sdk;

import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectAltName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ReadCertStore {
    private Hashtable hashtable;

    public void read(String complete_file_name) throws IOException {
        File file = new File(complete_file_name);
        FileInputStream inStream = new FileInputStream(file);
        byte[] certs_DER = new byte[inStream.available()];
        inStream.read(certs_DER);
        inStream.close();
        SEQUENCE certStore = null;
        try {
            certStore = (SEQUENCE)DerCoder.decode((byte[])certs_DER);
        }
        catch (CodingException e2) {
            throw new IOException("Unable to decode certificate store. ");
        }
        this.hashtable = new Hashtable();
        int size = certStore.countComponents();
        for (int i = 0; i < size; ++i) {
            SEQUENCE record = (SEQUENCE)certStore.getComponentAt(i);
            UTF8String alias_ASN1 = (UTF8String)record.getComponentAt(0);
            SEQUENCE certificates_ASN1 = (SEQUENCE)record.getComponentAt(1);
            String alias = (String)alias_ASN1.getValue();
            Vector<X509Certificate> certVector = new Vector<X509Certificate>();
            int certSEQUENCESize = certificates_ASN1.countComponents();
            for (int j = 0; j < certSEQUENCESize; ++j) {
                X509Certificate cert = new X509Certificate();
                try {
                    cert.decode(certificates_ASN1.getComponentAt(j));
                }
                catch (CodingException e3) {
                    throw new IOException("Unable to decode certificate store. ");
                }
                certVector.addElement(cert);
            }
            this.hashtable.put(alias, certVector);
        }
    }

    public String[] getEmailAdresses() {
        Hashtable<String, X509Certificate> certs = new Hashtable<String, X509Certificate>();
        Hashtable<String, String> emails = new Hashtable<String, String>();
        Enumeration e2 = this.hashtable.elements();
        while (e2.hasMoreElements()) {
            Vector certVector = (Vector)e2.nextElement();
            for (int i = 0; i < certVector.size(); ++i) {
                X509Certificate cert = (X509Certificate)certVector.elementAt(i);
                String alias = TrustmanagerUtils.byteArrayToString(this.makeCertHash(cert));
                certs.put(alias, cert);
            }
        }
        Enumeration enumeration = certs.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate cert = (X509Certificate)enumeration.nextElement();
            Name subject = (Name)cert.getSubjectDN();
            String[] emailAddresses = subject.getRDNs(ObjectID.emailAddress);
            if (emailAddresses != null && emailAddresses.length > 0) {
                for (int i = 0; i < emailAddresses.length; ++i) {
                    String email = emailAddresses[i];
                    email = email.trim();
                    email = email.toLowerCase();
                    emails.put(email, email);
                }
            }
            try {
                SubjectAltName subAlt = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
                if (subAlt == null) continue;
                GeneralNames generalNames = subAlt.getGeneralNames();
                Enumeration generalNames_enum = generalNames.getNames();
                while (generalNames_enum.hasMoreElements()) {
                    GeneralName generalName = (GeneralName)generalNames_enum.nextElement();
                    if (generalName.getType() != GeneralName.rfc822Name) continue;
                    String email = (String)generalName.getName();
                    email = email.trim();
                    email = email.toLowerCase();
                    emails.put(email, email);
                }
            }
            catch (Exception subAlt) {
            }
        }
        int number = emails.size();
        if (number > 0) {
            String[] result = new String[number];
            Enumeration result_enum = emails.elements();
            int i = 0;
            while (result_enum.hasMoreElements()) {
                result[i] = (String)result_enum.nextElement();
                ++i;
            }
            return result;
        }
        return null;
    }

    private byte[] makeCertHash(X509Certificate cert) {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA", "IAIK");
        }
        catch (Exception e2) {
            throw new InternalErrorException("Could not instantiate SHA from Provider IAIK. ");
        }
        try {
            sha.update(cert.getEncoded());
        }
        catch (CertificateEncodingException e3) {
            throw new InternalErrorException(String.valueOf("Could not encode certificate: ").concat(String.valueOf(e3.getMessage())));
        }
        return sha.digest();
    }
}

