/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.ldap;

import iaik.apps.trustmanager.TransientTmException;
import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.x509.X509Certificate;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class Utils {
    private static final boolean DEBUG = false;
    public static final int EECERTS = 1;
    public static final int CACERTS = 2;
    public static final int ALLCERTS = 3;

    public void testConnection(String uRL, String dN, String username, char[] password, String version) throws TrustmanagerException {
        uRL = TrustmanagerUtils.adaptURLString(uRL);
        if (dN != null) {
            dN = (dN = dN.trim()).length() < 1 ? null : dN.toLowerCase();
        }
        if (username != null && username.length() > 0 && password != null && password.length > 0) {
            if ((username = username.trim()).length() < 1) {
                username = null;
            }
        } else {
            username = null;
            password = null;
        }
        if (version == null || !version.equals("2") && !version.equals("3")) {
            version = null;
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", uRL);
            if (username == null) {
                env.put("java.naming.security.authentication", "none");
            } else {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", new String(password));
            }
            if (version != null) {
                env.put("java.naming.ldap.version", version);
            }
            InitialDirContext ctx = new InitialDirContext(env);
            if (dN != null) {
                Object object = ctx.lookup(dN);
            }
            ctx.close();
        }
        catch (CommunicationException e2) {
            throw new TrustmanagerException(String.valueOf("Cannot connect to host ").concat(String.valueOf(e2.getMessage())));
        }
        catch (NameNotFoundException e3) {
            throw new TrustmanagerException("Distinguished name is invalid. Cannot find directory entry. ");
        }
        catch (NamingException e4) {
            throw new TrustmanagerException("Cannot connect to directory. ");
        }
    }

    public Vector getCertificates(String uRL, String dN, String username, char[] password, String version, int certType) throws TransientTmException {
        String EMPTYSTRING = String.valueOf(' ');
        InitialDirContext ctx = null;
        DirContext subCtx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(11);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", uRL);
            if (username.equals(EMPTYSTRING)) {
                env.put("java.naming.security.authentication", "none");
            } else {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", new String(password));
            }
            if (!version.equals(EMPTYSTRING)) {
                env.put("java.naming.ldap.version", version);
            }
            ctx = new InitialDirContext(env);
            subCtx = (DirContext)ctx.lookup(dN);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setTimeLimit(5000);
            String[] returningAttributs = null;
            returningAttributs = certType == 3 ? new String[]{"usersmimecertificate;binary", "usersmimecertificate", "usercertificate;binary", "usercertificate", "cACertificate;binary", "cACertificate", "crossCertificatePair;binary", "crossCertificatePair"} : (certType == 1 ? new String[]{"usersmimecertificate;binary", "usersmimecertificate", "usercertificate;binary", "usercertificate"} : new String[]{"cACertificate;binary", "cACertificate", "crossCertificatePair;binary", "crossCertificatePair"});
            ctls.setCountLimit(100L);
            ctls.setReturningAttributes(returningAttributs);
            NamingEnumeration<SearchResult> namingEnumeration = subCtx.search("", "(cn=*)", ctls);
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            while (namingEnumeration.hasMore()) {
                SearchResult item = (SearchResult)namingEnumeration.nextElement();
                Attributes attributes = item.getAttributes();
                NamingEnumeration<String> attrEnum = attributes.getIDs();
                while (attrEnum.hasMore()) {
                    String attributeID = (String)attrEnum.nextElement();
                    Attribute attribute = attributes.get(attributeID);
                    byte[] cert_encoded = (byte[])attribute.get();
                    try {
                        X509Certificate certificate = new X509Certificate(cert_encoded);
                        vector.addElement(certificate);
                    }
                    catch (CertificateException certificateException) {}
                }
            }
            if (ctx != null) {
                ctx.close();
            }
            if (subCtx != null) {
                subCtx.close();
            }
            Vector<X509Certificate> vector2 = vector;
            return vector2;
        }
        catch (CommunicationException e2) {
            throw new TransientTmException(String.valueOf(String.valueOf("Cannot connect to host ").concat(String.valueOf(uRL))).concat(String.valueOf(". ")));
        }
        catch (NameNotFoundException e3) {
            throw new TransientTmException(String.valueOf(String.valueOf(String.valueOf("Cannot find ").concat(String.valueOf(dN))).concat(String.valueOf(" in directory "))).concat(String.valueOf(uRL)));
        }
        catch (NamingException e4) {
            throw new TransientTmException(String.valueOf(String.valueOf("Cannot connect to host ").concat(String.valueOf(uRL))).concat(String.valueOf(". ")));
        }
    }

    public Vector searchCertificates(String uRL, String dN, String username, char[] password, String version, String searchPattern, int certType, int timeLimit, int countLimit) throws TransientTmException {
        String EMPTYSTRING = String.valueOf(' ');
        InitialDirContext ctx = null;
        if (dN.equals(EMPTYSTRING)) {
            dN = "";
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", uRL);
            if (username.equals(EMPTYSTRING)) {
                env.put("java.naming.security.authentication", "none");
            } else {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", new String(password));
            }
            if (!version.equals(EMPTYSTRING)) {
                env.put("java.naming.ldap.version", version);
            }
            ctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setTimeLimit(timeLimit);
            ctls.setCountLimit(countLimit);
            String[] returningAttributs = null;
            returningAttributs = certType == 2 ? new String[]{"cACertificate;binary", "cACertificate", "crossCertificatePair;binary", "crossCertificatePair"} : new String[]{"usersmimecertificate;binary", "usersmimecertificate", "usercertificate;binary", "usercertificate"};
            ctls.setReturningAttributes(returningAttributs);
            NamingEnumeration<SearchResult> namingEnumeration = ctx.search(dN, searchPattern, ctls);
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            while (namingEnumeration.hasMore()) {
                SearchResult item = (SearchResult)namingEnumeration.nextElement();
                Attributes attributes = item.getAttributes();
                NamingEnumeration<String> attrEnum = attributes.getIDs();
                while (attrEnum.hasMore()) {
                    String attributeID = (String)attrEnum.nextElement();
                    Attribute attribute = attributes.get(attributeID);
                    byte[] cert_encoded = (byte[])attribute.get();
                    try {
                        X509Certificate certificate = new X509Certificate(cert_encoded);
                        vector.addElement(certificate);
                    }
                    catch (CertificateException certificateException) {}
                }
            }
            if (ctx != null) {
                ctx.close();
            }
            Vector<X509Certificate> vector2 = vector;
            return vector2;
        }
        catch (CommunicationException e2) {
            throw new TransientTmException(String.valueOf(String.valueOf("Cannot connect to host ").concat(String.valueOf(uRL))).concat(String.valueOf(". ")));
        }
        catch (NameNotFoundException e3) {
            throw new TransientTmException(String.valueOf(String.valueOf(String.valueOf("Cannot find ").concat(String.valueOf(dN))).concat(String.valueOf(" in directory "))).concat(String.valueOf(uRL)));
        }
        catch (SizeLimitExceededException e4) {
            throw new TransientTmException("Maximum number of hits exceeded. ");
        }
        catch (TimeLimitExceededException e5) {
            throw new TransientTmException("Time out exceeded. ");
        }
        catch (NamingException e6) {
            throw new TransientTmException(String.valueOf(String.valueOf("Cannot connect to host ").concat(String.valueOf(uRL))).concat(String.valueOf(". ")));
        }
    }
}

