/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.ldap;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.x509.X509Certificate;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapUtil {
    private static final boolean DEBUG = true;
    private static final String initCtx = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String attrSMimeCert = "usersmimecertificate;binary";
    private static final String attrUserCert = "usercertificate;binary";

    public static X509Certificate lookupCert(String emailAddress, String ldapServer, String searchBase) {
        block9: {
            Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
            env.put("java.naming.factory.initial", initCtx);
            env.put("java.naming.provider.url", String.valueOf("ldap://").concat(String.valueOf(ldapServer)));
            try {
                System.out.println(String.valueOf(String.valueOf("Opening connection to LDAP server ").concat(String.valueOf(ldapServer))).concat(String.valueOf("...")));
                InitialDirContext ctx = new InitialDirContext(env);
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(2);
                constraints.setTimeLimit(60000);
                constraints.setCountLimit(2L);
                constraints.setReturningAttributes(new String[]{attrSMimeCert, attrUserCert});
                NamingEnumeration<SearchResult> results = ctx.search(searchBase, String.valueOf(String.valueOf("(mail=").concat(String.valueOf(emailAddress))).concat(String.valueOf(")")), constraints);
                if (results != null && results.hasMore()) {
                    Attributes attrs;
                    SearchResult si = results.next();
                    if (results.hasMore()) {
                        System.out.println(String.valueOf(String.valueOf("Warning: more than one entry found for ").concat(String.valueOf(emailAddress))).concat(String.valueOf(", only the first will be used.")));
                    }
                    if ((attrs = si.getAttributes()) == null) {
                        System.out.println("Search result does not contain any attributes!");
                        break block9;
                    }
                    Attribute attr = attrs.get(attrSMimeCert);
                    if (attr == null) {
                        attr = attrs.get(attrUserCert);
                    }
                    if (attr == null) {
                        System.out.println("Search result does not contain a certificate!");
                        break block9;
                    }
                    try {
                        X509Certificate cert = new X509Certificate((byte[])attr.get());
                        System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Found certificate for ").concat(String.valueOf(emailAddress))).concat(String.valueOf(" ("))).concat(String.valueOf(((Name)cert.getSubjectDN()).getRDN(ObjectID.commonName)))).concat(String.valueOf(")")));
                        X509Certificate x509Certificate = cert;
                        return x509Certificate;
                    }
                    catch (Exception e2) {
                        System.err.println("Exception parsing certificate:");
                        System.err.println(e2);
                        break block9;
                    }
                }
                System.out.println(String.valueOf(String.valueOf(String.valueOf("No entry found for ").concat(String.valueOf(emailAddress))).concat(String.valueOf(" in "))).concat(String.valueOf(ldapServer)));
            }
            catch (NamingException e3) {
                System.err.println("A NamingException occured during LDAP lookup:");
                System.err.println(e3);
            }
        }
        return null;
    }

    private static String fixString(String name) {
        int n = name.length();
        StringBuffer sb = new StringBuffer(n + 2);
        for (int i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if (ch == '-' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            sb.append('-');
        }
        return sb.toString();
    }

    public static boolean deleteCert(String emailAddress, String ldapServer, String searchBase, String ldapAdmin, String ldapPassword) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initCtx);
        env.put("java.naming.provider.url", String.valueOf("ldap://").concat(String.valueOf(ldapServer)));
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapAdmin);
        env.put("java.naming.security.credentials", ldapPassword);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            BasicAttributes attrs = new BasicAttributes();
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setTimeLimit(60000);
            constraints.setCountLimit(20L);
            constraints.setReturningAttributes(new String[]{attrSMimeCert, attrUserCert});
            NamingEnumeration<SearchResult> results = ctx.search(searchBase, String.valueOf(String.valueOf("(mail=").concat(String.valueOf(emailAddress))).concat(String.valueOf(")")), constraints);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String name = si.getName();
                System.out.println(String.valueOf("Found: ").concat(String.valueOf(name)));
                if (name.startsWith("\"")) {
                    name = name.substring(1);
                }
                if (name.endsWith("\"")) {
                    name = name.substring(0, name.length() - 1);
                }
                ctx.destroySubcontext(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\"").concat(String.valueOf(name))).concat(String.valueOf(","))).concat(String.valueOf(searchBase))).concat(String.valueOf("\"")));
            }
        }
        catch (NamingException e2) {
            System.err.println("A NamingException occured during LDAP access:");
            System.err.println(e2);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public static boolean writeToLDAP(String email, String name, X509Certificate certificate, String ldapServer, String suffix, String ldapAdmin, String ldapPassword) {
        byte[] certBytes;
        try {
            certBytes = certificate.getEncoded();
        }
        catch (Throwable e2) {
            throw new NullPointerException("Could not encode certificate!");
        }
        BasicAttribute objectClass = new BasicAttribute("objectclass");
        objectClass.add("top");
        objectClass.add("Person");
        objectClass.add("inetOrgPerson");
        String userid = String.valueOf(String.valueOf(LdapUtil.fixString(email)).concat(String.valueOf("---id-"))).concat(String.valueOf(certificate.getSerialNumber()));
        String dn = String.valueOf(String.valueOf(String.valueOf("cn=").concat(String.valueOf(userid))).concat(String.valueOf(","))).concat(String.valueOf(suffix));
        dn = String.valueOf(String.valueOf("\"").concat(String.valueOf(dn))).concat(String.valueOf("\""));
        BasicAttribute at_cn = new BasicAttribute("cn", userid);
        BasicAttribute at_sn = new BasicAttribute("sn", name);
        BasicAttribute at_mail = new BasicAttribute("mail", email);
        BasicAttribute at_usersmime = new BasicAttribute("userSMIMECertificate;binary", certBytes);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initCtx);
        env.put("java.naming.provider.url", String.valueOf("ldap://").concat(String.valueOf(ldapServer)));
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapAdmin);
        env.put("java.naming.security.credentials", ldapPassword);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(objectClass);
            attrs.put(at_cn);
            attrs.put(at_sn);
            attrs.put(at_mail);
            attrs.put(at_usersmime);
            ctx.createSubcontext(dn, (Attributes)attrs);
            boolean bl = true;
            return bl;
        }
        catch (Exception e3) {
            System.err.println("Error writing to LDAP server:");
            System.err.println(e3);
            boolean bl = false;
            return bl;
        }
    }
}

