/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.demo;

import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.utils.InternalErrorException;
import iaik.utils.KeyAndCertificate;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;

public class DebugEnv {
    static final String FILE_PATH = "Z:/WinNT/Trustmanager/Certs/demo/";
    static final String FILE_NAME_CERT_1 = "cert1_C.der";
    static final String FILE_NAME_CERT_13 = "cert13_C.der";
    static final String FILE_NAME_CERT_131 = "cert131_C.der";
    static final String FILE_NAME_CERT_1311 = "cert1311_C.der";
    static final String FILE_NAME_CERT_13111 = "cert13111_C.der";
    static final String FILE_NAME_CERT_2 = "cert2_C.der";
    static final String FILE_NAME_CERT_21 = "cert21_C.der";
    static final String FILE_NAME_CERT_211 = "cert211_C.der";
    public static final String PWD = "Hannes";
    public static final byte[] SALT = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final byte[] PWDHASH = new byte[]{-118, 2, 45, 47, -91, -5, -112, -79, 17, 21, 68, -17, -39, 103, 99, 1, 23, -41, -127, 18};
    public static final byte[] PKCS5KEY = new byte[]{-89, 39, -18, 114, -71, 3, -120, 125, 7, -63, -72, 70, 38, -55, -62, -9, -30, 55, 36, -58, 102, 44, 118, 44, 18, 89, -11, 51, 54, 104, -110, 83};
    public static final byte[] PKCS5KEY_OLD = new byte[]{-75, -50, -12, 108, 5, -103, -61, -17, -16, -91, -93, -10, 119, -71, 42, -113, 82, 90, 4, 66, -92, -128, -80, -107, 5, -82, 25, -14, -13, 110, -78, 44};
    public static final X509Certificate CERT1;
    public static final X509Certificate CERT13;
    public static final X509Certificate CERT131;
    public static final X509Certificate CERT1311;
    public static final X509Certificate CERT13111;
    public static final X509Certificate CERT2;
    public static final X509Certificate CERT21;
    public static final X509Certificate CERT211;
    public static final X509Certificate CERT_ASIGN_CA1;
    public static final X509Certificate CERT_ASIGN_USER11;
    public static final X509Certificate CERT1_A;
    public static final X509Certificate CERT2_A;
    public static final X509Certificate CERT3_A;
    public static final X509Certificate CERT4_A;
    public static final X509Certificate CERT5_A;
    public static final X509Certificate CERT6_A;
    public static final X509Certificate CERT7_A;
    public static final X509Certificate CERT8_A;
    public static final X509Certificate CERT9_A;
    public static final X509Certificate CERT10_A;
    public static final X509Certificate CERT11_A;
    public static final String[] EMAIL;
    static final X509CRL CRL_ASIGN_USER_1;
    static final X509CRL CRL_ASIGN_USER_2;
    static final X509CRL CRL_ASIGN_USER_3;
    static Date testTime;

    protected static X509Certificate getCert(String str) {
        X509Certificate cert = null;
        try {
            FileInputStream stream = new FileInputStream(new File(String.valueOf(FILE_PATH).concat(String.valueOf(str))));
            cert = new X509Certificate((InputStream)stream);
            stream.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        return cert;
    }

    protected static X509Certificate[] getCertChain(String str, String password) {
        try {
            FileInputStream stream = new FileInputStream(new File(String.valueOf(FILE_PATH).concat(String.valueOf(str))));
            if (str.endsWith("der")) {
                KeyAndCertificate keyAndCert = new KeyAndCertificate((InputStream)stream);
                X509Certificate[] x509CertificateArray = keyAndCert.getCertificateChain();
                return x509CertificateArray;
            }
            if (str.endsWith("pfx")) {
                PKCS12 p12 = new PKCS12((InputStream)stream);
                p12.decrypt(password.toCharArray());
                CertificateBag[] certBags = p12.getCertificateBags();
                X509Certificate[] x509CertificateArray = CertificateBag.getCertificates((CertificateBag[])certBags);
                return x509CertificateArray;
            }
            stream.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        throw new InternalErrorException("Could not read certificates. ");
    }

    protected static X509CRL getCRL(String filename) {
        X509CRL crl = null;
        try {
            FileInputStream stream = new FileInputStream(new File(String.valueOf(FILE_PATH).concat(String.valueOf(filename))));
            crl = new X509CRL((InputStream)stream);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        return crl;
    }

    protected static X509Certificate[] readPKCS12(String file, String pwd) {
        try {
            PKCS12 pKCS12 = null;
            pKCS12 = new PKCS12((InputStream)new FileInputStream(String.valueOf(FILE_PATH).concat(String.valueOf(file))));
            String pKCS12_password = new String("wuaschti");
            pKCS12.decrypt(pKCS12_password.toCharArray());
            CertificateBag[] pKCS12_CertBag = pKCS12.getCertificateBags();
            X509Certificate[] pKCS12_CertificateChain = CertificateBag.getCertificates((CertificateBag[])pKCS12_CertBag);
            X509Certificate[] pKCS12_CertChain = new X509Certificate[pKCS12_CertificateChain.length];
            byte[][] pKCS12_CertChain_ByteArray = new byte[pKCS12_CertificateChain.length][];
            for (int n = 0; n < pKCS12_CertificateChain.length; ++n) {
                pKCS12_CertChain_ByteArray[n] = pKCS12_CertificateChain[n].getEncoded();
                pKCS12_CertChain[n] = new X509Certificate(pKCS12_CertChain_ByteArray[n]);
            }
            X509Certificate[] x509CertificateArray = pKCS12_CertChain;
            return x509CertificateArray;
        }
        catch (Exception e2) {
            throw new InternalErrorException();
        }
    }

    static {
        EMAIL = new String[]{"Melanie.Blauensteiner@iaik.at", "Wolfgang.Mayerwieser@iaik.at", "Dieter.Bratko@iaik.at", "Harald.Bratko@iaik.at", "Johannes.Farmer@iaik.at", "Manfred.Aigner@iaik.at", "Udo.Payer@iaik.at", "Silvia.Obermoser@iaik.at", "Johann.Groszschaedl@iaik.at", "Herbert.Leitold@iaik.at", "Johannes.Wolkerstorfer@iaik.at", "Werner.Archan@iaik.at", "Christian.Wilfing@iaik.at", "Peter.Lipp@iaik.at", "Reinhard.Posch@A-SIT.at", "Elisabeth.Oswald@iaik.at"};
        CERT1 = DebugEnv.getCert(FILE_NAME_CERT_1);
        CERT13 = DebugEnv.getCert(FILE_NAME_CERT_13);
        CERT131 = DebugEnv.getCert(FILE_NAME_CERT_131);
        CERT1311 = DebugEnv.getCert(FILE_NAME_CERT_1311);
        CERT13111 = DebugEnv.getCert(FILE_NAME_CERT_13111);
        CERT2 = DebugEnv.getCert(FILE_NAME_CERT_2);
        CERT21 = DebugEnv.getCert(FILE_NAME_CERT_21);
        CERT211 = DebugEnv.getCert(FILE_NAME_CERT_211);
        CERT_ASIGN_CA1 = DebugEnv.getCert("CRLs/ASign_CA_Cert.der");
        CERT_ASIGN_USER11 = DebugEnv.getCert("CRLs/ASign_User_Cert_1.der");
        CERT1_A = DebugEnv.getCert("cert1.der");
        CERT2_A = DebugEnv.getCert("cert2.der");
        CERT3_A = DebugEnv.getCert("cert3.der");
        CERT4_A = DebugEnv.getCert("cert4.der");
        CERT5_A = DebugEnv.getCert("cert5.der");
        CERT6_A = DebugEnv.getCert("cert6.der");
        CERT7_A = DebugEnv.getCert("cert7.der");
        CERT8_A = DebugEnv.getCert("cert8.der");
        CERT9_A = DebugEnv.getCert("cert9.der");
        CERT10_A = DebugEnv.getCert("cert10.der");
        CERT11_A = DebugEnv.getCert("cert11.der");
        CRL_ASIGN_USER_1 = DebugEnv.getCRL("CRLs/asignCRL1.der");
        CRL_ASIGN_USER_2 = DebugEnv.getCRL("CRLs/asignCRL2.der");
        CRL_ASIGN_USER_3 = DebugEnv.getCRL("CRLs/asignCRL3.der");
        testTime = new Date(new Long("926611356768"));
    }
}

