/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.crl;

import iaik.apps.trustmanager.TransientTmException;
import iaik.apps.trustmanager.api.Trustmanager;
import iaik.apps.trustmanager.crl.CRLDictionary;
import iaik.apps.trustmanager.crl.CRLDistributionPoint;
import iaik.apps.trustmanager.crl.CRLStore;
import iaik.apps.trustmanager.crl.CRLUtils;
import iaik.apps.trustmanager.net.ReceiveCRLoverHTTP;
import iaik.apps.trustmanager.net.ReceiveCRLoverLDAP;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.structures.Name;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CRLManager {
    private static final boolean DEBUG = false;
    private static boolean initialized = false;
    private static CRLStore cRLStore;
    private static CRLDictionary dictionary;

    public CRLManager() throws IOException {
        cRLStore = new CRLStore();
        cRLStore.init();
        dictionary = new CRLDictionary();
        initialized = true;
    }

    public static void init() throws IOException {
        cRLStore = new CRLStore();
        cRLStore.init();
        dictionary = new CRLDictionary();
        dictionary.load();
        initialized = true;
    }

    public static void save() throws IOException {
        dictionary.store();
    }

    public static void setDistributionPoint(X509Certificate cert, String lDAP_URL, String dN, String hTTP_URL) {
        if (lDAP_URL != null) {
            lDAP_URL = TrustmanagerUtils.adaptURLString(lDAP_URL);
        }
        if (dN != null) {
            dN = dN.trim();
            dN = dN.toLowerCase();
        }
        Name issuer = (Name)cert.getIssuerDN();
        String issuerString = CRLUtils.makeIssuerFingerprint(issuer);
        if (lDAP_URL != null) {
            String[] entry = (String[])CRLDictionary.table_LDAP_issuer.get(lDAP_URL);
            String[] newEntry = null;
            if (entry != null) {
                newEntry = new String[entry.length + 1];
                System.arraycopy(entry, 0, newEntry, 0, entry.length);
                newEntry[newEntry.length - 1] = issuerString;
            } else {
                newEntry = new String[]{issuerString};
            }
            CRLDictionary.table_LDAP_issuer.put(lDAP_URL, newEntry);
            CRLDictionary.table_issuer_LDAP.put(issuerString, lDAP_URL);
        }
        if (dN != null) {
            CRLDictionary.table_DN_issuer.put(dN, issuerString);
            CRLDictionary.table_issuer_DN.put(issuerString, dN);
        }
        if (hTTP_URL != null) {
            CRLDictionary.table_HTTP_issuer.put(hTTP_URL, issuerString);
            CRLDictionary.table_issuer_HTTP.put(issuerString, hTTP_URL);
        }
    }

    public static CRLDistributionPoint getDistributionPoint(X509Certificate cert) {
        Name issuer = (Name)cert.getIssuerDN();
        String issuerString = CRLUtils.makeIssuerFingerprint(issuer);
        CRLDistributionPoint distributionPoint = new CRLDistributionPoint();
        String entry = (String)CRLDictionary.table_issuer_LDAP.get(issuer);
        if (entry != null) {
            distributionPoint.lDAP_URL = entry;
        }
        if ((entry = (String)CRLDictionary.table_issuer_DN.get(issuer)) != null) {
            distributionPoint.dN = entry;
        }
        if ((entry = (String)CRLDictionary.table_issuer_HTTP.get(issuer)) != null) {
            distributionPoint.hTTP_URL = entry;
        }
        if (distributionPoint.lDAP_URL == null && distributionPoint.dN == null && distributionPoint.hTTP_URL == null) {
            return null;
        }
        return distributionPoint;
    }

    public static void putCRL(X509CRL crl) throws IOException {
        cRLStore.putCRL(crl);
    }

    public static Hashtable getDistributionPoints() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration<Object> enumeration = CRLDictionary.table_issuer_HTTP.elements();
        while (enumeration.hasMoreElements()) {
            String hTTP = (String)enumeration.nextElement();
            String issuer = (String)CRLDictionary.table_HTTP_issuer.get(hTTP);
            result.put(hTTP, issuer);
        }
        enumeration = CRLDictionary.table_issuer_DN.keys();
        while (enumeration.hasMoreElements()) {
            String issuer = (String)enumeration.nextElement();
            String ldap = (String)CRLDictionary.table_issuer_LDAP.get(issuer);
            String dn = (String)CRLDictionary.table_issuer_DN.get(issuer);
            result.put(String.valueOf(ldap).concat(String.valueOf(dn)), issuer);
        }
        return result;
    }

    public static void removeCRLDistributionPoint(String issuer) {
        String http;
        String ldap;
        String dn = (String)CRLDictionary.table_issuer_DN.get(issuer);
        if (dn != null) {
            CRLDictionary.table_issuer_DN.remove(issuer);
            CRLDictionary.table_DN_issuer.remove(dn);
        }
        if ((ldap = (String)CRLDictionary.table_issuer_LDAP.get(issuer)) != null) {
            CRLDictionary.table_issuer_LDAP.remove(issuer);
            String[] oldIssuerArray = (String[])CRLDictionary.table_LDAP_issuer.get(ldap);
            if (oldIssuerArray.length == 1) {
                CRLDictionary.table_LDAP_issuer.remove(ldap);
            } else {
                String[] newIssuerArray = new String[oldIssuerArray.length - 1];
                int oldArray = 0;
                int newArray = 0;
                while (oldArray < oldIssuerArray.length) {
                    if (!oldIssuerArray[oldArray].equals(issuer)) {
                        newIssuerArray[newArray] = oldIssuerArray[oldArray];
                        ++oldArray;
                        ++newArray;
                        continue;
                    }
                    ++oldArray;
                }
            }
        }
        if ((http = (String)CRLDictionary.table_issuer_HTTP.get(issuer)) != null) {
            CRLDictionary.table_issuer_HTTP.remove(issuer);
            CRLDictionary.table_HTTP_issuer.remove(http);
        }
    }

    public static X509CRL getCRL(X509Certificate cert) throws TransientTmException {
        X509Certificate cACert = Trustmanager.getCACertificate(cert);
        if (cACert == null) {
            return null;
        }
        X509CRL crl = null;
        try {
            crl = cRLStore.getCRL(cACert);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (crl != null && CRLUtils.isUptoDate(crl)) {
            return crl;
        }
        CRLDistributionPoint distributionPoint = CRLManager.getDistributionPoint(cert);
        if (distributionPoint != null) {
            String hTTPURL = distributionPoint.hTTP_URL;
            if (hTTPURL != null && hTTPURL.length() > 0) {
                ReceiveCRLoverHTTP cRLoverHTTPTask = new ReceiveCRLoverHTTP(hTTPURL);
                cRLoverHTTPTask.go();
                while (!cRLoverHTTPTask.done()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                String errorMessage = cRLoverHTTPTask.getMalformedURLExceptionMessage();
                if (errorMessage == null) {
                    errorMessage = cRLoverHTTPTask.getCRLExceptionMessage();
                }
                if (errorMessage != null) {
                    throw new TransientTmException(errorMessage);
                }
                crl = cRLoverHTTPTask.getCRL();
                try {
                    cRLStore.putCRL(crl);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return crl;
            }
            String lDAPURL = distributionPoint.lDAP_URL;
            if (lDAPURL != null && lDAPURL.length() > 0) {
                ReceiveCRLoverLDAP cRLoverLDAPTask = new ReceiveCRLoverLDAP(lDAPURL, distributionPoint.dN);
                while (!cRLoverLDAPTask.done()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                String errorMessage = cRLoverLDAPTask.getErrorMessage();
                if (errorMessage != null) {
                    throw new TransientTmException(errorMessage);
                }
                crl = cRLoverLDAPTask.getCRL();
                try {
                    cRLStore.putCRL(crl);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return crl;
            }
            return null;
        }
        return crl;
    }
}

