/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.api;

import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.utils.Integrity;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.utils.InternalErrorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class TrustEnv {
    private static boolean DEBUG = false;
    private static boolean initialized = false;
    public static boolean isGUI = false;
    public static boolean localDirs_are_available = true;
    private static String envFileName = "trust.sys";
    private static String trustFileName = "trust.dat";
    private static String groupFileName = "group.dat";
    private static String certFileName = "cert.dat";
    private static String cRLFileName = "crl.dat";
    public static String envFile;
    public static String trustFile;
    public static String groupFile;
    public static String certFile;
    public static String cRLFile;
    public static String homeDirectory;
    public static String cRLDirectory;
    private static Vector localDirs;
    private static Vector globalDirs;
    public static int expirationWarningPeriod;
    public static String fileImportDirectory;
    public static String fileExportDirectory;
    public static byte[] lastImportedCert;
    private static boolean viewCACerts;
    private static boolean viewEECerts;
    private static boolean viewLocalCerts;
    private static boolean viewLocalDirCerts;

    public static synchronized void initialize(String filename) {
        if (filename == null) {
            throw new NullPointerException("Filename must be specified. ");
        }
        if ((filename = filename.trim()).endsWith("trust.sys")) {
            int index = filename.lastIndexOf("trust.sys");
            homeDirectory = filename.substring(0, index);
        } else if (filename.endsWith("/")) {
            homeDirectory = filename;
            filename = String.valueOf(filename).concat(String.valueOf("trust.sys"));
        } else {
            homeDirectory = filename = String.valueOf(filename).concat(String.valueOf("/"));
            filename = String.valueOf(filename).concat(String.valueOf("trust.sys"));
        }
        envFile = filename;
        trustFile = String.valueOf(homeDirectory).concat(String.valueOf(trustFileName));
        groupFile = String.valueOf(homeDirectory).concat(String.valueOf(groupFileName));
        certFile = String.valueOf(homeDirectory).concat(String.valueOf(certFileName));
        cRLFile = String.valueOf(homeDirectory).concat(String.valueOf(cRLFileName));
        cRLDirectory = String.valueOf(String.valueOf(homeDirectory).concat(String.valueOf("CRL_DIR"))).concat(String.valueOf("/"));
        localDirs = new Vector();
        globalDirs = new Vector();
        expirationWarningPeriod = 10;
        fileImportDirectory = System.getProperty("user.home");
        fileExportDirectory = System.getProperty("user.home");
        lastImportedCert = null;
        initialized = true;
    }

    public static synchronized void load(String filename) throws TrustmanagerException, IOException {
        SEQUENCE trustEnvASN1;
        if (filename == null) {
            throw new NullPointerException("File name must be specified. ");
        }
        if ((filename = filename.trim()).endsWith("trust.sys")) {
            int index = filename.lastIndexOf("trust.sys");
            homeDirectory = filename.substring(0, index);
        } else if (filename.endsWith("/")) {
            homeDirectory = filename;
            filename = String.valueOf(filename).concat(String.valueOf("trust.sys"));
        } else {
            homeDirectory = filename = String.valueOf(filename).concat(String.valueOf("/"));
            filename = String.valueOf(filename).concat(String.valueOf("trust.sys"));
        }
        envFile = filename;
        trustFile = String.valueOf(homeDirectory).concat(String.valueOf(trustFileName));
        groupFile = String.valueOf(homeDirectory).concat(String.valueOf(groupFileName));
        certFile = String.valueOf(homeDirectory).concat(String.valueOf(certFileName));
        cRLFile = String.valueOf(homeDirectory).concat(String.valueOf(cRLFileName));
        cRLDirectory = String.valueOf(String.valueOf(homeDirectory).concat(String.valueOf("CRL_DIR"))).concat(String.valueOf("/"));
        localDirs = new Vector();
        globalDirs = new Vector();
        expirationWarningPeriod = 10;
        fileImportDirectory = System.getProperty("user.home");
        fileExportDirectory = System.getProperty("user.home");
        lastImportedCert = null;
        File inputFile = new File(envFile);
        FileInputStream inStream = new FileInputStream(inputFile);
        try {
            trustEnvASN1 = (SEQUENCE)DerCoder.decode((InputStream)inStream);
        }
        catch (CodingException e2) {
            throw new IOException("Could not decode the initialization file. ");
        }
        inStream.close();
        SEQUENCE initList = (SEQUENCE)trustEnvASN1.getComponentAt(0);
        OCTET_STRING saltString = (OCTET_STRING)trustEnvASN1.getComponentAt(1);
        OCTET_STRING hMACString = (OCTET_STRING)trustEnvASN1.getComponentAt(2);
        Integrity.updatePBEKey((byte[])saltString.getValue());
        if (!Integrity.compare(DerCoder.encode((ASN1Object)initList), (byte[])hMACString.getValue())) {
            throw new TrustmanagerException("Password incorrect. Can't load trust environment. ");
        }
        for (int i = 0; i < initList.countComponents(); ++i) {
            int j;
            String[] array;
            SEQUENCE entry = (SEQUENCE)initList.getComponentAt(i);
            UTF8String keyASN1 = (UTF8String)entry.getComponentAt(0);
            ASN1Object valueASN1 = entry.getComponentAt(1);
            String key = (String)keyASN1.getValue();
            if (key.equals("LocalDir")) {
                array = new String[5];
                for (j = 0; j < 5; ++j) {
                    array[j] = (String)((UTF8String)((SEQUENCE)valueASN1).getComponentAt(j)).getValue();
                }
                localDirs.addElement(array);
            }
            if (key.equals("GlobalDir")) {
                array = new String[5];
                for (j = 0; j < 5; ++j) {
                    array[j] = (String)((UTF8String)((SEQUENCE)valueASN1).getComponentAt(j)).getValue();
                }
                globalDirs.addElement(array);
            }
            if (key.equals("ExpirationWarning")) {
                String value = (String)((UTF8String)valueASN1).getValue();
                expirationWarningPeriod = Integer.valueOf(value);
            }
            if (key.equals("FileImportDirectory")) {
                fileImportDirectory = (String)((UTF8String)valueASN1).getValue();
            }
            if (key.equals("FileExportDirectory")) {
                fileExportDirectory = (String)((UTF8String)valueASN1).getValue();
            }
            if (key.equals("CertView")) {
                BigInteger bigInt = (BigInteger)((INTEGER)valueASN1).getValue();
                int viewInt = bigInt.intValue();
                viewCACerts = (viewInt & 1) != 0;
                viewEECerts = (viewInt & 2) != 0;
                viewLocalCerts = (viewInt & 4) != 0;
                viewLocalDirCerts = (viewInt & 8) != 0;
            }
            if (!key.equals("LastImportedCert")) continue;
            lastImportedCert = (byte[])((OCTET_STRING)valueASN1).getValue();
        }
        initialized = true;
        if (DEBUG) {
            System.out.println("iaik.apps.trustmanager.api.TrustEnv has now been loaded. ");
        }
    }

    public static String getHomeDirectory() {
        return homeDirectory;
    }

    public static synchronized void store() throws IOException {
        SEQUENCE keyAndValuePair;
        String[] array;
        SEQUENCE value;
        int i;
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        SEQUENCE initList = new SEQUENCE();
        int vectorSize = localDirs.size();
        for (i = 0; i < vectorSize; ++i) {
            value = new SEQUENCE();
            array = (String[])localDirs.elementAt(i);
            for (int j = 0; j < 5; ++j) {
                value.addComponent((ASN1Object)new UTF8String(array[j]));
            }
            keyAndValuePair = new SEQUENCE();
            keyAndValuePair.addComponent((ASN1Object)new UTF8String("LocalDir"));
            keyAndValuePair.addComponent((ASN1Object)value);
            initList.addComponent((ASN1Object)keyAndValuePair);
        }
        vectorSize = globalDirs.size();
        for (i = 0; i < vectorSize; ++i) {
            value = new SEQUENCE();
            array = (String[])globalDirs.elementAt(i);
            for (int j = 0; j < 5; ++j) {
                value.addComponent((ASN1Object)new UTF8String(array[j]));
            }
            keyAndValuePair = new SEQUENCE();
            keyAndValuePair.addComponent((ASN1Object)new UTF8String("GlobalDir"));
            keyAndValuePair.addComponent((ASN1Object)value);
            initList.addComponent((ASN1Object)keyAndValuePair);
        }
        SEQUENCE keyAndValuePair2 = new SEQUENCE();
        UTF8String nameASN1 = new UTF8String("ExpirationWarning");
        UTF8String valueASN1 = new UTF8String(String.valueOf(expirationWarningPeriod));
        keyAndValuePair2.addComponent((ASN1Object)nameASN1);
        keyAndValuePair2.addComponent((ASN1Object)valueASN1);
        initList.addComponent((ASN1Object)keyAndValuePair2);
        keyAndValuePair2 = new SEQUENCE();
        nameASN1 = new UTF8String("FileImportDirectory");
        valueASN1 = new UTF8String(fileImportDirectory);
        keyAndValuePair2.addComponent((ASN1Object)nameASN1);
        keyAndValuePair2.addComponent((ASN1Object)valueASN1);
        initList.addComponent((ASN1Object)keyAndValuePair2);
        keyAndValuePair2 = new SEQUENCE();
        nameASN1 = new UTF8String("FileExportDirectory");
        valueASN1 = new UTF8String(fileExportDirectory);
        keyAndValuePair2.addComponent((ASN1Object)nameASN1);
        keyAndValuePair2.addComponent((ASN1Object)valueASN1);
        initList.addComponent((ASN1Object)keyAndValuePair2);
        keyAndValuePair2 = new SEQUENCE();
        nameASN1 = new UTF8String("CertView");
        int viewInt = 0;
        if (viewCACerts) {
            ++viewInt;
        }
        if (viewEECerts) {
            viewInt += 2;
        }
        if (viewLocalCerts) {
            viewInt += 4;
        }
        if (viewLocalDirCerts) {
            viewInt += 8;
        }
        INTEGER intASN1 = new INTEGER(viewInt);
        keyAndValuePair2.addComponent((ASN1Object)nameASN1);
        keyAndValuePair2.addComponent((ASN1Object)intASN1);
        initList.addComponent((ASN1Object)keyAndValuePair2);
        if (lastImportedCert != null) {
            keyAndValuePair2 = new SEQUENCE();
            nameASN1 = new UTF8String("LastImportedCert");
            valueASN1 = new OCTET_STRING(lastImportedCert);
            keyAndValuePair2.addComponent((ASN1Object)nameASN1);
            keyAndValuePair2.addComponent((ASN1Object)valueASN1);
            initList.addComponent((ASN1Object)keyAndValuePair2);
        }
        byte[] saltMio = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 56, 55, 54, 53, 52, 51, 50};
        byte[] risultato = Integrity.updatePBEKey(saltMio);
        OCTET_STRING salt = new OCTET_STRING(Integrity.updatePBEKey(risultato));
        OCTET_STRING hMAC = new OCTET_STRING(Integrity.makeHMAC(DerCoder.encode((ASN1Object)initList)));
        SEQUENCE trustEnv = new SEQUENCE();
        trustEnv.addComponent((ASN1Object)initList);
        trustEnv.addComponent((ASN1Object)salt);
        trustEnv.addComponent((ASN1Object)hMAC);
        String backupFileName = envFile;
        backupFileName = backupFileName.substring(0, backupFileName.length() - 1);
        backupFileName = String.valueOf(backupFileName).concat(String.valueOf("~"));
        File oldBackupFile = new File(backupFileName);
        oldBackupFile.delete();
        File newBackupFile = new File(envFile);
        newBackupFile.renameTo(oldBackupFile);
        File newTrustEnvFile = new File(envFile);
        FileOutputStream outStream = new FileOutputStream(newTrustEnvFile);
        DerCoder.encodeTo((ASN1Object)trustEnv, (OutputStream)outStream);
        outStream.flush();
        outStream.close();
        if (DEBUG) {
            System.out.println("TrustEnv successfully written to disk. ");
        }
    }

    public static int getExpirationWarningPeriod() {
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        return expirationWarningPeriod;
    }

    public static void setExpirationWarningPeriod(int days) {
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        expirationWarningPeriod = days;
    }

    public static String getImportDirectory() {
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        return fileImportDirectory;
    }

    public static String getExportDirectory() {
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        return fileExportDirectory;
    }

    public static void setImportDirectory(String dir) {
        if (dir == null) {
            throw new NullPointerException("Directory name must be specified. ");
        }
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        fileImportDirectory = dir.trim();
    }

    public static void setExportDirectory(String dir) {
        if (dir == null) {
            throw new NullPointerException("Filename must be specified. ");
        }
        if (!initialized) {
            throw new InternalErrorException("Trust Environment is not initialized. ");
        }
        fileExportDirectory = dir.trim();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String[][] getLocalDirectories() {
        String[][] array = new String[localDirs.size()][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String[])localDirs.elementAt(i);
        }
        return array;
    }

    public static void addLocalDirectory(String url, String dn, String userName, char[] pwd, String version) {
        if (url == null || url.length() == 0) {
            throw new NullPointerException("URL must be specified. ");
        }
        if (dn == null || dn.length() == 0) {
            dn = String.valueOf(' ');
        }
        if (userName == null || userName.length() == 0) {
            userName = String.valueOf(' ');
        }
        if (pwd == null || pwd.length == 0) {
            pwd = null;
        }
        if (version == null || version.length() == 0) {
            version = String.valueOf(' ');
        }
        String[] array = new String[]{TrustmanagerUtils.adaptURLString(url), dn, userName, pwd == null ? String.valueOf(' ') : new String(pwd), version};
        localDirs.addElement(array);
    }

    public static void removeLocalDirectory(int index) {
        localDirs.removeElementAt(index);
    }

    public static void swapLocalDirectories(int one, int two) {
        Object obj = localDirs.elementAt(one);
        localDirs.setElementAt(localDirs.elementAt(two), one);
        localDirs.setElementAt(obj, two);
    }

    public static String[][] getGlobalDirectories() {
        String[][] array = new String[globalDirs.size()][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (String[])globalDirs.elementAt(i);
        }
        return array;
    }

    public static void addGlobalDirectory(String url, String dn, String userName, char[] pwd, String version) {
        if (url == null || url.length() == 0) {
            throw new NullPointerException("URL must be specified. ");
        }
        if (dn == null || dn.length() == 0) {
            dn = String.valueOf(' ');
        }
        if (userName == null || userName.length() == 0) {
            userName = String.valueOf(' ');
        }
        if (pwd == null || pwd.length == 0) {
            pwd = null;
        }
        if (version == null || version.length() == 0) {
            version = String.valueOf(' ');
        }
        String[] array = new String[]{TrustmanagerUtils.adaptURLString(url), dn, userName, pwd == null ? String.valueOf(' ') : new String(pwd), version};
        globalDirs.addElement(array);
    }

    public static void removeGlobalDirectory(int index) {
        globalDirs.removeElementAt(index);
    }

    public static void swapGlobalDirectories(int one, int two) {
        Object obj = globalDirs.elementAt(one);
        globalDirs.setElementAt(globalDirs.elementAt(two), one);
        globalDirs.setElementAt(obj, two);
    }

    public static void setViewCACerts(boolean value) {
        viewCACerts = value;
    }

    public static void setViewEECerts(boolean value) {
        viewEECerts = value;
    }

    public static void setViewLocalCerts(boolean value) {
        viewLocalCerts = value;
    }

    public static void setViewLocalDirCerts(boolean value) {
        viewLocalDirCerts = value;
    }

    public static boolean isViewCACerts() {
        return viewCACerts;
    }

    public static boolean isViewEECerts() {
        return viewEECerts;
    }

    public static boolean isViewLocalCerts() {
        return viewLocalCerts;
    }

    public static boolean isViewLocalDirCerts() {
        return viewLocalDirCerts;
    }

    static {
        viewCACerts = true;
        viewEECerts = true;
        viewLocalCerts = true;
        viewLocalDirCerts = false;
    }
}

