/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.util;

import cybertrust2.CTException;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.security.rsa.RSAKeyPairGenerator;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509Extensions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.Vector;

public class Util {
    static int a;

    public static X509Certificate[] convertCertificates(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            x509CertificateArray[i] = Util.convertCertificate(certificateArray[i]);
        }
        return x509CertificateArray;
    }

    public static X509Certificate convertCertificate(Certificate certificate) throws CertificateException {
        if (certificate == null) {
            return null;
        }
        return new X509Certificate(certificate.getEncoded());
    }

    public static Date today() {
        return new Date();
    }

    public static X509Certificate createCertificate(Name name, PublicKey publicKey, Name name2, PrivateKey privateKey, BigInteger bigInteger, AlgorithmID algorithmID, int n) {
        return Util.createCertificate(name, publicKey, name2, privateKey, bigInteger, algorithmID, n, null);
    }

    public static X509Certificate createCertificate(Name name, PublicKey publicKey, Name name2, PrivateKey privateKey, BigInteger bigInteger, AlgorithmID algorithmID, int n, X509Extensions x509Extensions) {
        X509Certificate x509Certificate = new X509Certificate();
        try {
            x509Certificate.setSerialNumber(bigInteger);
            x509Certificate.setSubjectDN((Principal)name);
            x509Certificate.setPublicKey(publicKey);
            x509Certificate.setIssuerDN((Principal)name2);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            x509Certificate.setValidNotBefore(gregorianCalendar.getTime());
            gregorianCalendar.add(2, n);
            x509Certificate.setValidNotAfter(gregorianCalendar.getTime());
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.listExtensions();
                while (enumeration.hasMoreElements()) {
                    x509Certificate.addExtension((V3Extension)enumeration.nextElement());
                }
            }
            x509Certificate.sign(algorithmID, privateKey);
        }
        catch (Exception exception) {
            throw new RuntimeException(String.valueOf(Util.a("1a2<zTp26i\u0000z.4(\u0000{%sk\u0011a4:n\u001dp!'mN3")).concat(String.valueOf(exception.getMessage())));
        }
        return x509Certificate;
    }

    public static KeyPair newKeyPair() {
        return Util.newKeyPair(Util.a("&@\u0001"), 1024);
    }

    public static KeyPair newKeyPair(String string, int n) {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(string, Util.a("=R\t\u0018"));
        }
        catch (Exception exception) {
            KeyPair keyPair = null;
            return keyPair;
        }
        keyPairGenerator.initialize(n);
        return ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
    }

    public static KeyPair newKeyPair(byte[] byArray, int n) {
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        rSAKeyPairGenerator.initialize(n, new BigInteger(byArray), new SecureRandom());
        return rSAKeyPairGenerator.generateKeyPair();
    }

    public static X509Certificate[] newCertificateChain(KeyPair keyPair, Name name) {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{Util.createCertificate(name, keyPair.getPublic(), name, keyPair.getPrivate(), new BigInteger(128, new Random()), AlgorithmID.sha1WithRSAEncryption, 12, null)};
        return x509CertificateArray;
    }

    public static X509Certificate[] newCertificateChain(PublicKey publicKey, Name name, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        return Util.newCertificateChain(publicKey, name, privateKey, x509CertificateArray, null);
    }

    public static X509Certificate[] newCertificateChain(PublicKey publicKey, Name name, PrivateKey privateKey, X509Certificate[] x509CertificateArray, X509Extensions x509Extensions) {
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray2[i + 1] = x509CertificateArray[i];
        }
        Name name2 = (Name)x509CertificateArray[0].getSubjectDN();
        x509CertificateArray2[0] = Util.createCertificate(name, publicKey, name2, privateKey, new BigInteger(128, new Random()), AlgorithmID.sha1WithRSAEncryption, 12, x509Extensions);
        return x509CertificateArray2;
    }

    public static String ask(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(string);
        String string2 = "";
        while (string2.equals("")) {
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    public static X509Certificate[] addCertsTo(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        int n;
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        if (x509CertificateArray != null) {
            for (n = 0; n < x509CertificateArray.length; ++n) {
                if (x509CertificateArray[n] == null || vector.contains(x509CertificateArray[n])) continue;
                vector.addElement(x509CertificateArray[n]);
            }
        }
        if (x509CertificateArray2 != null) {
            for (n = 0; n < x509CertificateArray2.length; ++n) {
                if (x509CertificateArray2[n] == null || vector.contains(x509CertificateArray2[n])) continue;
                vector.addElement(x509CertificateArray2[n]);
            }
        }
        X509Certificate[] x509CertificateArray3 = new X509Certificate[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            x509CertificateArray3[n2] = (X509Certificate)enumeration.nextElement();
            ++n2;
        }
        return x509CertificateArray3;
    }

    public static X509Certificate[] sortCertificateChain(X509Certificate[] x509CertificateArray) throws CTException {
        int n;
        int n2;
        int[] nArray;
        int n3;
        int n4;
        block16: {
            int n5;
            boolean[] blArray;
            block15: {
                int n6;
                n4 = a;
                int n7 = x509CertificateArray.length;
                if (n4 == 0) {
                    if (n7 == 1) {
                        return x509CertificateArray;
                    }
                    n7 = x509CertificateArray.length;
                }
                n3 = n7;
                nArray = new int[n3];
                blArray = new boolean[n3];
                Name name = null;
                n2 = 0;
                block0: while (true) {
                    int n8 = n2;
                    block1: while (n8 < n3) {
                        nArray[n2] = -1;
                        name = (Name)x509CertificateArray[n2].getIssuerDN();
                        n6 = 0;
                        if (n4 != 0) break block15;
                        for (n5 = v43183; n5 < n3; ++n5) {
                            n8 = name.equals((Object)((Name)x509CertificateArray[n5].getSubjectDN())) ? 1 : 0;
                            if (n4 != 0) continue block1;
                            if (n8 == 0) continue;
                            nArray[n2] = n5;
                            blArray[n5] = true;
                            if (n4 == 0) continue;
                        }
                        ++n2;
                        if (n4 == 0) continue block0;
                    }
                    break;
                }
                n2 = -1;
                n6 = n5 = 0;
            }
            while (n5 < n3) {
                block18: {
                    int n9;
                    block19: {
                        block17: {
                            n = blArray[n5];
                            if (n4 != 0) break block16;
                            if (n4 != 0) break block17;
                            if (n != 0) break block18;
                            n9 = n2;
                            if (n4 != 0) break block19;
                        }
                        if (n9 != -1) {
                            throw new CTException(Util.a(" {%sd\u001d`4sg\u00123#6z\u0000z&:k\u0015g% (\u0007{/&d\u00103#<f\u0000r)=(\u001b},*(E3#6z\u0000z&:k\u0015g%s{\u001dt.:f\u00133.<(\u001bg(6zTp%!|\u001du)0i\u0000v3"));
                        }
                        n9 = n5;
                    }
                    n2 = n9;
                }
                ++n5;
                if (n4 == 0) continue;
            }
            n = n2;
        }
        if (n4 == 0) {
            if (n == -1) {
                throw new CTException(Util.a(" {%sd\u001d`4sg\u00123#6z\u0000z&:k\u0015g% (\u0007{/&d\u00103#<f\u0000r)=(\u001b},*(E3#6z\u0000z&:k\u0015g%s{\u001dt.:f\u00133.<(\u001bg(6zTp%!|\u001du)0i\u0000v3"));
            }
            n = n3;
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[n];
        for (int i = 0; i < n3; ++i) {
            int n10 = n2;
            if (n4 == 0) {
                if (n10 == -1) {
                    throw new CTException(Util.a("7r.=g\u0000326g\u0006w%!(\u0017v2'a\u0012z#2|\u0011`nsK\u001cr)=(\u001a|4sd\u001d}%2zZ"));
                }
                x509CertificateArray2[i] = x509CertificateArray[n2];
                n10 = nArray[n2];
            }
            n2 = n10;
            if (n4 == 0) continue;
        }
        return x509CertificateArray2;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 116;
                        break;
                    }
                    case 1: {
                        n4 = 19;
                        break;
                    }
                    case 2: {
                        n4 = 64;
                        break;
                    }
                    case 3: {
                        n4 = 83;
                        break;
                    }
                    default: {
                        n4 = 8;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

