/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.smartcard;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import cybertrust2.smartcard.SmartCardException;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.security.PublicKey;

public class SmartCardObject {
    private static final String a = "v%P\b\u0019t;U";
    private static final String b = "w:O\b\u000fk9P\b\u0007";
    private PKCS11Object c;
    public static final Integer DATA = PKCS11Object.DATA;
    public static final Integer CERTIFICATE = PKCS11Object.CERTIFICATE;
    public static final Integer PUBLIC_KEY = PKCS11Object.PUBLIC_KEY;
    public static final Integer PRIVATE_KEY = PKCS11Object.PRIVATE_KEY;
    public static final Integer SECRET_KEY = PKCS11Object.SECRET_KEY;
    public static final Integer CERTIFICATE_X509 = PKCS11Object.X_509;
    public static final Integer RSA = PKCS11Object.RSA;
    public static final Integer DSA = PKCS11Object.DSA;
    public static final Integer DH = PKCS11Object.DH;
    public static final Integer ECDSA = PKCS11Object.ECDSA;
    public static final Integer MAYFLY = PKCS11Object.MAYFLY;
    public static final Integer KEA = PKCS11Object.KEA;
    public static final Integer GENERIC_SECRET = PKCS11Object.GENERIC_SECRET;
    public static final Integer RC2 = PKCS11Object.RC2;
    public static final Integer RC4 = PKCS11Object.RC4;
    public static final Integer DES = PKCS11Object.DES;
    public static final Integer DES2 = PKCS11Object.DES2;
    public static final Integer DES3 = PKCS11Object.DES3;
    public static final Integer CAST3 = PKCS11Object.CAST3;
    public static final Integer CAST5 = PKCS11Object.CAST5;
    public static final Integer RC5 = PKCS11Object.RC5;
    public static final Integer IDEA = PKCS11Object.IDEA;
    public static final Integer SKIPJACK = PKCS11Object.SKIPJACK;
    public static final Integer BATON = PKCS11Object.BATON;
    public static final Integer JUNIPER = PKCS11Object.JUNIPER;
    public static final Integer CDMF = PKCS11Object.CDMF;

    public String getVersionClass() {
        return SmartCardObject.a(a);
    }

    public String getDateClass() {
        return SmartCardObject.a(b);
    }

    public SmartCardObject(PKCS11Object pKCS11Object) {
        this.c = pKCS11Object;
    }

    public PKCS11Object getPKCS11Object() throws PKCS11Exception {
        return this.c;
    }

    public int getClassType() throws PKCS11Exception {
        return this.c.getIntAttributeValue(0);
    }

    public byte[] getAlias() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(258);
    }

    public String getLabel() throws PKCS11Exception {
        return this.c.getStringAttributeValue(3);
    }

    public BigInteger getCoefficient() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(296);
    }

    public BigInteger getExponentQ() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(295);
    }

    public BigInteger getExponentP() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(294);
    }

    public BigInteger getPrimeP() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(292);
    }

    public BigInteger getPrimeQ() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(293);
    }

    public BigInteger getPrivateExponent() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(291);
    }

    public String getApplication() throws PKCS11Exception {
        return this.c.getStringAttributeValue(16);
    }

    public boolean isRSAPrivateKey() throws PKCS11Exception {
        Integer n = new Integer(this.getClassType());
        Integer n2 = new Integer(this.getKeyType());
        return n == PRIVATE_KEY && n2 == RSA;
    }

    public boolean isToken() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(1);
    }

    public boolean isPrivate() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(2);
    }

    public byte[] getValue() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(17);
    }

    public int getCertificateType() throws PKCS11Exception {
        return this.c.getIntAttributeValue(128);
    }

    public int getKeyType() throws PKCS11Exception {
        return this.c.getIntAttributeValue(256);
    }

    public byte[] getIssuer() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(129);
    }

    public byte[] getSerialNumber() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(130);
    }

    public byte[] getSubject() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(257);
    }

    public boolean isModifiable() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(368);
    }

    public int getSize() throws SmartCardException, PKCS11Exception {
        throw new SmartCardException(5);
    }

    public boolean isExtractable() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(354);
    }

    public boolean isNeverExtractable() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(356);
    }

    public boolean isLocal() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(355);
    }

    public boolean isAlwaysSensitive() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(357);
    }

    public boolean isSensitive() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(259);
    }

    public boolean isEncrypt() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(260);
    }

    public boolean isWrap() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(262);
    }

    public boolean isUnwrap() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(263);
    }

    public boolean isVerify() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(266);
    }

    public boolean isVerifyRecover() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(267);
    }

    public boolean isDerive() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(268);
    }

    public boolean isSign() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(264);
    }

    public boolean isSignRecover() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(265);
    }

    public boolean isDecrypt() throws PKCS11Exception {
        return this.c.getBoolAttributeValue(261);
    }

    public byte[] getStartDate() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(272);
    }

    public byte[] getEndDate() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(273);
    }

    public byte[] getModulus() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(288);
    }

    public BigInteger getModulusBigInteger() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(288);
    }

    public int getModulusBits() throws PKCS11Exception {
        return this.c.getIntAttributeValue(289);
    }

    public byte[] getPublicExponent() throws PKCS11Exception {
        return this.c.getByteArrayAttributeValue(290);
    }

    public BigInteger getPublicExponentBigInteger() throws PKCS11Exception {
        return this.c.getBigIntegerAttributeValue(290);
    }

    public void setAlias(byte[] byArray) throws PKCS11Exception {
        int[] nArray = new int[]{258};
        Object[] objectArray = new Object[]{byArray};
        this.c.setAttributeValues(nArray, objectArray);
    }

    public void setLabel(String string) throws PKCS11Exception {
        int[] nArray = new int[]{3};
        Object[] objectArray = new Object[]{string};
        this.c.setAttributeValues(nArray, objectArray);
    }

    public void setSubject(byte[] byArray) throws PKCS11Exception {
        int[] nArray = new int[]{257};
        Object[] objectArray = new Object[]{byArray};
        this.c.setAttributeValues(nArray, objectArray);
    }

    public void setAttributeValues(int[] nArray, Object[] objectArray) throws PKCS11Exception {
        this.c.setAttributeValues(nArray, objectArray);
    }

    public int delete() throws PKCS11Exception {
        this.c.destroy();
        return 1;
    }

    public byte[] toByteArray() throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.getValue();
        return byArray;
    }

    public X509Certificate toX509Certificate() throws PKCS11Exception {
        try {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = x509Certificate = new X509Certificate(this.getValue());
            return x509Certificate2;
        }
        catch (Exception exception) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
    }

    public PublicKey toRSAPublicKey() throws PKCS11Exception {
        BigInteger bigInteger = this.getModulusBigInteger();
        BigInteger bigInteger2 = this.getPublicExponentBigInteger();
        return new RSAPublicKey(bigInteger, bigInteger2);
    }

    public RSAPrivateKey toRSAPrivateKey() throws PKCS11Exception {
        BigInteger bigInteger = this.getModulusBigInteger();
        BigInteger bigInteger2 = this.getPrivateExponent();
        byte[] byArray = bigInteger2.toByteArray();
        byte[] byArray2 = new byte[]{1, 0, 1};
        BigInteger bigInteger3 = new BigInteger(byArray2);
        BigInteger bigInteger4 = this.getPrimeP();
        BigInteger bigInteger5 = this.getPrimeQ();
        BigInteger bigInteger6 = this.getExponentP();
        BigInteger bigInteger7 = this.getExponentQ();
        BigInteger bigInteger8 = this.getCoefficient();
        return new RSAPrivateKey(bigInteger, bigInteger3, bigInteger2, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 68;
                        break;
                    }
                    case 1: {
                        n4 = 11;
                        break;
                    }
                    case 2: {
                        n4 = 96;
                        break;
                    }
                    case 3: {
                        n4 = 56;
                        break;
                    }
                    default: {
                        n4 = 55;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

