/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.smartcard;

import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import cybertrust2.CTException;
import cybertrust2.smartcard.SmartCardException;
import cybertrust2.smartcard.SmartCardMechanism;
import cybertrust2.smartcard.SmartCardObject;
import cybertrust2.smartcard.SmartCardVersion;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class SmartCard {
    private static final String a = "5\u0003;\u001d97\u001f9";
    private static final String b = "4\u001c$\u001d/(\u001f;\u001d'";
    private PKCS11Session c;
    private PKCS11Slot d;
    private int e;
    public static final int RO_PUBLIC_SESSION = 0;
    public static final int RO_USER_FUNCTIONS = 1;
    public static final int RW_PUBLIC_SESSION = 2;
    public static final int RW_USER_FUNCTIONS = 3;
    public static final int RW_SO_FUNCTIONS = 4;
    public static final int EXCLUSIVE_SESSION = 1;
    public static final int RW_SESSION = 2;
    static boolean f;

    public String getClassVersion() {
        return SmartCard.a(a);
    }

    public String getClassDate() {
        return SmartCard.a(b);
    }

    public SmartCard(PKCS11Slot pKCS11Slot, int n) {
        this.d = pKCS11Slot;
        this.e = n;
        this.c = null;
    }

    public boolean isPresent() throws PKCS11Exception {
        return this.d.getInfo().tokenPresent();
    }

    public boolean isOpened() throws SmartCardException, PKCS11Exception {
        if (this.c == null) {
            return false;
        }
        int n = this.c.getInfo().state();
        return this.c != null && n >= 0 && n <= 4;
    }

    public boolean isLogined() throws SmartCardException, PKCS11Exception {
        int n = this.c.getInfo().state();
        return this.isOpened() && (n == 1 || n == 3 || n == 4);
    }

    public int getState() throws SmartCardException, PKCS11Exception {
        if (!this.isOpened()) {
            throw new SmartCardException(12);
        }
        return this.c.getInfo().state();
    }

    public boolean isReadOnlySession() throws SmartCardException, PKCS11Exception {
        return this.c.getInfo().state() != 2;
    }

    public boolean isExclusiveSession() throws PKCS11Exception {
        return this.c.getInfo().state() == 1;
    }

    public boolean isValidSession() throws SmartCardException, PKCS11Exception {
        int n = this.c.getInfo().deviceError();
        String string = this.getInfo();
        string = this.getInfo();
        string = this.getInfo();
        return n == 0;
    }

    public int getSlotNumber() throws PKCS11Exception {
        return this.e;
    }

    public String getInfo() throws PKCS11Exception {
        return this.c.getInfo().toString();
    }

    public SmartCardVersion getFirmwareVersion() throws PKCS11Exception {
        return new SmartCardVersion(this.d.getTokenInfo().firmwareVersion());
    }

    public int getFreePrivateMemory() throws PKCS11Exception {
        return this.d.getTokenInfo().freePrivateMemory();
    }

    public int getFreePublicMemory() throws PKCS11Exception {
        return this.d.getTokenInfo().freePublicMemory();
    }

    public SmartCardVersion getHardwareVersion() throws PKCS11Exception {
        return new SmartCardVersion(this.d.getTokenInfo().hardwareVersion());
    }

    public String getManufacturer() throws PKCS11Exception {
        return this.d.getTokenInfo().manufacturer();
    }

    public String getModel() throws PKCS11Exception {
        return this.d.getTokenInfo().model();
    }

    public String getSerialNumber() throws PKCS11Exception {
        return this.d.getTokenInfo().serialNumber();
    }

    public int getTotalPrivateMemory() throws PKCS11Exception {
        return this.d.getTokenInfo().totalPrivateMemory();
    }

    public int getTotalPublicMemory() throws PKCS11Exception {
        return this.d.getTokenInfo().totalPublicMemory();
    }

    public SmartCardMechanism[] getMechanism() throws PKCS11Exception {
        int[] nArray = this.d.getMechanismList();
        Vector<SmartCardMechanism> vector = new Vector<SmartCardMechanism>();
        for (int i = 0; i < nArray.length; ++i) {
            vector.addElement(new SmartCardMechanism(nArray[i], this.d.getMechanismInfo(nArray[i]).flags(), this.d.getMechanismInfo(nArray[i]).minKeySize(), this.d.getMechanismInfo(nArray[i]).maxKeySize()));
        }
        Object[] objectArray = new SmartCardMechanism[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SmartCardMechanism[] getSignMechanism() throws PKCS11Exception {
        SmartCardMechanism[] smartCardMechanismArray = this.getMechanism();
        Vector<SmartCardMechanism> vector = new Vector<SmartCardMechanism>();
        for (int i = 0; i < smartCardMechanismArray.length; ++i) {
            if (!smartCardMechanismArray[i].isSign()) continue;
            vector.addElement(smartCardMechanismArray[i]);
        }
        Object[] objectArray = new SmartCardMechanism[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SmartCardMechanism[] getVerifyMechanism() throws PKCS11Exception {
        SmartCardMechanism[] smartCardMechanismArray = this.getMechanism();
        Vector<SmartCardMechanism> vector = new Vector<SmartCardMechanism>();
        for (int i = 0; i < smartCardMechanismArray.length; ++i) {
            if (!smartCardMechanismArray[i].isVerify()) continue;
            vector.addElement(smartCardMechanismArray[i]);
        }
        Object[] objectArray = new SmartCardMechanism[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SmartCardMechanism[] getEncryptMechanism() throws PKCS11Exception {
        SmartCardMechanism[] smartCardMechanismArray = this.getMechanism();
        Vector<SmartCardMechanism> vector = new Vector<SmartCardMechanism>();
        for (int i = 0; i < smartCardMechanismArray.length; ++i) {
            if (!smartCardMechanismArray[i].isEncrypt()) continue;
            vector.addElement(smartCardMechanismArray[i]);
        }
        Object[] objectArray = new SmartCardMechanism[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SmartCardMechanism[] getDecryptMechanism() throws PKCS11Exception {
        SmartCardMechanism[] smartCardMechanismArray = this.getMechanism();
        Vector<SmartCardMechanism> vector = new Vector<SmartCardMechanism>();
        for (int i = 0; i < smartCardMechanismArray.length; ++i) {
            if (!smartCardMechanismArray[i].isDecrypt()) continue;
            vector.addElement(smartCardMechanismArray[i]);
        }
        Object[] objectArray = new SmartCardMechanism[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SmartCardMechanism[] getGenerateKeyPairMechanism() throws PKCS11Exception {
        SmartCardMechanism[] smartCardMechanismArray = this.getMechanism();
        Vector<SmartCardMechanism> vector = new Vector<SmartCardMechanism>();
        for (int i = 0; i < smartCardMechanismArray.length; ++i) {
            if (!smartCardMechanismArray[i].isGenerateKeyPair()) continue;
            vector.addElement(smartCardMechanismArray[i]);
        }
        Object[] objectArray = new SmartCardMechanism[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void open(boolean bl, boolean bl2) throws SmartCardException, PKCS11Exception {
        if (!this.isPresent()) {
            throw new SmartCardException(3);
        }
        int n = 4 | (bl ? 0 : 2) | (bl2 ? 1 : 0);
        this.c = this.d.openSession(n, null, null);
    }

    public void close() throws PKCS11Exception {
        this.c.close();
        this.c = null;
    }

    public void loginSO(String string) throws PKCS11Exception {
        this.c.login(true, string);
    }

    public void login(String string) throws PKCS11Exception {
        this.c.login(false, string);
    }

    public void logout() throws PKCS11Exception {
        this.c.logout();
    }

    public void changePIN(String string, String string2) throws PKCS11Exception {
        this.c.setPIN(string, string2);
    }

    public void initPIN(String string) throws PKCS11Exception {
        this.c.initPIN(string);
    }

    public KeyPair toKeyPair(SmartCardObject smartCardObject, SmartCardObject smartCardObject2) throws PKCS11Exception {
        PublicKey publicKey = smartCardObject.toRSAPublicKey();
        RSAPrivateKey rSAPrivateKey = smartCardObject2.toRSAPrivateKey();
        return new KeyPair(publicKey, (PrivateKey)rSAPrivateKey);
    }

    private int a(int n, Object object, Object object2) throws PKCS11Exception {
        int[] nArray = new int[]{n};
        Object[] objectArray = new Object[]{object};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        objectArray[0] = object2;
        int n2 = 0;
        for (n2 = 0; n2 < smartCardObjectArray.length; ++n2) {
            smartCardObjectArray[n2].setAttributeValues(nArray, objectArray);
        }
        return n2;
    }

    public int changeAlias(byte[] byArray, byte[] byArray2) throws PKCS11Exception {
        return this.a(258, byArray, byArray2);
    }

    public int changeAlias(X509Certificate x509Certificate, byte[] byArray) throws SmartCardException, PKCS11Exception {
        SmartCardObject smartCardObject;
        int n = 0;
        SmartCardObject smartCardObject2 = this.getPublicKey(x509Certificate);
        if (smartCardObject2 != null) {
            smartCardObject2.setAlias(byArray);
            ++n;
        }
        if ((smartCardObject = this.getPrivateKey(x509Certificate)) != null) {
            smartCardObject.setAlias(byArray);
            ++n;
        }
        return n;
    }

    public int changeLabel(String string, String string2) throws PKCS11Exception {
        return this.a(3, string, string2);
    }

    public int changeSubject(X509Certificate x509Certificate, byte[] byArray) throws SmartCardException, PKCS11Exception {
        SmartCardObject smartCardObject;
        int n = 0;
        SmartCardObject smartCardObject2 = this.getPublicKey(x509Certificate);
        if (smartCardObject2 != null) {
            smartCardObject2.setSubject(byArray);
            ++n;
        }
        if ((smartCardObject = this.getPrivateKey(x509Certificate)) != null) {
            smartCardObject.setSubject(byArray);
            ++n;
        }
        return n;
    }

    public int changeSubject(String string, String string2) throws PKCS11Exception {
        return this.a(257, string, string2);
    }

    private SmartCardObject[] a(int[] nArray, Object[] objectArray) throws PKCS11Exception {
        PKCS11Object pKCS11Object;
        Vector<SmartCardObject> vector = new Vector<SmartCardObject>();
        this.c.findObjectsInit(nArray, objectArray);
        do {
            if ((pKCS11Object = this.c.findObject()) == null) continue;
            vector.addElement(new SmartCardObject(pKCS11Object));
        } while (pKCS11Object != null);
        this.c.findObjectsFinal();
        Object[] objectArray2 = new SmartCardObject[vector.size()];
        vector.copyInto(objectArray2);
        return objectArray2;
    }

    public SmartCardObject[] getObjects() throws PKCS11Exception {
        return this.a(null, null);
    }

    public SmartCardObject[] getObjects(byte[] byArray) throws PKCS11Exception {
        int[] nArray = new int[]{1, 258};
        Object[] objectArray = new Object[]{Boolean.TRUE, byArray};
        return this.a(nArray, objectArray);
    }

    public SmartCardObject[] getPrivateKeys(byte[] byArray) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{2, 1, 259, 258};
        Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, byArray};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        return smartCardObjectArray;
    }

    public SmartCardObject getPrivateKey(byte[] byArray, int n) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 2, 1, 258};
        Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, byArray};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        if (smartCardObjectArray.length > 1) {
            throw new SmartCardException(9);
        }
        return smartCardObjectArray.length > 0 && smartCardObjectArray[0] != null ? smartCardObjectArray[0] : null;
    }

    public SmartCardObject getPublicKey(byte[] byArray) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 2, 1};
        Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, Boolean.FALSE, Boolean.TRUE};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        for (int i = 0; i < smartCardObjectArray.length; ++i) {
            BigInteger bigInteger = smartCardObjectArray[i].getModulusBigInteger();
            byte[] byArray2 = bigInteger.toByteArray();
            int n = byArray2.length;
            int n2 = 0;
            int n3 = 0;
            n3 = 0;
            for (n2 = 0; n2 < byArray.length && n3 < n; ++n2) {
                if (byArray[n2] == byArray2[n3]) {
                    ++n3;
                    continue;
                }
                n3 = 0;
            }
            if (n3 != n) continue;
            return smartCardObjectArray[i];
        }
        return null;
    }

    public SmartCardObject getPublicKey(X509Certificate x509Certificate) throws SmartCardException, PKCS11Exception {
        return this.getPublicKey(x509Certificate.toByteArray());
    }

    public SmartCardObject getPrivateKey(X509Certificate x509Certificate) throws SmartCardException, PKCS11Exception {
        boolean bl = f;
        int[] nArray = new int[]{0, 2, 1};
        Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        byte[] byArray = x509Certificate.toByteArray();
        for (int i = 0; i < smartCardObjectArray.length; ++i) {
            int n;
            int n2;
            block5: {
                BigInteger bigInteger = smartCardObjectArray[i].getModulusBigInteger();
                byte[] byArray2 = bigInteger.toByteArray();
                int n3 = byArray2.length;
                int n4 = 0;
                int n5 = 0;
                n5 = 0;
                for (n4 = 0; n4 < byArray.length; ++n4) {
                    n2 = n5;
                    n = n3;
                    if (!bl && !bl) {
                        if (n2 >= n) break;
                        int n6 = byArray[n4];
                        if (!bl) {
                            if (n6 == byArray2[n5]) {
                                ++n5;
                                if (!bl) continue;
                            }
                            n6 = 0;
                        }
                        n5 = n6;
                        if (!bl) continue;
                    }
                    break block5;
                }
                n2 = n5;
                n = n3;
            }
            if (n2 != n) continue;
            return smartCardObjectArray[i];
        }
        return null;
    }

    public SmartCardObject[] getPublicKeys(byte[] byArray) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 2, 1, 258};
        Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, Boolean.FALSE, Boolean.TRUE, byArray};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        return smartCardObjectArray;
    }

    public SmartCardObject getPublicKey(byte[] byArray, int n) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 2, 1, 258, 289};
        Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, Boolean.FALSE, Boolean.TRUE, byArray, new Integer(n)};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        if (smartCardObjectArray.length > 1) {
            throw new SmartCardException(5);
        }
        return smartCardObjectArray.length > 0 && smartCardObjectArray[0] != null ? smartCardObjectArray[0] : null;
    }

    public SmartCardObject getCertificate(byte[] byArray) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 1, 128, 258};
        Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE, Boolean.TRUE, PKCS11Object.X_509, byArray};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        if (smartCardObjectArray.length > 1) {
            throw new SmartCardException(9);
        }
        return smartCardObjectArray.length > 0 && smartCardObjectArray[0] != null ? smartCardObjectArray[0] : null;
    }

    public SmartCardObject getData(byte[] byArray, String string) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 1, 16, 3};
        Object[] objectArray = new Object[]{PKCS11Object.DATA, Boolean.TRUE, string, new String(byArray)};
        SmartCardObject[] smartCardObjectArray = this.a(nArray, objectArray);
        if (smartCardObjectArray.length > 1) {
            throw new SmartCardException(9);
        }
        return smartCardObjectArray.length > 0 && smartCardObjectArray[0] != null ? smartCardObjectArray[0] : null;
    }

    public int deleteObjects(int[] nArray, Object[] objectArray) throws PKCS11Exception {
        PKCS11Object pKCS11Object;
        int n = 0;
        do {
            this.c.findObjectsInit(nArray, objectArray);
            pKCS11Object = this.c.findObject();
            if (pKCS11Object == null) continue;
            ++n;
            pKCS11Object.destroy();
        } while (pKCS11Object != null);
        this.c.findObjectsFinal();
        return n;
    }

    public int deleteObjects() throws PKCS11Exception {
        return this.deleteObjects(null, null);
    }

    public int deleteObjects(byte[] byArray) throws PKCS11Exception {
        int[] nArray = new int[]{1, 258};
        Object[] objectArray = new Object[]{Boolean.TRUE, byArray};
        return this.deleteObjects(nArray, objectArray);
    }

    public int deletePublicKey(byte[] byArray, int n) throws SmartCardException, PKCS11Exception {
        SmartCardObject smartCardObject = this.getPublicKey(byArray, n);
        if (smartCardObject != null) {
            smartCardObject.delete();
            return 1;
        }
        return 0;
    }

    public int deletePrivateKey(byte[] byArray, int n) throws SmartCardException, PKCS11Exception {
        SmartCardObject smartCardObject = this.getPrivateKey(byArray, n);
        if (smartCardObject != null) {
            smartCardObject.delete();
            return 1;
        }
        return 0;
    }

    public int deleteKeyPair(byte[] byArray, int n) throws SmartCardException, PKCS11Exception {
        int n2 = 0;
        this.deletePublicKey(byArray, n);
        ++n2;
        this.deletePrivateKey(byArray, n);
        return ++n2;
    }

    public int deleteCertificate(byte[] byArray) throws SmartCardException, PKCS11Exception {
        SmartCardObject smartCardObject = this.getCertificate(byArray);
        if (smartCardObject != null) {
            smartCardObject.delete();
            return 1;
        }
        return 0;
    }

    public int deleteData(byte[] byArray, String string) throws SmartCardException, PKCS11Exception {
        SmartCardObject smartCardObject = this.getData(byArray, string);
        if (smartCardObject != null) {
            smartCardObject.delete();
            return 1;
        }
        return 0;
    }

    public SmartCardObject saveObject(int[] nArray, Object[] objectArray) throws SmartCardException, PKCS11Exception {
        return new SmartCardObject(this.c.createObject(nArray, objectArray));
    }

    public SmartCardObject saveRSAPublicKey(RSAPublicKey rSAPublicKey, byte[] byArray) throws SmartCardException, PKCS11Exception {
        boolean bl = f;
        byte[] byArray2 = rSAPublicKey.getModulus().toByteArray();
        byte[] byArray3 = rSAPublicKey.getPublicExponent().toByteArray();
        byte[] byArray4 = new byte[]{0};
        int[] nArray = new int[]{0, 1, 2, 3, 256, 257, 258, 260, 262, 266, 267, 268, 288, 289, 290, 368};
        Object[] objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, Boolean.TRUE, Boolean.FALSE, new String(""), PKCS11Object.RSA, byArray4, byArray, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, new BigInteger(byArray2), new Integer(byArray2.length), new BigInteger(byArray3), Boolean.TRUE};
        SmartCardObject smartCardObject = this.saveObject(nArray, objectArray);
        if (CTException.b) {
            f = !bl;
        }
        return smartCardObject;
    }

    public SmartCardObject saveRSAPrivateKey(RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SmartCardException, PKCS11Exception {
        boolean bl = f;
        byte[] byArray2 = rSAPrivateKey.getModulus().toByteArray();
        byte[] byArray3 = rSAPrivateKey.getPublicExponent().toByteArray();
        byte[] byArray4 = rSAPrivateKey.getPrivateExponent().toByteArray();
        byte[] byArray5 = rSAPrivateKey.getPrimeP().toByteArray();
        byte[] byArray6 = rSAPrivateKey.getPrimeQ().toByteArray();
        byte[] byArray7 = rSAPrivateKey.getPrimeExponentP().toByteArray();
        byte[] byArray8 = rSAPrivateKey.getPrimeExponentQ().toByteArray();
        byte[] byArray9 = rSAPrivateKey.getCrtCoefficient().toByteArray();
        byte[] byArray10 = new byte[]{0};
        int[] nArray = new int[]{0, 1, 2, 3, 256, 257, 258, 259, 261, 263, 264, 265, 268, 288, 290, 291, 292, 293, 294, 295, 296, 354, 368};
        Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, new String(""), PKCS11Object.RSA, byArray10, byArray, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7), new BigInteger(byArray8), new BigInteger(byArray9), Boolean.FALSE, Boolean.TRUE};
        SmartCardObject smartCardObject = this.saveObject(nArray, objectArray);
        if (bl) {
            CTException.b = !CTException.b;
        }
        return smartCardObject;
    }

    public SmartCardObject[] generateKeyPair(byte[] byArray, int n, int n2, byte[] byArray2) throws PKCS11Exception {
        int[] nArray = new int[]{289, 290, 1, 258};
        Object[] objectArray = new Object[]{new Integer(n2), new BigInteger(byArray2), Boolean.TRUE, byArray};
        int[] nArray2 = new int[]{1, 2, 259, 258};
        Object[] objectArray2 = new Object[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, byArray};
        PKCS11Object[] pKCS11ObjectArray = this.c.generateKeyPair(n, null, nArray, objectArray, nArray2, objectArray2);
        SmartCardObject[] smartCardObjectArray = new SmartCardObject[]{new SmartCardObject(pKCS11ObjectArray[0]), new SmartCardObject(pKCS11ObjectArray[1])};
        return smartCardObjectArray;
    }

    public SmartCardObject saveX509Certificate(byte[] byArray, X509Certificate x509Certificate) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 1, 128, 258, 17, 257, 129, 130};
        Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE, Boolean.TRUE, PKCS11Object.X_509, byArray, x509Certificate.toByteArray(), x509Certificate.getSubjectDN().toString().getBytes(), x509Certificate.getIssuerDN().toString().getBytes(), x509Certificate.getSerialNumber().toByteArray()};
        return this.saveObject(nArray, objectArray);
    }

    public SmartCardObject saveX509CertificateKey(byte[] byArray, X509Certificate x509Certificate) throws SmartCardException, PKCS11Exception {
        if (this.getPrivateKey(x509Certificate) == null) {
            throw new SmartCardException(5);
        }
        return this.saveX509Certificate(byArray, x509Certificate);
    }

    public SmartCardObject saveData(byte[] byArray, String string, byte[] byArray2) throws SmartCardException, PKCS11Exception {
        int[] nArray = new int[]{0, 1, 16, 3, 17};
        Object[] objectArray = new Object[]{PKCS11Object.DATA, Boolean.TRUE, string, new String(byArray), byArray2};
        return this.saveObject(nArray, objectArray);
    }

    public int sign(SmartCardObject smartCardObject, int n, byte[] byArray, byte[] byArray2) throws SmartCardException, PKCS11Exception {
        this.c.signInit(n, null, smartCardObject.getPKCS11Object());
        return this.c.sign(byArray, 0, byArray.length, byArray2, 0);
    }

    public int sign(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SmartCardException, PKCS11Exception {
        return this.sign(this.getPrivateKey(this.getCertificate(byArray).toX509Certificate()), n, byArray2, byArray3);
    }

    public boolean verify(SmartCardObject smartCardObject, int n, byte[] byArray, byte[] byArray2) throws PKCS11Exception {
        this.c.verifyInit(n, null, smartCardObject.getPKCS11Object());
        return this.c.verify(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public boolean verify(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SmartCardException, PKCS11Exception {
        return this.verify(this.getPublicKey(this.getCertificate(byArray).toX509Certificate()), n, byArray2, byArray3);
    }

    public int encrypt(SmartCardObject smartCardObject, int n, byte[] byArray, byte[] byArray2) throws SmartCardException, PKCS11Exception {
        if (smartCardObject == null) {
            throw new SmartCardException(8);
        }
        this.c.encryptInit(n, null, smartCardObject.getPKCS11Object());
        return this.c.encrypt(byArray, 0, byArray.length, byArray2, 0);
    }

    public int encrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SmartCardException, PKCS11Exception {
        return this.encrypt(this.getPublicKey(this.getCertificate(byArray).toX509Certificate()), n, byArray2, byArray3);
    }

    public int decrypt(SmartCardObject smartCardObject, int n, byte[] byArray, byte[] byArray2) throws PKCS11Exception {
        this.c.decryptInit(n, null, smartCardObject.getPKCS11Object());
        return this.c.decrypt(byArray, 0, byArray.length, byArray2, 0);
    }

    public int decrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SmartCardException, PKCS11Exception {
        return this.decrypt(this.getPrivateKey(this.getCertificate(byArray).toX509Certificate()), n, byArray2, byArray3);
    }

    public byte[] getDataCompressed(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9, true));
        deflaterOutputStream.write(byArray);
        deflaterOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getDataDecompressed(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater(true));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[1024];
        int n = 0;
        while ((n = inflaterInputStream.read(byArray2)) > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 7;
                        break;
                    }
                    case 1: {
                        n4 = 45;
                        break;
                    }
                    case 2: {
                        n4 = 11;
                        break;
                    }
                    case 3: {
                        n4 = 45;
                        break;
                    }
                    default: {
                        n4 = 23;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

