/*
 * Decompiled with CFR 0.152.
 */
package cybertrust2.crypto.server;

import cybertrust2.crypto.server.CryptoServer;
import cybertrust2.crypto.server.CryptoServerException;
import cybertrust2.crypto.server.SignedDocument;
import cybertrust2.crypto.server.a;
import cybertrust2.repository.Repository;
import cybertrust2.repository.RepositoryException;
import cybertrust2.repository.SmartcardRSAPrivateKey;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.smime.SMimeSigned;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Vector;

public class Signer
extends CryptoServer {
    boolean[] e = new boolean[]{true, false, false, false, false, false, false, false, false};
    private static final String f = "";
    private static final String g = "";
    private Vector h = null;
    private Vector i = null;

    public SignedDocument signImplicit(InputStream inputStream, PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws IOException, CryptoServerException {
        this.a(inputStream, a.input_null);
        this.a(privateKey, a.missing_privateKey);
        if (privateKey instanceof SmartcardRSAPrivateKey && !((SmartcardRSAPrivateKey)((Object)privateKey)).keyIsWorkingCheck()) {
            throw new CryptoServerException(Signer.b("|\u001bzv:L\u0017i`n\u007f\u0004rr/[\u0013;O+VVuk:\u000f\u0017xg+\\\u0005rf\"JW"));
        }
        if (x509CertificateArray == null) {
            throw new CryptoServerException(a.missing_certificates);
        }
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 1);
        if (sMimeSigned != null) {
            X509Certificate[] x509CertificateArray2 = CryptoServer.arrangeCertChain(x509CertificateArray, false);
            sMimeSigned.setCertificates(x509CertificateArray2);
            X509Certificate x509Certificate = x509CertificateArray2[0];
            try {
                sMimeSigned.addSigner(privateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CryptoServerException(a.invalid_Key);
            }
            catch (SignatureException signatureException) {
                throw new CryptoServerException(a.signature_exception);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CryptoServerException(a.algorithm_exception);
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo((OutputStream)byteArrayOutputStream);
                SignedDocument signedDocument = new SignedDocument(byteArrayOutputStream.toByteArray());
                return signedDocument;
            }
            catch (Exception exception) {
                throw new CryptoServerException(a.exception_sign_impl1);
            }
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    public SignedDocument signImplicit(byte[] byArray, PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws IOException, CryptoServerException {
        this.a((Object)byArray, a.input_null);
        this.a(privateKey, a.missing_privateKey);
        if (privateKey instanceof SmartcardRSAPrivateKey && !((SmartcardRSAPrivateKey)((Object)privateKey)).keyIsWorkingCheck()) {
            throw new CryptoServerException(Signer.b("|\u001bzv:L\u0017i`n\u007f\u0004rr/[\u0013;O+VVuk:\u000f\u0017xg+\\\u0005rf\"JW"));
        }
        if (x509CertificateArray == null) {
            throw new CryptoServerException(a.missing_certificates);
        }
        SMimeSigned sMimeSigned = new SMimeSigned((InputStream)new ByteArrayInputStream(byArray), 1);
        if (sMimeSigned != null) {
            X509Certificate[] x509CertificateArray2 = CryptoServer.arrangeCertChain(x509CertificateArray, false);
            sMimeSigned.setCertificates(x509CertificateArray2);
            X509Certificate x509Certificate = x509CertificateArray2[0];
            try {
                sMimeSigned.addSigner(privateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CryptoServerException(a.invalid_Key);
            }
            catch (SignatureException signatureException) {
                throw new CryptoServerException(a.signature_exception);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CryptoServerException(a.algorithm_exception);
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo((OutputStream)byteArrayOutputStream);
                SignedDocument signedDocument = new SignedDocument(byteArrayOutputStream.toByteArray());
                return signedDocument;
            }
            catch (Exception exception) {
                throw new CryptoServerException(a.exception_sign_impl1);
            }
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    public SignedDocument signImplicit(InputStream inputStream, Repository repository, X509Certificate x509Certificate) throws IOException, CryptoServerException {
        this.a(inputStream, a.input_null);
        this.a(repository, a.missing_repository);
        if (x509Certificate == null) {
            throw new CryptoServerException(a.missing_certificate);
        }
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 1);
        if (sMimeSigned != null) {
            this.a(sMimeSigned, repository, x509Certificate);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo((OutputStream)byteArrayOutputStream);
                SignedDocument signedDocument = new SignedDocument(byteArrayOutputStream.toByteArray());
                return signedDocument;
            }
            catch (Exception exception) {
                throw new CryptoServerException(a.exception_sign_impl1);
            }
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    private void a(SMimeSigned sMimeSigned, Repository repository, X509Certificate x509Certificate) throws CryptoServerException {
        try {
            byte[] byArray = repository.findAlias((Name)x509Certificate.getIssuerDN(), x509Certificate.getSerialNumber());
            X509Certificate[] x509CertificateArray = repository.getX509CertificateChain(byArray);
            PrivateKey privateKey = repository.getSignatureKey(byArray);
            if (privateKey == null) {
                throw new CryptoServerException(a.cert_notvalid_signature);
            }
            if (x509CertificateArray == null) {
                x509CertificateArray = new X509Certificate[]{x509Certificate};
            }
            sMimeSigned.setCertificates(x509CertificateArray);
            sMimeSigned.addSigner(privateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
        }
        catch (RepositoryException repositoryException) {
            throw new CryptoServerException(String.valueOf(String.valueOf(a.repository_exception).concat(String.valueOf(" "))).concat(String.valueOf(repositoryException.getMessage())));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoServerException(a.invalid_Key);
        }
        catch (SignatureException signatureException) {
            throw new CryptoServerException(a.signature_exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoServerException(a.algorithm_exception);
        }
    }

    public SignedDocument signImplicit(InputStream inputStream, Repository repository, byte[] byArray) throws IOException, CryptoServerException {
        this.a(inputStream, a.input_null);
        this.a(repository, a.missing_repository);
        this.a((Object)byArray, a.missing_alias);
        this.a(byArray, a.missing_alias);
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 1);
        if (sMimeSigned != null) {
            this.a(sMimeSigned, repository, byArray);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo((OutputStream)byteArrayOutputStream);
                SignedDocument signedDocument = new SignedDocument(byteArrayOutputStream.toByteArray());
                return signedDocument;
            }
            catch (Exception exception) {
                throw new CryptoServerException(a.exception_sign_impl1);
            }
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    private void a(SMimeSigned sMimeSigned, Repository repository, byte[] byArray) throws CryptoServerException {
        try {
            X509Certificate[] x509CertificateArray = repository.getX509CertificateChain(byArray);
            if (x509CertificateArray == null) {
                throw new CryptoServerException(a.alias_not_found);
            }
            PrivateKey privateKey = repository.getSignatureKey(byArray);
            if (privateKey == null) {
                throw new CryptoServerException(a.cert_notvalid_signature);
            }
            if (x509CertificateArray == null) {
                x509CertificateArray = new X509Certificate[]{repository.getX509Certificate(byArray)};
            }
            sMimeSigned.setCertificates(x509CertificateArray);
            sMimeSigned.addSigner(privateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509CertificateArray[0]));
        }
        catch (RepositoryException repositoryException) {
            throw new CryptoServerException(String.valueOf(String.valueOf(a.repository_exception).concat(String.valueOf(" "))).concat(String.valueOf(repositoryException.getMessage())));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoServerException(a.invalid_Key);
        }
        catch (SignatureException signatureException) {
            throw new CryptoServerException(a.signature_exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoServerException(a.algorithm_exception);
        }
    }

    public SignedDocument signImplicit(InputStream inputStream, PKCS12 pKCS12, char[] cArray) throws IOException, CryptoServerException {
        this.a(inputStream, a.input_null);
        this.a(pKCS12, a.missing_p12);
        this.a((Object)cArray, a.missing_p12_pwd);
        this.a(cArray, a.empty_p12_pwd);
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 1);
        if (sMimeSigned != null) {
            this.a(sMimeSigned, pKCS12, cArray);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                sMimeSigned.writeTo((OutputStream)byteArrayOutputStream);
                SignedDocument signedDocument = new SignedDocument(byteArrayOutputStream.toByteArray());
                return signedDocument;
            }
            catch (Exception exception) {
                throw new CryptoServerException(a.exception_sign_impl1);
            }
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    private void a(SMimeSigned sMimeSigned, PKCS12 pKCS12, char[] cArray) throws CryptoServerException {
        try {
            pKCS12.decrypt(cArray);
        }
        catch (PKCSException pKCSException) {
            throw new CryptoServerException(a.exception_p12_decrypt);
        }
        CertificateBag[] certificateBagArray = pKCS12.getCertificateBags();
        X509Certificate[] x509CertificateArray = CertificateBag.getCertificates((CertificateBag[])certificateBagArray);
        if (x509CertificateArray == null) {
            throw new CryptoServerException(a.exception_p12_certChain);
        }
        X509Certificate x509Certificate = x509CertificateArray[0];
        boolean bl = this.a(x509Certificate, this.e);
        if (!bl) {
            throw new CryptoServerException(a.key_usage_uncorrect);
        }
        PrivateKey privateKey = pKCS12.getKeyBag().getPrivateKey();
        if (privateKey == null) {
            throw new CryptoServerException(a.exception_p12_privateKey);
        }
        X509Certificate[] x509CertificateArray2 = this.certsUnion(sMimeSigned.getCertificates(), x509CertificateArray);
        sMimeSigned.setCertificates(x509CertificateArray2);
        try {
            sMimeSigned.addSigner(privateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoServerException(a.invalid_Key);
        }
        catch (SignatureException signatureException) {
            throw new CryptoServerException(a.signature_exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoServerException(a.algorithm_exception);
        }
    }

    public SignedDocument multipleSign(InputStream inputStream, Repository[] repositoryArray, byte[][] byArray) throws IOException, CryptoServerException {
        this.a(inputStream, Signer.b("B\u001fhw'A\u0011;@!L\u0003va [VoknM\u0013;w'H\u0018~`"));
        this.a((Object)repositoryArray, Signer.b("B\u001fhw'A\u0011;w'H\u0018~vi\\Via>@\u0005rp!]\u001f~w"));
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 1);
        this.a(sMimeSigned, repositoryArray, byArray);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sMimeSigned.writeTo((OutputStream)byteArrayOutputStream);
            SignedDocument signedDocument = new SignedDocument(byteArrayOutputStream.toByteArray());
            return signedDocument;
        }
        catch (Exception exception) {
            throw new CryptoServerException(a.exception_sign_impl1);
        }
    }

    private void a(SMimeSigned sMimeSigned, Repository[] repositoryArray, byte[][] byArray) throws CryptoServerException {
        int n;
        block18: {
            block17: {
                Repository[] repositoryArray2;
                block16: {
                    n = CryptoServerException.d;
                    if (sMimeSigned == null) {
                        throw new CryptoServerException(a.missing_smimesigned);
                    }
                    repositoryArray2 = repositoryArray;
                    if (n != 0) break block16;
                    if (repositoryArray2 == null) break block17;
                    repositoryArray2 = repositoryArray;
                }
                if (repositoryArray2.length != 0) break block18;
            }
            throw new CryptoServerException(a.missing_signers);
        }
        Vector<X509Certificate> vector = new Vector<X509Certificate>();
        Vector<PrivateKey> vector2 = new Vector<PrivateKey>();
        Vector<IssuerAndSerialNumber> vector3 = new Vector<IssuerAndSerialNumber>();
        try {
            int n2;
            block14: {
                int n3 = 0;
                block5: while (true) {
                    int n4 = n3;
                    block6: while (n4 < repositoryArray.length) {
                        X509Certificate[] x509CertificateArray = repositoryArray[n3].getX509CertificateChain(byArray[n3]);
                        X509Certificate x509Certificate = x509CertificateArray[0];
                        vector2.addElement(repositoryArray[n3].getSignatureKey(byArray[n3]));
                        vector3.addElement(new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
                        n2 = 0;
                        if (n != 0) break block14;
                        for (int i = v6039; i < x509CertificateArray.length; ++i) {
                            Vector<X509Certificate> vector4 = vector;
                            X509Certificate x509Certificate2 = x509CertificateArray[i];
                            if (n == 0) {
                                n4 = vector4.contains(x509Certificate2) ? 1 : 0;
                                if (n != 0) continue block6;
                                if (n4 != 0) continue;
                                vector4 = vector;
                                x509Certificate2 = x509CertificateArray[i];
                            }
                            vector4.addElement(x509Certificate2);
                            if (n == 0) continue;
                        }
                        ++n3;
                        if (n == 0) continue block5;
                    }
                    break;
                }
                n2 = vector.size();
            }
            Object[] objectArray = new X509Certificate[n2];
            vector.copyInto(objectArray);
            sMimeSigned.setCertificates((X509Certificate[])objectArray);
            for (int i = 0; i < repositoryArray.length; ++i) {
                sMimeSigned.addSigner((PrivateKey)vector2.elementAt(i), (IssuerAndSerialNumber)vector3.elementAt(i));
                if (n == 0 && n == 0) continue;
                break;
            }
        }
        catch (RepositoryException repositoryException) {
            throw new CryptoServerException(a.repository_exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoServerException(a.invalid_Key);
        }
        catch (SignatureException signatureException) {
            throw new CryptoServerException(a.signature_exception);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoServerException(a.algorithm_exception);
        }
    }

    public byte[] signExplicit(InputStream inputStream, Repository repository, X509Certificate x509Certificate) throws IOException, CryptoServerException {
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 2);
        if (sMimeSigned != null) {
            byte[] byArray;
            this.a(sMimeSigned, repository, x509Certificate);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                StreamCopier streamCopier = new StreamCopier(sMimeSigned.getInputStream(), (OutputStream)bufferedOutputStream);
                streamCopier.copyStream();
                ((OutputStream)bufferedOutputStream).close();
                byArray = sMimeSigned.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CryptoServerException(a.exception_sign_explicit);
            }
            return byArray;
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    public byte[] signExplicit(InputStream inputStream, Repository repository, byte[] byArray) throws IOException, CryptoServerException {
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 2);
        if (sMimeSigned != null) {
            byte[] byArray2;
            this.a(sMimeSigned, repository, byArray);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                StreamCopier streamCopier = new StreamCopier(sMimeSigned.getInputStream(), (OutputStream)bufferedOutputStream);
                streamCopier.copyStream();
                ((OutputStream)bufferedOutputStream).close();
                byArray2 = sMimeSigned.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CryptoServerException(a.exception_sign_explicit);
            }
            return byArray2;
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    public byte[] signExplicit(InputStream inputStream, PrivateKey privateKey, X509Certificate[] x509CertificateArray) throws IOException, CryptoServerException {
        if (x509CertificateArray == null) {
            throw new CryptoServerException(a.missing_certificates);
        }
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 2);
        if (sMimeSigned != null) {
            byte[] byArray;
            sMimeSigned.setCertificates(x509CertificateArray);
            X509Certificate x509Certificate = x509CertificateArray[0];
            try {
                sMimeSigned.addSigner(privateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CryptoServerException(a.invalid_Key);
            }
            catch (SignatureException signatureException) {
                throw new CryptoServerException(a.signature_exception);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CryptoServerException(a.algorithm_exception);
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                StreamCopier streamCopier = new StreamCopier(sMimeSigned.getInputStream(), (OutputStream)bufferedOutputStream);
                streamCopier.copyStream();
                ((OutputStream)bufferedOutputStream).close();
                byArray = sMimeSigned.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CryptoServerException(a.exception_sign_explicit);
            }
            return byArray;
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    public byte[] signExplicit(InputStream inputStream, PKCS12 pKCS12, char[] cArray) throws IOException, CryptoServerException {
        this.a(inputStream, a.input_null);
        this.a(pKCS12, a.missing_p12);
        this.a((Object)cArray, a.missing_p12_pwd);
        this.a(cArray, a.empty_p12_pwd);
        SMimeSigned sMimeSigned = new SMimeSigned(inputStream, 2);
        if (sMimeSigned != null) {
            byte[] byArray;
            this.a(sMimeSigned, pKCS12, cArray);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                StreamCopier streamCopier = new StreamCopier(sMimeSigned.getInputStream(), (OutputStream)bufferedOutputStream);
                streamCopier.copyStream();
                ((OutputStream)bufferedOutputStream).close();
                byArray = sMimeSigned.toByteArray();
            }
            catch (PKCSException pKCSException) {
                throw new CryptoServerException(a.exception_sign_explicit);
            }
            return byArray;
        }
        throw new CryptoServerException(a.exception_sign_impl2);
    }

    public boolean verifyAll(SignedDocument signedDocument) throws CryptoServerException, SignatureException {
        this.h = new Vector();
        this.i = new Vector();
        int n = signedDocument.getSignerInfos().length;
        if (n == 0) {
            throw new CryptoServerException(Signer.b("a\u0019;w'H\u0018~vnf\u0018}k=\u000f\u0017me'N\u0014wa"));
        }
        for (int i = 0; i < n; ++i) {
            this.a(i, signedDocument);
        }
        return this.h.size() == n;
    }

    private void a(int n, SignedDocument signedDocument) throws CryptoServerException, SignatureException {
        SMimeSigned sMimeSigned = this.a(signedDocument);
        this.a(sMimeSigned);
        SignerInfo signerInfo = sMimeSigned.getSignerInfos()[n];
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = sMimeSigned.getCertificate(signerInfo.getIssuerAndSerialNumber());
        }
        catch (Exception exception) {
            throw new SignatureException(a.signature_exception1);
        }
        try {
            sMimeSigned = this.a(signedDocument);
            this.a(sMimeSigned);
            sMimeSigned.verify(x509Certificate.getPublicKey(), n);
            this.h.addElement(x509Certificate);
        }
        catch (Exception exception) {
            this.i.addElement(x509Certificate);
        }
    }

    public X509Certificate[] getValidSignerCertificates() {
        Object[] objectArray = new X509Certificate[this.h.size()];
        this.h.copyInto(objectArray);
        return objectArray;
    }

    public X509Certificate[] getInvalidSignerCertificates() {
        Object[] objectArray = new X509Certificate[this.i.size()];
        this.i.copyInto(objectArray);
        return objectArray;
    }

    private SMimeSigned a(SignedDocument signedDocument) throws CryptoServerException {
        try {
            SMimeSigned sMimeSigned = new SMimeSigned(signedDocument.getInputStream());
            return sMimeSigned;
        }
        catch (Exception exception) {
            throw new CryptoServerException(a.exception_asSMimeSigned);
        }
    }

    private byte[] a(SMimeSigned sMimeSigned) throws CryptoServerException {
        if (sMimeSigned == null) {
            throw new CryptoServerException(a.exception_missingSMSto_decode);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = sMimeSigned.getInputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new CryptoServerException(a.exception_decode_SMimeSigned);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n > 1) continue;
            char[] cArray2 = cArray;
            int n3 = n2;
            while (true) {
                int n4;
                char c2 = cArray2[n3];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 47;
                        break;
                    }
                    case 1: {
                        n4 = 118;
                        break;
                    }
                    case 2: {
                        n4 = 27;
                        break;
                    }
                    case 3: {
                        n4 = 4;
                        break;
                    }
                    default: {
                        n4 = 78;
                    }
                }
                cArray2[n3] = (char)(c2 ^ n4);
                ++n2;
                if (n != 0) continue block6;
                cArray2 = cArray;
                n3 = n;
            }
        } while (n2 < n);
        return new String(cArray);
    }
}

