<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >

  <xsl:output method="xml" encoding="UTF-8"/>

  <xsl:template match="/">
    <xsl:apply-templates select="AddressStruct" />
  </xsl:template>

  <xsl:template match="AddressStruct">
    <xsl:comment>Attributes converted back to elements.</xsl:comment>
    <address-struct>
      <name>
	<xsl:value-of select="Information/@Name"/>
      </name>
      <address-1>
	<xsl:value-of select="Information/@Address1"/>
      </address-1>
      <address-2>
	<xsl:value-of select="Information/@Address2"/>
      </address-2>
      <address-3>
	<city>
	  <xsl:value-of select="Information/@City"/>
	</city>
       <state>
	 <xsl:value-of select="Information/@State"/>
       </state>
       <zip>
	 <xsl:value-of select="Information/@Zip"/>
       </zip>
      </address-3>
      <country>
	<xsl:value-of select="Information/@Country"/>
      </country>
      <time-stamp>
	<xsl:value-of select="TimeStamp/@Value"/>
      </time-stamp>
     </address-struct>
   </xsl:template>
</xsl:stylesheet>
