       Identification Division.
       Program-Id.  Example-C.
      *
      * Title: EXAMPLEC.CBL: Export with document prefix.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *
       Environment Division.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
           SYMBOLIC CHARACTERS LF IS 11. *> LF = Line Feed (X"0a")

       Data Division.
       Working-Storage Section.
      * Define a data structure that uses entity references:
       01  Line-Item.
           02 LI-BoilerPlate.
              03 FILLER      PIC X(30) VALUE "&BoilerPlate;".
           02 LI-Name        PIC X(30).
           02 LI-Quantity    PIC 9(04).
           02 LI-CurPrice.
              03 FILLER      PIC X(10) VALUE "&CURRENCY;".
              03 LI-Price    PIC 9(06)V99.
           02 LI-CurExt.
              03 FILLER      PIC X(10) VALUE "&CURRENCY;".
              03 LI-Ext      PIC 9(10)V99.
           02 LI-TimeStamp   PIC X(23).

      * Define a document prefix that declares the entities
      *     CURRENCY and BoilerPlate:
       01  DocumentPrefix.
           02  PIC X(21) VALUE
               "<!DOCTYPE line-item [".
           02  PIC X VALUE LF.
           02  PIC X(30) VALUE
               "   <!ENTITY CURRENCY ""&#036;"">".
           02  PIC X VALUE LF.
           02  PIC X(44) VALUE
               "   <!ENTITY BoilerPlate ""All prices in USD"">".
           02  PIC X VALUE LF.
           02  PIC X(9) VALUE
               "       ]>".
       01  Done Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-C - Illustrate EXPORT FILE with"
                   " Document Prefix".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To LI-TimeStamp.

           MOVE "Widget" TO LI-Name.
           MOVE 50 TO LI-Quantity.
           MOVE 5.42 TO LI-Price.
           MULTIPLY LI-Price BY LI-Quantity GIVING LI-Ext.

           XML EXPORT FILE
               Line-Item       *> export source data-item reference
               "data-c"        *> export target file name (.xml assumed)
               "Line-Item"     *> export data structure name
               OMITTED         *> no XSLT stylesheet
               DocumentPrefix. *> document prefix string reference
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "data-c.xml exported by XML EXPORT FILE".
           Initialize Line-Item.

           XML IMPORT FILE
               Line-Item       *> reference to import target data item (input)
               "data-c"        *> input document file name (input)
               "Line-Item".    *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "data-c.xml imported by XML IMPORT FILE".
           Perform Display-Line-Item.

           Display Space.
           Display "You may inspect 'data-c.xml'".
           Display Space.
           Go to Z.

       Display-Line-Item.
           Display Space.
           Display "BoilerPlate:  " LI-BoilerPlate.
           Display "Name:         " LI-Name.
           Display "Quantity:     " LI-Quantity.
           Display "CurPrice:     " LI-CurPrice.
           Display "CurExt:       " LI-CurExt.
           Display "TimeStamp:    " LI-TimeStamp.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-C.
