       Identification Division.
       Program-Id.  Example-6.
      *
      * Title: EXAMPLE6.CBL: Export / Import with directory polling.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *
       Data Division.
       Working-Storage Section.
       01  Time-Stamp                   Pic 99/99/99/99.
       01  Curr-Time-Group.
           02  Curr-Time-Stamp          Pic 9(2) Occurs 4.
       01  Curr-Time                    Pic 9(8).
       01  Stop-Time                    Pic 9(8).
       01  Unique-File-Name             Pic X(260).
       01  Display-Line                 Pic X(80).
       01  Unique-Name                  Pic X(40).

       01  Done                         Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-6 - Illustrate EXPORT FILE & IMPORT FILE"
                   " with directory polling".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Perform 5 Times
               XML GET UNIQUEID
                   Unique-Name    *> unique id value; see XML-UniqueID (output)
               If Not XML-OK Go to Z End-If

               Initialize Unique-File-Name
               String "stamp/a" delimited by size
                   Unique-Name delimited by SPACE
                   ".xml" delimited by size
                   into Unique-File-Name

               Accept WS-Date From Date YYYYMMDD
               Accept WS-Time From Time
               Inspect WS-Time Converting "/" To ":"
               Move "." To WS-Time(9: 1)
               Move WS-TimeStamp To Time-Stamp

               Accept Time-Stamp From Time
               Inspect Time-Stamp Converting "/" To ":"
               Move "." To Time-Stamp(9: 1)

               XML EXPORT FILE
                   Time-Stamp           *> reference to export source data item (input)
                   Unique-File-Name     *> output document file name (input)
                   "Time-Stamp"         *> model data name string (input)
               If Not XML-OK Go to Z End-If

               Move Spaces to Display-Line
               String Unique-File-Name delimited by space
                   " exported by XMLExport" delimited by size
                   into Display-Line
               Display Display-Line
               Display "Contents: " Time-Stamp

           End-Perform.

           Display Space.
           Display "You may display the 'stamp' directory".
           Display Space.
           Display "Press a key to continue:".                          TESTS
           Accept Done.                                                 TESTS

           Perform Until 0 > 1

               Perform Compute-Curr-Time
               Compute Stop-Time = Curr-Time + 100

               Perform Until 0 > 1

                   XML FIND FILE
                       "stamp"          *> path name of directory to check (input)
                       Unique-File-Name *> full name of found file (output)
                   If XML-IsSuccess Exit Perform End-If

                   If XML-IsDirectoryEmpty
                       Perform Compute-Curr-Time
                       If Curr-Time > Stop-Time
                           Exit Perform
                       End-If
                       Call "C$DELAY" Using 0.1
                   End-If

                   If Not XML-OK Go to Z End-If

               End-Perform

               If Curr-Time > Stop-Time
                   Exit Perform
               End-If

               XML IMPORT FILE
                   Time-Stamp           *> reference to import target data item (input)
                   Unique-File-Name     *> input document file name (input)
                   "Time-Stamp"         *> model data name string (input)
               If Not XML-OK Go to Z End-If

               XML REMOVE FILE
                   Unique-File-Name
               If Not XML-OK Go to Z End-If

               Move spaces to Display-Line
               String " " delimited by size
                   Unique-File-Name delimited by space
                   " imported by XMLImport" delimited by size
                   into Display-Line
               Display Display-Line
               Display "Contents: " Time-Stamp

           End-Perform.

           Display Space.
           Display "You may now verify that the 'stamp' "
                   "directory has been emptied".
           Display Space.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate.".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       Compute-Curr-Time.
           Accept Curr-Time-Group From Time.
           Compute Curr-Time
               =  (Curr-Time-Stamp (1) * 360000)
               +  (Curr-Time-Stamp (2) * 6000)
               +  (Curr-Time-Stamp (3) * 100)
               +  (Curr-Time-Stamp (4)).

       End Program  Example-6.
