       Identification Division.
       Program-Id.  Example-5.
      *
      * Title: EXAMPLE5.CBL: Export / Import Text.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *   $URL: svn://sd-dev/acu/tags/v9-2-2-build-1-rc-0/cobolgt/sample/xmlext/example5.cbl $
      *
       Data Division.
       Working-Storage Section.

       Copy "s-struct.cpy".

       01  Document-Pointer Usage Pointer.
       01  Document-Length  PIC 9(5) Usage Binary.
       01  Done Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-5 - Illustrate EXPORT TEXT & IMPORT TEXT".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To Time-Stamp.

           XML EXPORT TEXT
               Address-Struct     *> reference to export source data item (input)
               Document-Pointer   *> document pointer data item (output)
               Document-Length    *> length of document output (output)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document exported by XML EXPORT TEXT".
           Perform Display-Address-Struct.
           Initialize Address-Struct.

           XML IMPORT TEXT
               Address-Struct     *> reference target data item (input)
               Document-Pointer   *> document pointer data item (input)
               Document-Length    *> input document length (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document imported by XML IMPORT TEXT".
           Perform Display-Address-Struct.

           XML PUT TEXT
               Document-Pointer   *> document pointer data item (input)
               Document-Length    *> length of document text (input)
               "address5"         *> target document file name (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "Document memory written by XML PUT TEXT".

           XML FREE TEXT
               Document-Pointer. *> document pointer data item (input)
           If Not XML-OK Go to Z End-If.

           Display "Document memory released by XML FREE TEXT".

           Display Space.
           Display "You may inspect 'address5.xml'".
           Display Space.
           Go to Z.

       Display-Address-Struct.
           Display Space.
           Display "Name:        " Name.
           Display "Address-1:   " Address-1.
           Display "Address-2:   " Address-2.
           Display "Address-3:   " Address-3.
           Display "Country:     " Country.
           Display "Time-Stamp:  " Time-Stamp.

       Z.

           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-5.
