       Identification Division.
       Program-Id.  Example-3.
      *
      * Title: EXAMPLE3.CBL: Export / Import with Occurs Depending.
      *
      * Copyright (c) 2008-2014, Micro Focus (IP) Ltd.
      *
      * Version Identification:
      *   $Revision: 64691 $
      *   $Date: 2013-11-05 19:06:03 +0000 (Tue, 05 Nov 2013) $
      *   $URL: svn://sd-dev/acu/tags/v9-2-2-build-1-rc-0/cobolgt/sample/xmlext/example3.cbl $
      *
       Data Division.
       Working-Storage Section.

       Copy "s-struct3.cpy".

       01  I1   PIC 9.
       01  Done Pic X.
       01  WS-TimeStamp.
           02 WS-Date       PIC 9999/99/99.
           02 Filler        PIC XX Value Spaces.
           02 WS-Time       PIC 99/99/99/99.

       Copy "lixmlall.cpy".

       Procedure Division.
       A.
           Display "Example-3 - Illustrate EXPORT FILE & IMPORT FILE"
                   " with OCCURS DEPENDING".

           XML INITIALIZE.
           If Not XML-OK Go to Z End-If.

           Accept WS-Date From Date YYYYMMDD.
           Accept WS-Time From Time.
           Inspect WS-Time Converting "/" To ":".
           Move "." To WS-Time(9: 1).
           Move WS-TimeStamp To Time-Stamp.

           Move 3 to Address-Lines.
           Move Street to Address-Line (1).
           Move Building to Address-Line (2).
           Move Suite to Address-Line (3).

           XML EXPORT FILE
               Address-Struct3    *> reference to export source data item (input)
               "address3"         *> output document file name (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address3.xml exported by XML EXPORT FILE".
           Perform Display-Address-Struct.
           Initialize Address-Struct3.

           XML IMPORT FILE
               Address-Struct3    *> reference to import target data item (input)
               "address3"         *> input document file name (input)
               Struct-Name.       *> model data name string (input)
           If Not XML-OK Go to Z End-If.

           Display Space.
           Display "address3.xml imported by XML IMPORT FILE".
           Perform Display-Address-Struct.

           Display Space.
           Display "You may inspect 'address3.xml'".
           Display Space.
           Go to Z.

       Display-Address-Struct.
           Display Space.
           Display "Name:             " Name.
           Perform Varying I1 From 1 By 1 Until I1 > Address-Lines
             Display "Address-Line(" I1 "):  " Address-Line(I1)
           End-Perform.
           Display "City State Zip:   " City State Zip.
           Display "Country:          " Country.
           Display "Time-Stamp:       " Time-Stamp.

       Z.
           Copy "lixmltrm.cpy".

           Display "Press a key to terminate:".                         TESTS
           Accept Done.                                                 TESTS
           Stop Run.

           Copy "lixmldsp.cpy".

       End Program  Example-3.
