program-id.  servext.

* Copyright (c) 1996-2014 by Micro Focus. Users of ACUCOBOL-GT
* may freely modify and redistribute this program.

remarks.
    This program demonstrates the use of C$SERVER-EXTENSION.

working-storage section.

77  key-status
    is special-names crt status pic 9(5) value zero.
    88 quit-button-pressed      value 27.

77  se-status            pic S9.

77  screen-button        pic x(18).

01  initial-form is external-form identified by "initial.html".
    03 field-1           pic 9(5).
    03 field-1-x redefines field-1 pic x(5) identified by "field-1".
    03 field-2           pic x(20).
    03 field-3           pic x(20).
    03 field-4           pic x(20).
    03 http-cookie       pic x(1024).

01  screen1-form is external-form identified by "screen1.html".
    03 field-1           pic 9(5).
    03 field-2           pic x(20).
    03 field-3           pic x(20).
    03 field-4           pic x(20).

01  screen2-form is external-form identified by "screen2.html".
01  screen3-form is external-form identified by "screen3.html".
01  quit-form is external-form identified by "quit.html".

copy "def/servext.def".

procedure division.
declaratives.
program-end section.
        use at program end.
program-end-pgh.
*
* Add code here to handle graceful shutdown
*
end declaratives.
main-logic.

*
* Note that if you set the configuration variable CGI-SERVER-EXTENSION to 0 
* then you need to perform the send-and-receive paragraph in between each 
* display and accept. 
*
*       set environment "CGI_SERVER_EXTENSION" to "0".
*

* Set CGI_CLEAR_MISSING_VALUES to 0 so that http-cookie does not get cleared
* each time we accept initial-form.
        set environment "CGI_CLEAR_MISSING_VALUES" to "0".

        accept http-cookie from environment "HTTP_COOKIE".

* Display the initial HTML screen
        display initial-form.
*       perform send-and-receive.
* Accept the initial HTML screen
        accept initial-form.

* This code handles clicking on the screen buttons. It displays and accepts
* the individual screens for each screen button that is clicked.

        perform until quit-button-pressed
           call "c$getcgi" using "screen-button", screen-button
           evaluate screen-button
              when "  Initial Screen  "
                 display initial-form
*                perform send-and-receive
                 accept initial-form
              when "  Screen 1  "
                 move initial-form to screen1-form
                 display screen1-form
*                perform send-and-receive
                 accept screen1-form
              when "  Screen 2  "
                 display screen2-form
*                perform send-and-receive
                 accept screen2-form
              when "  Screen 3  "
                 display screen3-form
*                perform send-and-receive
                 accept screen3-form
              when "    Quit    "
                 display quit-form
                 set quit-button-pressed to true
              when other
                 stop run
           end-evaluate
        end-perform.
        stop run.

*send-and-receive.
*       call "c$server-extension" using cse-send 
*           giving se-status.
*       perform check-se-status.
*       call "c$server-extension" using cse-receive 
*           giving se-status.
*       perform check-se-status.

*check-se-status.
*        if se-status not = cse-success then
*            stop run.
