#!/bin/sh
# Ensure that the ACU extend 'bin' directory is in your PATH environment variable
# Ensure that the libxmlif shared object path is in your shared library path environment variable
#   (e.g., LD_LIBRARY_PATH, SHLIB_PATH, LIBPATH, etc. as appropriate for your platform)
for f in *.cbl; do ccbl -Cr -Sr -Gz -Ga -Sp ../xmlext -Ze $f; done
LIBXMLIF=libxmlif.so; LIBRMNET=librmnet.so
if [ "`file \`which runcbl\` | sed -n -e 's/.*64-bit.*/64/p'`" = "64" ]; then LIBXMLIF=libxmlif64.so; LIBRMNET=librmnet64.so; fi
if [ "`file \`which runcbl\` | sed -n -e 's/.*ELF-64.*/64/p'`" = "64" ]; then LIBXMLIF=libxmlif64.so; LIBRMNET=libxmlif64.so; fi
if [ "`file \`which runcbl\` | sed -n -e 's/.*PA-RISC.*/sl/p'`" = "sl" ]; then LIBXMLIF=libxmlif.sl; LIBRMNET=libxmlif.sl; fi
if [ "`file \`which runcbl\` | sed -n -e 's/.*PA-RISC 2.*/sl/p'`" = "sl" ]; then LIBXMLIF=libxmlif64.sl; LIBRMNET=libxmlif64.sl; fi
for f in *.acu; do runcbl -y $LIBXMLIF -y $LIBRMNET $f; done
