identification division.
program-id.	xmlparse.
author.		Randy Zack.
remarks.
	This program demonstrates simple XML parsing with the XML PARSE
	verb.
	Compile with -Dw32

data division.
working-storage section.
01  xml-text-len pic 9(9) comp-5.

procedure division.
main-pgh.
    display window erase no wrap.
    xml parse
     "<?xml version=""1.0""?>
-    "<!DOCTYPE data1 [
-    "<!ENTITY data ""This is test data"">
-    "]>
-    "<data1>
-     "<!-- This is a comment embedded in the XML stream -->
-     "<data2><![CDATA[This is uninterpreted text<>&'""]]>  xx </data2>
-     "<data3 attr=""my&amp;attr"">&quot;ddd&quot;</data3>
-     "<data4 thisattr=""ant"">&data;ddd</data4>
-    "</data1>"
       processing procedure is my-xml-proc thru my-xml-proc-end
      on exception
        display "Error parsing XML", xml-code
      not on exception
        display "Done"
    end-xml.
    accept omitted.
    stop run.

my-xml-proc.
    display xml-event no.
    if xml-event = "EXCEPTION"
        display xml-code, " " no
    end-if.

my-xml-proc-2.
    move function length(xml-text) to xml-text-len.
    if xml-text-len > 0
	display xml-text(1:xml-text-len)
    else
***  Advance a line, since the event display did not
	display " "
    end-if.

my-xml-proc-end.
    exit.
