       IDENTIFICATION DIVISION.
       PROGRAM-ID. pets.
       AUTHOR.  bbarr/mkirschen/jrodgers
       DATE-WRITTEN. 2002/10/28 PM 02:55.
       REMARKS.    Initial Version 6.0
           [This program creates a file that can be used to demonstrate SQL syntax supported by AcuODBC:  SELECT, INSERT, DELETE, and UPDATE.

           An AcuODBC Data Source Name needs to be set up using ODBC Manager.
           The program needs to be compiled with an -Fa option 
           pointing to path for XFD creation.  The program needs a .cfg file
           to point to the file directory when creating or adding to the
           data file.]

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT jr-file
              ASSIGN TO "pets"
              ORGANIZATION IS INDEXED
              ACCESS IS DYNAMIC
              RECORD KEY IS patient-id
              FILE STATUS IS jr-file-status.

       DATA DIVISION.
       FILE SECTION.
       FD  jr-file.
       01  jr-record.
           05 patient-id                   pic 9(5).
           05 info.
	       10  patient-name            pic x(20).	
               10  animal_type             pic x(20).
               10  breed                   pic x(30).
           05  treatment                   pic x(5).
           05  owner-id                    pic 9(5).

       WORKING-STORAGE SECTION.
           
       01  jr-file-status                  pic xx.

       PROCEDURE DIVISION.

       MAIN-LOGIC.

           open output jr-file.
           move "00001" to patient-id.
           move "Cinnamon" to patient-name.	
           move "Cat" to animal-type.
           move "Tabby" to breed.
           move "1" to treatment.
           move "624" to owner-id.
	     write jr-record.

           move "00002" to patient-id.
           move "Nutmeg" to patient-name.	
           move "Cat" to animal-type.
           move "Tabby" to breed.
           move "2" to treatment.
           move "550" to owner-id.
	     write jr-record.
   
           move "00102" to patient-id.
           move "Kit" to patient-name.	
           move "Dog" to animal-type.
           move "Shiba Inu" to breed.
           move "1" to treatment.
           move "600" to owner-id.
	     write jr-record.

	   move "00160" to patient-id.
           move "Milo" to patient-name.
           move "Dog" to animal-type.
           move "Chow" to breed.
           move "4" to treatment.
           move "522" to owner-id.
             write jr-record.

           move "00161" to patient-id.
           move "Puzzle" to patient-name.
           move "Reptile" to animal-type.
           move "Ball Python" to breed.
           move "3" to treatment.
           move "522" to owner-id.
             write jr-record.
              
           move "00328" to patient-id.
           move "Copper" to patient-name.	
           move "Dog" to animal-type.
           move "Golden Retriever" to breed.
           move " " to treatment.
           move "618" to owner-id.
	     write jr-record.

           move "00377" to patient-id.
           move "Scooter" to patient-name.
           move "Cat" to animal-type.
           move "Domestic Shorthair" to breed.
           move "2" to treatment.
           move "357" to owner-id.
             write jr-record.

           move "00378" to patient-id.
           move "Scrapper" to patient-name.
           move "Cat" to animal-type.
           move "Devon Rex" to breed.
           move "2" to treatment.
           move "357" to owner-id.
             write jr-record.

           move "00379" to patient-id.
           move "Abbie" to patient-name.
           move "Cat" to animal-type.
           move "Maine Coon" to breed.
           move "2" to treatment.
           move "357" to owner-id.
             write jr-record.

           move "00480" to patient-id.
           move "Princess" to patient-name.
           move "Reptile" to animal-type.
           move "Iguana" to breed.
           move "1" to treatment.
           move "309" to owner-id.
             write jr-record.

           move "00503" to patient-id.
           move "Polly" to patient-name.	
           move "Bird" to animal-type.
           move "Senegal Parrot" to breed.
           move "6" to treatment.
           move "625" to owner-id.
	     write jr-record.

           move "00504" to patient-id.
           move "Diego" to patient-name.
           move "Bird" to animal-type.
           move "Red Lory" to breed.
           move "4" to treatment.
           move "625" to owner-id.
             write jr-record.

           move "00505" to patient-id.
           move "Alexi" to patient-name.
           move "Bird" to animal-type.
           move "African Grey" to breed.
           move "4" to treatment.
           move "625" to owner-id.
             write jr-record.
      
           move "00801" to patient-id.
           move "Hammy" to patient-name.	
           move "Rodent" to animal-type.
           move "Gerbil" to breed.
           move "3" to treatment.
           move "700" to owner-id.
	     write jr-record.

	     move "00802" to patient-id.
           move "Rodney" to patient-name.	
           move "Rodent" to animal-type.
           move "Hamster" to breed.
           move "4" to treatment.
           move "700" to owner-id.
	     write jr-record.

	     move "00018" to patient-id.
           move "Shotzi" to patient-name.	
           move "Dog" to animal-type.
           move "Schnauzer" to breed.
           move "1" to treatment.
           move "704" to owner-id.
	     write jr-record.

	     move "00036" to patient-id.
           move "Cinder" to patient-name.	
           move "Dog" to animal-type.
           move "Poodle" to breed.
           move "4" to treatment.
           move "221" to owner-id.
	     write jr-record.

	     move "00054" to patient-id.
           move "Buster" to patient-name.	
           move "Cat" to animal-type.
           move "Siamese" to breed.
           move "1" to treatment.
           move "377" to owner-id.
	     write jr-record.

	     move "00072" to patient-id.
           move "Missy" to patient-name.	
           move "Bird" to animal-type.
           move "Parakeet" to breed.
           move "6" to treatment.
           move "309" to owner-id.
	     write jr-record.

           close jr-file.                 
           Exit Program.
           Stop Run.

