       IDENTIFICATION DIVISION.
       PROGRAM-ID. codes.
       AUTHOR.  bbarr/mkirschen
       DATE-WRITTEN. 2001/01/02 PM 02:00.
       REMARKS.    Initial Version 5.2
           [This program creates a file that can be used to demonstrate SQL syntax supported by AcuODBC:  SELECT, INSERT, DELETE, and UPDATE.

           An AcuODBC Data Source Name needs to be set up using ODBC Manager.
           The program needs to be compiled with an -Fxa and -Fo option 
           pointing to path for XFD creation.  The program needs a .cfg file
           to point to the file directory when creating or adding to the
           data file.]


       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT qa-file
              ASSIGN TO "codes"
              ORGANIZATION IS INDEXED
              ACCESS IS DYNAMIC
              RECORD KEY IS treatment
              FILE STATUS IS qa-file-status.

       DATA DIVISION.
       FILE SECTION.
       FD  qa-file.
       01  qa-record.
           05 treatment                    pic x(5).
           05 explanation			 pic x(30).
		   
       WORKING-STORAGE SECTION.
           
       01  qa-file-status                  pic xx.

       PROCEDURE DIVISION.

       MAIN-LOGIC.

           open output qa-file.
           move "1" to treatment.
           move "General" to explanation.	
           write qa-record.

           move "2" to treatment.
           move "Vaccination" to explanation.	
           write qa-record.
   
           move "3" to treatment.
           move "Surgery" to explanation.	
           write qa-record.
              
           move "4" to treatment.
           move "Consultation" to explanation.	
           write qa-record.

           move "5" to treatment.
           move "Lab Work" to explanation.	
           write qa-record.
      
           move "6" to treatment.
           move "Pharmacy" to explanation.	
           write qa-record.

	     close qa-file.                 
           Exit Program.
           Stop Run.

