       identification division.
       program-id.    altkey.

       environment division.
       configuration section.

      $SET CREATEXFD
      $SET CALLFH(ACUFH)
       input-output section.
       file-control.

           select ftestcnd-file
           assign to disk "ftestdat"
           organization is indexed
           access is dynamic
           record key is ftestcnd-key
           alternate record key is ftestcnd-altkey1
                     with duplicates
           alternate record key is ftestcnd-altkey2
           status is ftestcnd-status.

       data division.
       file section.

       fd  ftestcnd-file.
       01  ftestcnd-record.
           03  ftestcnd-key              pic x(4).
           03  ftestcnd-altkey1.
               05 ftest_key1_seg1        pic x(2).
               05 ftest_key1_seg2        pic x(2).
           03  ftestcnd-altkey2          pic x(4).
           03  ftestcnd-number           pic 9(6).99.
      $xfd when ftestcnd-key = "0103"
           03  ftestcnd-info             pic x(10).
      $xfd when ftestcnd-key = other
           03  ftestcnd-in               pic x(5).


       working-storage section.

       77  ftestcnd-status               pic x(2).
       77  menu-option                   pic 9(2).
           88  next-selected                 value 1.
           88  previous-selected             value 2.
           88  read-selected                 value 3.
           88  write-selected                value 4.
           88  delete-selected               value 5.
           88  rewrite-selected              value 6.
           88  start-1-selected              value 7.
           88  start-2-selected              value 8.
           88  start-3-selected              value 9.
           88  open-inp-selected             value 10.
           88  open-out-selected             value 11.
           88  open-io-selected              value 12.
           88  close-selected                value 13.
           88  load-selected                 value 14.
           88  end-selected                  value 15.

      * standard error values
       77  f-int-errno                   pic s9(4) comp-5 external.
       77  f-errno                       pic s9(4) comp-5 external.
           88  f-in-error                    values 1 thru 99.
           88  e-sys-err                     value 1.
           88  e-param-err                   value 2.
           88  e-too-many-files              value 3.
           88  e-mode-clash                  value 4.
           88  e-rec-locked                  value 5.
           88  e-broken                      value 6.
           88  e-duplicate                   value 7.
           88  e-not-found                   value 8.
           88  e-undef-record                value 9.
           88  e-disk-full                   value 10.
           88  e-file-locked                 value 11.
           88  e-rec-changed                 value 12.
           88  e-mismatch                    value 13.
           88  e-no-memory                   value 14.
           88  e-missing-file                value 15.
           88  e-permission                  value 16.
           88  e-no-support                  value 17.
           88  e-no-locks                    value 18.
           88  e-interface                   value 19.
           88  w-no-support                  value 100.
           88  w-dup-ok                      value 101.

      *---------------------------------------------------

       01  error-items.
           03 filler pic x(20) value   "System Error".
           03 filler pic x(20) value   "Parameter error".
           03 filler pic x(20) value   "Too many files".
           03 filler pic x(20) value   "Mode Clash".
           03 filler pic x(20) value   "Record Locked".
           03 filler pic x(20) value   "Broken File".
           03 filler pic x(20) value   "Duplicate Key".
           03 filler pic x(20) value   "Record Not Found".
           03 filler pic x(20) value   "Undefined Record".
           03 filler pic x(20) value   "Disk Full".
           03 filler pic x(20) value   "File Locked".
           03 filler pic x(20) value   "Record Changed".
           03 filler pic x(20) value   "Mismatch".
           03 filler pic x(20) value   "No Memory ".
           03 filler pic x(20) value   "Missing File".
           03 filler pic x(20) value   "Permission Error".
           03 filler pic x(20) value   "No Support".
           03 filler pic x(20) value   "No Locks".
           03 filler pic x(20) value   "Interface".
           03 filler pic x(20) value   "No Support".
           03 filler pic x(20) value   "Duplicates OK".

       01  error-table redefines error-items.
           03 error-lit occurs 21 times pic x(20).

      *---------------------------------------------------

       01  error-window                  pic x(10).
       01  error-text                    pic x(80).
       01  error-status.
           03 primary-error              pic x(2).
           03 secondary-error            pic x(10).
       01  sql-command                   pic x(50000).
       77  indx1                         pic 9(2).
       77  indx2                         pic 9(2).
       77  indx3                         pic 9(2).
       01  group-item.
           03 grp1                       pic x(2).
           03 grp2                       pic x(2).

       screen section.

       01  record-screen.
           03  primary-screen.
               05  "Primary: ", line 4 column 5.
               05  using ftestcnd-key, line 4, column 14.
           03  alt1-screen.
               05  "Alt1: ", line 5 ,column 5.
               05  using ftestcnd-altkey1, line 5, column 14.
           03  alt2-screen.
               05  "Alt2: ", line 6 ,column 5.
               05  using ftestcnd-altkey2, line 6, column 14.
           03  info-screen.
               05  "Info Field: ",line 7 column 5.
               05  using ftestcnd-info, line 7, column 17.
           03  number-screen.
               05  "number Field: ",line 8 column 5.
               05  using ftestcnd-number, line 8, column 20.
           03  in_screen.
               05  "In Field: ",line 9 column 5.
               05  using ftestcnd-in, line 9, column 20.
           03  read_me_screen.
               05  "READ_ME.cnd has usage instructions",
                   line 12 column 3.

       01  options-screen.
           03  "1. Next ",         line 14 column 5.
           03  "2. Previous ",     line 15 column 5.
           03  "3. Read ",         line 16 column 5.
           03  "4. Write ",        line 17 column 5.
           03  "5. Delete ",       line 18 column 5.
           03  "6. Rewrite ",      line 19 column 5.
           03  "7. Start 0",       line 20 column 5.

           03  "8. Start 1",       line 14 column 25.
           03  "9. Start 2",       line 15 column 25.
           03  "10. Open Input",   line 16 column 25.
           03  "11. Open Output",  line 17 column 25.
           03  "12. Open IO",      line 18 column 25.
           03  "13. Close",        line 19 column 25.
           03  "14. Load ",        line 20 column 25.
           03  "15. End ",         line 21 column 25.
           03  using menu-option, line 22 column 5.


       procedure division.
       declaratives.
       ftest-err-handling section.
           use after standard error procedure on ftestcnd-file.
       ftest-err.
           call "C$RERR" using error-status, error-text.
           display window line 8 column 20 size 40 lines 8 ,
                   centered title "ERROR",
                   boxed, pop-up area error-window.

           display "FILE STATUS: ",ftestcnd-status.
           display "SECONDARY ERROR: ",secondary-error.
           if f-errno not = 0
               display "COBOL ERROR: ",error-lit(f-errno),bold.
           display "SQL ERROR: ",error-text.
           accept omitted.
           close window error-window.
       end declaratives.


       level-1 section.
       main-logic.
           set configuration "KEYSTROKE" to "EDIT=NEXT TERMINATE=13 ^M".
           display window erase.
           move all spaces to ftestcnd-record.
           display record-screen.
           display options-screen.
           display box line 2 column 2 size 40 lines 9,
                   title "FTESTCND RECORD".
           display box line 13 column 2 size 40 lines 11,
                   title "OPTIONS".
           perform get-option with test after until end-selected.
      *********** remove comment next two lines turn off trace statements
      *        move "SET TRACE OFF " to sql-command.
      *        inspect sql-command replacing trailing space by low-value.

           commit.
           stop run.

       get-option.
           accept options-screen.
           display omitted line 23 column 40 erase end line.
           evaluate true
             when  next-selected
               perform do-next
             when  previous-selected
               perform do-previous
             when  read-selected
               perform do-read
             when  write-selected
               perform do-write
             when  delete-selected
               perform do-delete
             when  rewrite-selected
               perform do-rewrite
             when  start-1-selected
               perform do-start-1
             when  start-2-selected
               perform do-start-2
             when  start-3-selected
               perform do-start-3
             when  open-inp-selected
               open input ftestcnd-file
               if ftestcnd-status = "00"
                   display "open successful" line 23 column 40
                               erase end line
               end-if
               move spaces to menu-option
             when  open-out-selected
               open output ftestcnd-file
               if ftestcnd-status = "00"
                   display "open successful" line 23 column 40
                               erase end line
               end-if
               move spaces to menu-option
             when  open-io-selected
               open i-o ftestcnd-file
               if ftestcnd-status = "00"
                   display "open successful" line 23 column 40
                               erase end line
               end-if
               move spaces to menu-option
      *********** remove comment next three lines to see more trace statements
      *        move "ALTER SESSION SET SQL_TRACE TRUE " to sql-command
      *        inspect sql-command replacing trailing space by low-value
      *        call "sql.acu" using sql-command

             when  close-selected
               close ftestcnd-file
               if ftestcnd-status = "00"
                   display "close successful" line 23 column 40
                               erase end line
               end-if
               move spaces to menu-option
             when  load-selected
               open output ftestcnd-file
               if ftestcnd-status = "00"
                   perform load-file
               end-if
               close ftestcnd-file
               if ftestcnd-status = "00"
                   display "load successful" line 23 column 40
                               erase end line
               end-if
               move spaces to menu-option
             when  end-selected
               continue
           end-evaluate.

       file-operations.
       do-next.
           move spaces to ftestcnd-record.
           read ftestcnd-file next record .
           if ftestcnd-status = "00"
               display "next successful" line 23 column 40
                               erase end line.
           display record-screen.
       do-previous.
           move spaces to ftestcnd-record.
           read ftestcnd-file previous record.
           if ftestcnd-status = "00"
               display "previous successful" line 23 column 40
                               erase end line.
           display record-screen.
       do-read.
           move spaces to ftestcnd-record.
           accept primary-screen.
           read ftestcnd-file record.
           if ftestcnd-status = "00"
               display "read successful" line 23 column 40
                               erase end line.
           display record-screen.

       do-write.
           accept record-screen.
           write ftestcnd-record.
           if ftestcnd-status = "00"
               display "write successful" line 23 column 40
                               erase end line.
       do-delete.
           accept primary-screen.
           delete ftestcnd-file record.
           if ftestcnd-status = "00"
               display "delete successful" line 23 column 40
                               erase end line.

       do-rewrite.
           accept record-screen.
           rewrite ftestcnd-record.
           if ftestcnd-status = "00"
               display "rewrite successful" line 23 column 40
                               erase end line.

       do-start-1.
           move spaces to ftestcnd-record.
           accept primary-screen.
           start ftestcnd-file key not less ftestcnd-key.
           if ftestcnd-status = "00"
               display "start primary successful" line 23 column 40
                               erase end line.
       do-start-2.
           move spaces to ftestcnd-record.
           accept alt1-screen.
           start ftestcnd-file key not less ftestcnd-altkey1.
           if ftestcnd-status = "00"
               display "start first alt successful" line 23 column 40
                               erase end line.
       do-start-3.
           move spaces to ftestcnd-record.
           accept alt2-screen.
           start ftestcnd-file key not less ftestcnd-altkey2.
           if ftestcnd-status = "00"
               display "start second alt successful" line 23 column 40
                               erase end line.

       load-file.
           perform varying indx1 from 1 by 1 until indx1 > 5
               perform varying indx2 from 1 by 1 until indx2 > 4
                   perform load-record
                   write ftestcnd-record
               end-perform
           end-perform.

       load-record.
           move indx1 to grp1, ftest_key1_seg1, ftest_key1_seg2.
           move indx2 to grp2.
           move group-item to ftestcnd-key,
                              ftestcnd-altkey2,
                              ftestcnd-info.
           move indx2 to ftestcnd-in.
           move indx1 to ftestcnd-number.
