       identification division.
       program-id.    demo.
       author.        Micro Focus IP, Ltd.
      *>       This program is a simple maintenance program for an "order"
      *>       file.  It is intended to show how database tables can be
      *>       used from ACUCOBOL-GT using normal COBOL file processing
      *>       statements and Acu4GL.

      $SET CREATEXFD

       environment division.
       configuration section.

       input-output section.
       file-control.

      * This is the select for the "order" file.  Note that it is a
      * standard COBOL select.

       select optional order-file
               assign to disk "orderfile"
               organization is indexed
               access mode dynamic
               record key is order-num
               alternate record key is customer-num with duplicates
               file status is order-status.

      * The order-num-file is used to hold the next available order number
      * for "add" mode.  Because it is a relative file, it will not be
      * created as a table in the database.

       select optional order-num-file
               assign to disk "ordernum"
               organization is relative
               access mode dynamic
               relative key is order-num-key
               file status is order-num-status.

       data division.
       file section.

      * Here is the FD for the "order" file.  Since this case is very
      * simple, we don't need to add any directives.

       fd  order-file.
       01  order-record.
           03  order-num                pic x(4).
           03  order-fields.
      $xfd date=yymmdd
               05  order-date           pic 9(6).
               05  customer-num         pic x(3).
               05  ship-instruct        pic x(40).
               05  backlog              pic x.
               05  po-num               pic x(10).
      $xfd date=yymmdd
               05  ship-date            pic 9(6).
               05  ship-weight          pic 9(6)v99.
               05  ship-charge          pic 9(4)v99.
      $xfd date=yymmdd
               05  paid-date            pic 9(6).

       fd  order-num-file.
       01  order-num-record             pic 9(4).

       working-storage section.

       78  col-1                            value 02.
       78  col-2                            value 15.
       78  col-3                            value 28.
       78  col-4                            value 39.

       77  save-order-rec               pic x(100).

       01  flags.
           03  prog-mode                pic x.
               88  add-mode                 value 'A'.
               88  change-mode              value 'C'.
           03  file-mode                pic x.
               88  sequential-mode          value 'S' false 'D'.

       77  order-status                 pic xx.
       77  order-num-status             pic xx.
       77  order-num-key                pic 9        value 1.
       77  menu-selection               pic x.

       01  credentials.
           03  username                 pic x(20).
           03  password                 pic x(20).

      * Multi-lingual answer: "Yes", "Ja", "Oui", "Si"
       77  yes-no-answer                pic x.
           88  answer-yes                   values "Y", "J", "O", "S"
                                                   "y", "j", "o", "s"
                                            false "N".

       screen section.

       01  help-screen.
           03  blank screen.
           03  "This simple program demonstrates how to access"
                line 3 col 3.
           03  "database tables using ACUCOBOL-GT and Acu4GL"
                line + 1 col 3.
           03  "or Micro Focus Database Connectors.  This program"
                line + 1 col 3.
           03  "is very simple - it does no validation of the data."
                line + 1 col 3.
           03  "Note that no embedded SQL or any other special"
                line + 2 col 3.
           03  "syntax is used to access the database table."
                line + 1 col 3.
           03  "Instead, standard COBOL file statements are"
                line + 1 col 3.
           03  "used - the product performs a translation of these"
                line + 1 col 3.
           03  "statements into SQL automatically.  It also"
                line + 1 col 3.
           03  "performs conversions between COBOL data types"
                line + 1 col 3.
           03  "and database data types.  For example, the date"
                line + 1 col 3.
           03  "fields are declared as PIC 9(6) in COBOL while"
                line + 1 col 3.
           03  "they might be declared as type ""date"" in the"
                line + 1 col 3.
           03  "database."
                line + 1 col 3.
           03  "Press <ENTER> to return to the program"
                line + 3 col 3.
           03  pic x using yes-no-answer.

      ***   A big messy screen to handle displaying and entering the "order" data.
       01  order-screen.
           03  blank screen.
           03  line 2.
           03  order-num-screen.
               05  "Order #" column col-1.
               05  pic x(4) using order-num column col-2.
           03  order-date-screen.
               05  "Order Date" column col-3.
               05  pic 9(6) using order-date column col-4.
           03  order-data-screen.
               05  customer-num-screen          line + 2.
                   07  "Customer #" column col-1.
                   07  pic x(3) using customer-num column col-2 auto.
               05  po-num-screen                line + 2.
                   07  "PO #" column col-1.
                   07  pic x(10) using po-num column col-2 auto.
               05  backlog-screen.
                   07  "Backlog?" column col-3.
                   07  pic x using backlog column col-4 auto.
               05  ship-weight-screen           line + 2.
                   07  "Ship Weight:" column col-1.
                   07  pic z(5)9.99 using ship-weight column col-2 auto.
               05  ship-date-screen.
                   07  "Ship Date" column col-3.
                   07  pic 9(6) using ship-date column col-4 auto.
               05  ship-charge-screen           line + 2.
                   07  "Ship Charge" column col-1.
                   07  pic zzz9.99 using ship-charge column col-2 auto.
               05  paid-date-screen.
                   07  "Paid Date" column col-3.
                   07  pic 9(6) using paid-date column col-4 auto.
               05  ship-instruct-screen         line + 2.
                   07  "Instructions" column col-1.
                   07  pic x(40) using ship-instruct column col-2 auto.

       01  menu-screen.
           03  "F)irst, P)rev, N)ext, L)ast, D)elete, S)earch, A)dd, E)d
      -        "it, H)elp, Q)uit " line 23 col 5.
           03  pic x using menu-selection auto.

       01  save-modified-record-screen.
           03  "This record has been modified.  Save it? "
               line 23 col 2 erase eol.
           03  pic x using yes-no-answer auto.

       01  login-screen.
           03  blank screen.
           03  "Before connecting to the database, we need to set"
               line 5 col 5.
           03  "environment variables for login and password, rather"
               line 6 col 5.
           03  "than hard-coding the values in the COBOL program, or"
               line 7 col 5.
           03  "in a configuration file.  Please enter your username"
               line 8 col 5.
           03  "and password below." line 9 col 5.
           03  "Username: " line 12 col 5.
           03  pic x(20) using username line 12 col 15.
           03  "Password: " line 13 col 5.
           03  pic x(20) using password line 13 col 15.

       procedure division.
       declaratives.
       order-err-handling section.
           use after standard error procedure on order-file.
       order-err.
           display "File Status:" line 24 column 2.
           display order-status line 24 column 16.
           accept yes-no-answer.
       end declaratives.

       main-logic.
           perform init-demo.
           if order-num-record > 0
               perform read-first-record
           else
               perform get-new-record
           end-if.
           perform do-command until menu-selection = "q" or "Q".
           stop run.

       do-command.
           display order-screen.
           display menu-screen.
           accept menu-screen.
           evaluate menu-selection
             when "F"
             when "f"
               perform read-first-record

             when "P"
             when "p"
               perform read-prev-record

             when "N"
             when "n"
               perform read-next-record

             when "L"
             when "l"
               perform read-last-record

             when "D"
             when "d"
               perform delete-record

             when "S"
             when "s"
               perform search-record

             when "A"
             when "a"
               perform get-new-record
               display order-screen
               accept order-screen
               perform test-record-modified

             when "E"
             when "e"
               accept order-screen
               perform test-record-modified

             when "H"
             when "h"
               perform show-help

             when "Q"
             when "q"
               continue

           end-evaluate.

       test-record-modified.
           if order-record not = save-order-rec
               display save-modified-record-screen
               set answer-yes to true
               accept save-modified-record-screen
               if answer-yes
                   perform save-record
               end-if
           end-if.

       get-new-record.
           initialize order-record.
           add 1 to order-num-record.
           move order-num-record to order-num.
           subtract 1 from order-num-record.
           accept order-date from date.
           move order-record to save-order-rec.
           set add-mode to true.
           set sequential-mode to false.

       delete-record.
           delete order-file.
           perform read-next-record.

       save-record.
           if add-mode
               write order-record
               move order-num to order-num-record
               rewrite order-num-record
           else
               rewrite order-record
           end-if.
           set change-mode to true.
           move order-record to save-order-rec.

       read-first-record.
           move low-values to order-num.
           set sequential-mode to false.
           perform read-next-record.

       read-last-record.
           move high-values to order-num.
           set sequential-mode to false.
           perform read-prev-record.

       read-next-record.
           if not sequential-mode
               start order-file key not < order-num
                 invalid key
                   perform get-new-record
                   exit paragraph
               end-start
           end-if.
           read order-file next
             at end
               perform get-new-record
               exit paragraph
           end-read.
           set sequential-mode to true.
           move order-record to save-order-rec.

       read-prev-record.
           if not sequential-mode
               start order-file key not > order-num
                 invalid key
                   perform get-new-record
                   exit paragraph
               end-start
           end-if.
           read order-file previous
             at end
               perform read-first-record
           end-read.
           set sequential-mode to true.
           move order-record to save-order-rec.

       search-record.
           accept order-num-screen.
           set sequential-mode to false.
           perform read-next-record.

       show-help.
           display help-screen
           accept help-screen
           .

       init-demo.
           display "DEFAULT_HOST" upon environment-name
           display "MSSQL" upon environment-value
           display login-screen
           accept login-screen
           display "A_MSSQL_LOGIN" upon environment-name
           display username upon environment-value
           display "A_MSSQL_PASSWD" upon environment-name
           display password upon environment-value
           initialize order-num-record.
           open i-o order-file.
           open i-o order-num-file.
           if order-num-status is = "05"
               move zero to order-num-record
               write order-num-record
           else
               read order-num-file
           end-if.
