#!/bin/sh
#
# Copyright (C) 2009-2014 Micro Focus. All rights reserved.
# 
# ======================================================================
# =  acuxdbcs.sh
# =
# =  AcuXDBC Server utility program
# =  Usage: acuxdbcs.sh -help
# =         acuxdbcs.sh -info [-n port] [server]
# =         acuxdbcs.sh -kill [-n port] [server]
# =         acuxdbcs.sh -start [-n port ] [-l]
# =
# =
# ======================================================================

# ======================================================================
# =
# =  Set up default values
# =
# ======================================================================

. ${GENESIS_HOME}/bin/axset.sh


XDBC_SERVER=`hostname`
XDBC_LOG=

# ======================================================================
# show usage
# ======================================================================

show_usage()
{
	echo ""
        echo Usage: 
	echo        acuxdbcs.sh -help
	echo        acuxdbcs.sh -info [-n port] [server]
	echo        acuxdbcs.sh -kill [-n port] [server]
	echo        acuxdbcs.sh -start [-n port] [-l]
	echo ""

}

# ======================================================================
# do_info
# ======================================================================
do_info()
{

while [ "$#" -gt "0" ]
do
	case "$1" in
		"-n")
			shift
			XDBC_PORT=$1
			shift
			;;
		*)
			XDBC_SERVER=$1
			shift
			;;
	esac
done

"${XDBC_BIN}"xdbcping -z -p"${XDBC_PORT}" "${XDBC_SERVER}"


}


# ======================================================================
# do_kill
# ======================================================================
do_kill()
{

while [ "$#" -gt "0" ]
do
	case "$1" in
		"-n")
			shift
			XDBC_PORT=$1
			shift
			;;
		*)
			XDBC_SERVER=$1
			shift
			;;
	esac
done

"${XDBC_BIN}"xdbckill -z -p"${XDBC_PORT}" "${XDBC_SERVER}"


}



# ======================================================================
# do_start
# ======================================================================
do_start()
{

while [ "$#" -gt "0" ]
do
	case "$1" in
		"-l")
			shift
			XDBC_LOG=log
			;;
		"-n")
			shift
			XDBC_PORT=$1
			shift
			;;
	esac
done

echo "${XDBC_BIN}"xdbcsrvr -z -p${XDBC_PORT} ${XDBC_KEY} ${XDBC_LOG} 
"${XDBC_BIN}"xdbcsrvr -z -p${XDBC_PORT} ${XDBC_KEY} ${XDBC_LOG} &


}


case "$1" in
	"-info")
		shift
		do_info $1 $2 $3
		;;
	"-kill")
		shift
		do_kill $1 $2 $3
		;;
	"-start")
		shift
		do_start $1 $2 $3
		;;
	*)
		show_usage
		break
		;;
esac

# ======================================================================
# =
# =     End acuxdbcs.sh
# =
# ======================================================================

