/*
 * Decompiled with CFR 0.152.
 */
package com.acucorp.acucobolgt;

import com.acucorp.acucobolgt.AcuSecurityManager;
import com.acucorp.acucobolgt.CALL_OPTIONS;
import com.acucorp.acucobolgt.StatusInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CVM {
    private boolean _init;
    private boolean _shutdown;
    private int _errorNum;
    private String _error;
    private boolean _runningWindows;
    private Logger _log;
    private StatusInfo _statusInfo;
    private boolean _logInit;
    private static CVM _cvm = null;
    private static Properties _options = null;
    private String _LastErrorMsg;
    private String _RunPath;
    private String _Switches;
    private String _ConfigFile;
    private String _ErrorsOut;
    private String _ErrorsAppend;
    private String _KeyFile;
    private String _Import;
    private String _Plays;
    private String _DisplayOut;
    private String _DisplayAppend;
    private String _DebugCmds;
    private String _TerminalOut;
    private String _ObjLib;
    private String _EmbeddedLib;
    private boolean _TerminalInit;
    private boolean _CGIWarnings;
    private boolean _IgnoreSignals;
    private boolean _ListConfig;
    private boolean _NoSaveDebug;
    private boolean _SafeMode;
    private boolean _NonNumeric;
    private boolean _ExtendedError;
    private boolean _DumpMem;
    private boolean _ThrowErrors;
    private boolean _CharToGui;
    private boolean _ZipErrorFile;
    private boolean _LinkageLength;

    public static int logParamsExt(Object[] objectArray) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        return _cvm.logParams(objectArray);
    }

    public static boolean LogNativeMessagesExt(boolean bl) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        return _cvm.LogNativeMessages(bl);
    }

    public static int acu_initvExt(Properties properties, String[] stringArray) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        return _cvm.acu_initv(properties, stringArray);
    }

    public static int acu_cobolExt(Properties properties, Object[] objectArray, StatusInfo statusInfo) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        return _cvm.acu_cobol(properties, objectArray, statusInfo);
    }

    public static void acu_cancelExt(String string) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        _cvm.acu_cancel(string);
    }

    public static void acu_unloadExt(String string, int n) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        _cvm.acu_unload(string, n);
    }

    public static void acu_shutdownExt(int n) {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        _cvm.acu_shutdown(n);
    }

    public static void acu_cancel_allExt() {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        _cvm.acu_cancel_all();
    }

    public static void acu_unload_allExt() {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        _cvm.acu_unload_all();
    }

    public static void setupJVMExt() {
        if (_cvm == null) {
            _cvm = new CVM();
        }
        _cvm.setupJVM();
    }

    public native int logParams(Object[] var1);

    public native boolean LogNativeMessages(boolean var1);

    private native int acu_initv(Properties var1, String[] var2);

    private native int acu_cobol(Properties var1, Object[] var2, StatusInfo var3);

    private native void acu_cancel(String var1);

    private native void acu_unload(String var1, int var2);

    private native void acu_shutdown(int var1);

    private native void acu_cancel_all();

    private native void acu_unload_all();

    private native void setupJVM();

    private CVM() {
    }

    private CVM(String string) {
        this._logInit = true;
        try {
            System.setProperty("java.util.logging.config.file", string);
            this._log = Logger.getLogger("com.acucorp.acucobolgt.CVM");
        }
        catch (Exception exception) {
            System.out.println("Log not intialized; logging turned off.");
            this._logInit = false;
        }
        this._init = false;
        this._errorNum = 0;
        this._runningWindows = false;
        try {
            this._statusInfo = new StatusInfo();
            _options = new Properties();
            Properties properties = System.getProperties();
            String string2 = properties.getProperty("os.name");
            string2 = string2.toLowerCase();
            if (string2.indexOf("windows") >= 0) {
                this._runningWindows = true;
                try {
                    System.loadLibrary("wrun32");
                }
                catch (SecurityException securityException) {
                    System.setSecurityManager(new AcuSecurityManager());
                    System.loadLibrary("wrun32");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    System.out.println("CVM: load library wrun32 failed.");
                    this.setError("Exception caught loading CVM:  " + unsatisfiedLinkError.getMessage());
                    System.out.println("CVM:  " + this.getCVMError());
                    throw unsatisfiedLinkError;
                }
            } else {
                try {
                    System.loadLibrary("runcbl");
                }
                catch (SecurityException securityException) {
                    System.setSecurityManager(new AcuSecurityManager());
                    System.loadLibrary("runcbl");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    try {
                        System.loadLibrary("runcbl64");
                    }
                    catch (SecurityException securityException) {
                        System.setSecurityManager(new AcuSecurityManager());
                        System.loadLibrary("runcbl64");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                        System.out.println("CVM: load library runcbl or runcbl64 failed.");
                        this.setError("Exception caught loading CVM:  " + unsatisfiedLinkError2.getMessage());
                        System.out.println("CVM:  " + this.getCVMError());
                        throw unsatisfiedLinkError2;
                    }
                }
            }
            System.out.println("CVM90");
            this.cblLog("CVM90");
            this.setupJVM();
            _options.setProperty("os.name", string2);
            _options.setProperty("display", "-d");
            _options.setProperty("tty", "");
            _options.setProperty("debug", "0");
            _options.setProperty("cache", "1");
            _options.setProperty("num.params", "0");
            _options.setProperty("signal.number", "0");
            _options.setProperty("no.stop", "1");
            this._ErrorsAppend = this._EmbeddedLib = new String("");
            this._ErrorsOut = this._EmbeddedLib;
            this._ConfigFile = this._EmbeddedLib;
            this._Switches = this._EmbeddedLib;
            this._RunPath = this._EmbeddedLib;
            this._LastErrorMsg = this._EmbeddedLib;
            this._TerminalOut = this._ObjLib = new String("");
            this._DebugCmds = this._ObjLib;
            this._DisplayAppend = this._ObjLib;
            this._DisplayOut = this._ObjLib;
            this._Plays = this._ObjLib;
            this._Import = this._ObjLib;
            this._KeyFile = this._ObjLib;
            this._SafeMode = false;
            this._NoSaveDebug = false;
            this._ListConfig = false;
            this._IgnoreSignals = false;
            this._CGIWarnings = false;
            this._TerminalInit = false;
            this._LinkageLength = false;
            this._ZipErrorFile = false;
            this._CharToGui = false;
            this._ThrowErrors = false;
            this._DumpMem = false;
            this._ExtendedError = false;
            this._NonNumeric = false;
            this.transfer();
        }
        catch (Exception exception) {
            System.out.println("CVM:  exception caught in constructor");
            System.out.println("CVM:  " + this.getCVMError());
        }
    }

    public static synchronized CVM GET_INSTANCE(String string) {
        if (_cvm == null) {
            _cvm = new CVM(string);
        }
        return _cvm;
    }

    public static synchronized CVM GET_INSTANCE() {
        if (_cvm == null) {
            _cvm = new CVM("logging.properties");
        }
        return _cvm;
    }

    public synchronized boolean initialize(String string) {
        boolean bl = true;
        String[] stringArray = string.split("\\s");
        bl = this.initialize(stringArray);
        return bl;
    }

    public synchronized boolean initialize() {
        boolean bl = true;
        String[] stringArray = this.getCommandLineArray();
        bl = this.initialize(stringArray);
        return bl;
    }

    public synchronized boolean initialize(String[] stringArray) {
        boolean bl = true;
        try {
            if (this.acu_initv(_options, stringArray) != 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            this.setError("Exception caught loading initialize:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
        return bl;
    }

    public synchronized int callProgram(String string, Object[] objectArray, CALL_OPTIONS cALL_OPTIONS) {
        int n = -1;
        try {
            cALL_OPTIONS.setOption("program.name", string);
            n = this.acu_cobol(cALL_OPTIONS.getOptions(), objectArray, this._statusInfo);
            this.setLastErrorMsg(this._statusInfo.exit_msg);
            this.cblLog("Call error: " + this._statusInfo.call_error);
            this.cblLog("Exit code: " + this._statusInfo.exit_code);
            this.cblLog("Signal number: " + this._statusInfo.signal_number);
            this.cblLog("Exit message: [" + this._statusInfo.exit_msg + "]");
        }
        catch (Exception exception) {
            this.setError("Exception caught loading CVM:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
        return n;
    }

    public synchronized void cancelProgram(String string) {
        try {
            this.acu_cancel(string);
        }
        catch (Exception exception) {
            this.setError("Exception caught acuCancel:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
    }

    public synchronized void cancelAllPrograms() {
        try {
            this.acu_cancel_all();
        }
        catch (Exception exception) {
            this.setError("Exception caught acuCancelAll:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
    }

    public synchronized void unloadProgram(String string) {
        try {
            this.acu_unload(string, 0);
        }
        catch (Exception exception) {
            this.setError("Exception caught acuUnload:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
    }

    public synchronized void unloadAllPrograms() {
        try {
            this.acu_unload_all();
        }
        catch (Exception exception) {
            this.setError("Exception caught acuUnloadAll:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
    }

    public synchronized void shutdown() {
        try {
            this._shutdown = true;
            this.acu_shutdown(0);
        }
        catch (Exception exception) {
            this.setError("Exception caught acuShutdown:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
    }

    public void setLog(Logger logger) {
        if (logger == null) {
            return;
        }
        this._log = logger;
        this._logInit = true;
    }

    private void cblLogAll(String string) {
        this.cblLog(Level.ALL, string);
    }

    public static void WriteExceptiontoLog(Logger logger, Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        logger.info(stringWriter.toString());
    }

    private void cblLog(String string) {
        this.cblLog(Level.INFO, string);
    }

    private void cblLog(Level level, String string) {
        if (!this._logInit) {
            return;
        }
        if (level == Level.OFF) {
            return;
        }
        if (this._log != null) {
            this._log.log(level, string);
        }
    }

    public StatusInfo GetStatusInfo() {
        return this._statusInfo;
    }

    private void setError(String string) {
        this._error = string;
    }

    public String getCVMError() {
        return this._error;
    }

    public void showCurrentProperties() {
        try {
            this.cblLog("CVM:  ********** Current Properties **********");
            Enumeration<?> enumeration = _options.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                this.cblLog("CVM:  Property/Value: [" + string + " : " + _options.getProperty(string) + "]");
            }
        }
        catch (Exception exception) {
            this.setError("Exception caught showCurrentProperties:  " + exception.getMessage());
            this.cblLog("CVM:  " + this.getCVMError());
        }
    }

    public String getOption(String string) {
        this.transfer();
        return _options.getProperty(string);
    }

    public void setOption(String string, String string2) {
        _options.setProperty(string, string2);
        this.push();
    }

    private String[] buildCommandLineArray(String string) {
        Vector vector = new Vector();
        String[] stringArray = string.split("\\s");
        stringArray = (String[])vector.toArray();
        return stringArray;
    }

    private String[] getCommandLineArray() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        String string = new String("");
        vector.add(new String("runcbl"));
        if (this._TerminalInit) {
            vector.add(new String("-b"));
        }
        if (this._CGIWarnings) {
            vector.add(new String("-f"));
        }
        if (this._IgnoreSignals) {
            vector.add(new String("-h"));
        }
        if (this._ListConfig) {
            vector.add(new String("-l"));
        }
        if (this._NoSaveDebug) {
            vector.add(new String("--no-save-debug"));
        }
        if (this._SafeMode) {
            vector.add(new String("-s"));
        }
        if (this._NonNumeric) {
            vector.add(new String("-w"));
        }
        if (this._ExtendedError) {
            vector.add(new String("-x"));
        }
        if (this._DumpMem) {
            vector.add(new String("-z"));
        }
        if (this._ThrowErrors) {
            vector.add(new String("-throw"));
        }
        if (this._CharToGui) {
            vector.add(new String("--CharToGui"));
        }
        if (this._ZipErrorFile) {
            vector.add(new String("-g"));
        }
        if (this._LinkageLength) {
            vector.add(new String("-u"));
        }
        if (this._Switches.length() > 0) {
            vector.add(new String("-#"));
        }
        if (this._ConfigFile.length() > 0) {
            vector.add(new String("-c"));
            vector.add(this._ConfigFile);
        }
        if (this._ErrorsOut.length() > 0) {
            vector.add(new String("-e"));
            vector.add(this._ErrorsOut);
        }
        if (this._ErrorsAppend.length() > 0) {
            vector.add(new String("+e"));
            vector.add(this._ErrorsAppend);
        }
        if (this._KeyFile.length() > 0) {
            vector.add(new String("-I"));
            vector.add(this._KeyFile);
        }
        if (this._Import.length() > 0) {
            vector.add(new String("-import"));
            vector.add(this._Import);
        }
        if (this._Plays.length() > 0) {
            vector.add(new String("-k"));
            vector.add(this._Plays);
        }
        if (this._DisplayOut.length() > 0) {
            vector.add(new String("-o"));
            vector.add(this._DisplayOut);
        }
        if (this._DisplayAppend.length() > 0) {
            vector.add(new String("+o"));
            vector.add(this._DisplayAppend);
        }
        if (this._DebugCmds.length() > 0) {
            vector.add(new String("-r"));
            vector.add(this._DebugCmds);
        }
        if (this._TerminalOut.length() > 0) {
            vector.add(new String("-t"));
            vector.add(this._TerminalOut);
        }
        if (this._ObjLib.length() > 0) {
            vector.add(new String("-y"));
            vector.add(this._ObjLib);
        }
        if (this._EmbeddedLib.length() > 0) {
            vector.add(new String("-y"));
            vector.add(this._EmbeddedLib);
        }
        stringArray = vector.toArray(new String[0]);
        return stringArray;
    }

    private String getCommandLine() {
        String string = new String("runcbl");
        if (this._TerminalInit) {
            string = string + " -b";
        }
        if (this._CGIWarnings) {
            string = string + " -f";
        }
        if (this._IgnoreSignals) {
            string = string + " -h";
        }
        if (this._ListConfig) {
            string = string + " -l";
        }
        if (this._NoSaveDebug) {
            string = string + " --no-save-debug";
        }
        if (this._SafeMode) {
            string = string + " -s";
        }
        if (this._NonNumeric) {
            string = string + " -w";
        }
        if (this._ExtendedError) {
            string = string + " -x";
        }
        if (this._DumpMem) {
            string = string + " -z";
        }
        if (this._ThrowErrors) {
            string = string + " -throw";
        }
        if (this._CharToGui) {
            string = string + " --CharToGui";
        }
        if (this._ZipErrorFile) {
            string = string + " -g";
        }
        if (this._LinkageLength) {
            string = string + " -u";
        }
        if (this._Switches.length() > 0) {
            string = string + " -#" + this._Switches;
        }
        if (this._ConfigFile.length() > 0) {
            string = string + " -c " + this._ConfigFile;
        }
        if (this._ErrorsOut.length() > 0) {
            string = string + " -e " + this._ErrorsOut;
        }
        if (this._ErrorsAppend.length() > 0) {
            string = string + " +e " + this._ErrorsAppend;
        }
        if (this._KeyFile.length() > 0) {
            string = string + " -I " + this._KeyFile;
        }
        if (this._Import.length() > 0) {
            string = string + " -import " + this._Import;
        }
        if (this._Plays.length() > 0) {
            string = string + " -k " + this._Plays;
        }
        if (this._DisplayOut.length() > 0) {
            string = string + " -o " + this._DisplayOut;
        }
        if (this._DisplayAppend.length() > 0) {
            string = string + " +o " + this._DisplayAppend;
        }
        if (this._DebugCmds.length() > 0) {
            string = string + " -r " + this._DebugCmds;
        }
        if (this._TerminalOut.length() > 0) {
            string = string + " -t " + this._TerminalOut;
        }
        if (this._ObjLib.length() > 0) {
            string = string + " -y " + this._ObjLib;
        }
        if (this._EmbeddedLib.length() > 0) {
            string = string + " -y " + this._EmbeddedLib;
        }
        return string;
    }

    private void push() {
        this._LastErrorMsg = _options.getProperty("LastErrorMsg");
        this._Switches = _options.getProperty("Switches");
        this._ConfigFile = _options.getProperty("ConfigFile");
        this._ErrorsOut = _options.getProperty("ErrorsOut");
        this._ErrorsAppend = _options.getProperty("ErrorsAppend");
        this._KeyFile = _options.getProperty("KeyFile");
        this._Import = _options.getProperty("Import");
        this._Plays = _options.getProperty("Plays");
        this._DisplayOut = _options.getProperty("DisplayOut");
        this._DisplayAppend = _options.getProperty("DisplayAppend");
        this._DebugCmds = _options.getProperty("DebugCmds");
        this._TerminalOut = _options.getProperty("TerminalOut");
        this._ObjLib = _options.getProperty("ObjLib");
        this._EmbeddedLib = _options.getProperty("EmbeddedLib");
        this._TerminalInit = _options.getProperty("TerminalInit") == "1";
        this._CGIWarnings = _options.getProperty("CGIWarnings") == "1";
        this._IgnoreSignals = _options.getProperty("IgnoreSignals") == "1";
        this._ListConfig = _options.getProperty("ListConfig") == "1";
        this._NoSaveDebug = _options.getProperty("NoSaveDebug") == "1";
        this._SafeMode = _options.getProperty("SafeMode") == "1";
        this._NonNumeric = _options.getProperty("NonNumeric") == "1";
        this._ExtendedError = _options.getProperty("ExtendedError") == "1";
        this._DumpMem = _options.getProperty("DumpMem") == "1";
        this._ThrowErrors = _options.getProperty("ThrowErrors") == "1";
        this._CharToGui = _options.getProperty("CharToGui") == "1";
        this._ZipErrorFile = _options.getProperty("ZipErrorFile") == "1";
        this._LinkageLength = _options.getProperty("LinkageLength") == "1";
    }

    private void transfer() {
        _options.setProperty("LastErrorMsg", this._LastErrorMsg);
        _options.setProperty("Switches", this._Switches);
        _options.setProperty("ConfigFile", this._ConfigFile);
        _options.setProperty("ErrorsOut", this._ErrorsOut);
        _options.setProperty("ErrorsAppend", this._ErrorsAppend);
        _options.setProperty("KeyFile", this._KeyFile);
        _options.setProperty("Import", this._Import);
        _options.setProperty("Plays", this._Plays);
        _options.setProperty("DisplayOut", this._DisplayOut);
        _options.setProperty("DisplayAppend", this._DisplayAppend);
        _options.setProperty("DebugCmds", this._DebugCmds);
        _options.setProperty("TerminalOut", this._TerminalOut);
        _options.setProperty("ObjLib", this._ObjLib);
        _options.setProperty("EmbeddedLib", this._EmbeddedLib);
        _options.setProperty("TerminalInit", !this._TerminalInit ? "0" : "1");
        _options.setProperty("CGIWarnings", !this._CGIWarnings ? "0" : "1");
        _options.setProperty("IgnoreSignals", !this._IgnoreSignals ? "0" : "1");
        _options.setProperty("ListConfig", !this._ListConfig ? "0" : "1");
        _options.setProperty("NoSaveDebug", !this._NoSaveDebug ? "0" : "1");
        _options.setProperty("SafeMode", !this._SafeMode ? "0" : "1");
        _options.setProperty("NonNumeric", !this._NonNumeric ? "0" : "1");
        _options.setProperty("ExtendedError", !this._ExtendedError ? "0" : "1");
        _options.setProperty("DumpMem", !this._DumpMem ? "0" : "1");
        _options.setProperty("ThrowErrors", !this._ThrowErrors ? "0" : "1");
        _options.setProperty("CharToGui", !this._CharToGui ? "0" : "");
        _options.setProperty("ZipErrorFile", !this._ZipErrorFile ? "0" : "1");
        _options.setProperty("LinkageLength", !this._LinkageLength ? "0" : "1");
    }

    public String getLastErrorMsg() {
        return this._LastErrorMsg;
    }

    public String getRunPath() {
        this.cblLog(Level.WARNING, " getRunPath: command option -runpath not supported ");
        return new String(" command option -runpath not supported ");
    }

    public String getSwitches() {
        return this._Switches;
    }

    public String getConfigFile() {
        return this._ConfigFile;
    }

    public String getErrorsOut() {
        return this._ErrorsOut;
    }

    public String getErrorsAppend() {
        return this._ErrorsAppend;
    }

    public String getKeyFile() {
        return this._KeyFile;
    }

    public String getImport() {
        return this._Import;
    }

    public String getPlays() {
        return this._Plays;
    }

    public String getDisplayOut() {
        return this._DisplayOut;
    }

    public String getDisplayAppend() {
        return this._DisplayAppend;
    }

    public String getDebugCmds() {
        return this._DebugCmds;
    }

    public String getTerminalOut() {
        return this._TerminalOut;
    }

    public String getObjLib() {
        return this._ObjLib;
    }

    public String getEmbeddedLib() {
        return this._EmbeddedLib;
    }

    public boolean getTerminalInit() {
        return this._TerminalInit;
    }

    public boolean getCGIWarnings() {
        return this._CGIWarnings;
    }

    public boolean getIgnoreSignals() {
        return this._IgnoreSignals;
    }

    public boolean getListConfig() {
        return this._ListConfig;
    }

    public boolean getNoSaveDebug() {
        return this._NoSaveDebug;
    }

    public boolean getSafeMode() {
        return this._SafeMode;
    }

    public boolean getNonNumeric() {
        return this._NonNumeric;
    }

    public boolean getExtendedError() {
        return this._ExtendedError;
    }

    public boolean getDumpMem() {
        return this._DumpMem;
    }

    public boolean getThrowErrors() {
        return this._ThrowErrors;
    }

    public boolean getCharToGui() {
        return this._CharToGui;
    }

    public boolean getZipErrorFile() {
        return this._ZipErrorFile;
    }

    public boolean getLinkageLength() {
        return this._LinkageLength;
    }

    public void setLastErrorMsg(String string) {
        this._LastErrorMsg = string;
    }

    public void setRunPath(String string) {
        this.cblLog(Level.WARNING, " setRunPath: command option -runpath not supported ");
    }

    public void setSwitches(String string) {
        this._Switches = string;
    }

    public void setConfigFile(String string) {
        this._ConfigFile = string;
    }

    public void setErrorsOut(String string) {
        this._ErrorsOut = string;
    }

    public void setErrorsAppend(String string) {
        this._ErrorsAppend = string;
    }

    public void setKeyFile(String string) {
        this._KeyFile = string;
    }

    public void setImport(String string) {
        this._Import = string;
    }

    public void setPlays(String string) {
        this._Plays = string;
    }

    public void setDisplayOut(String string) {
        this._DisplayOut = string;
    }

    public void setDisplayAppend(String string) {
        this._DisplayAppend = string;
    }

    public void setDebugCmds(String string) {
        this._DebugCmds = string;
    }

    public void setTerminalOut(String string) {
        this._TerminalOut = string;
    }

    public void setObjLib(String string) {
        this._ObjLib = string;
    }

    public void setEmbeddedLib(String string) {
        this._EmbeddedLib = string;
    }

    public void setTerminalInit(boolean bl) {
        this._TerminalInit = bl;
    }

    public void setCGIWarnings(boolean bl) {
        this._CGIWarnings = bl;
    }

    public void setIgnoreSignals(boolean bl) {
        this._IgnoreSignals = bl;
    }

    public void setListConfig(boolean bl) {
        this._ListConfig = bl;
    }

    public void setNoSaveDebug(boolean bl) {
        this._NoSaveDebug = bl;
    }

    public void setSafeMode(boolean bl) {
        this._SafeMode = bl;
    }

    public void setNonNumeric(boolean bl) {
        this._NonNumeric = bl;
    }

    public void setExtendedError(boolean bl) {
        this._ExtendedError = bl;
    }

    public void setDumpMem(boolean bl) {
        this._DumpMem = bl;
    }

    public void setThrowErrors(boolean bl) {
        this._ThrowErrors = bl;
    }

    public void setCharToGui(boolean bl) {
        this._CharToGui = bl;
    }

    public void setZipErrorFile(boolean bl) {
        this._ZipErrorFile = bl;
    }

    public void setLinkageLength(boolean bl) {
        this._LinkageLength = bl;
    }
}

