/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.smime;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.smime.SMimeBodyPart;
import iaik.security.smime.SMimeMultipart;
import iaik.security.smime.SMimeParameters;
import iaik.security.smime.SMimeSigned;
import iaik.security.smime.a;
import iaik.security.smime.c;
import iaik.security.smime.d;
import iaik.utils.Base64InputStream;
import iaik.utils.Base64OutputStream;
import iaik.utils.InitBufferedInputStream;
import iaik.utils.InternalErrorException;
import iaik.utils.LineInputStream;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class SignedContent
extends MimeMultipart {
    MimeMessage h;
    private static final boolean g = false;
    public static final String CERTS_ONLY = "certs-only";
    public static final String SIGNED_DATA = "signed-data";
    String a;
    boolean d = false;
    boolean c;
    X509CRL[] i;
    X509Certificate[] f;
    DataHandler e;
    SMimeSigned b;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeTo(OutputStream outputStream) throws MessagingException, IOException {
        if (this.c) {
            if (this.a == CERTS_ONLY) {
                if (this.f == null) {
                    throw new IOException("No certificates are specified for certs-only message!");
                }
                this.b = new SMimeSigned(null, 1);
                this.b.setCertificates(this.f);
            } else {
                Object object;
                String string = "Content-type: " + this.e.getContentType();
                String string2 = null;
                if (this.e.getContentType().startsWith("multipart")) {
                    object = this.e.getContent();
                    if (!(object instanceof SMimeMultipart)) throw new MessagingException("Please use SMimeMultipart instead of MimeMultipart!");
                    ((SMimeMultipart)((Object)object)).updateHeaders();
                } else {
                    string2 = "Content-Transfer-Encoding: " + MimeUtility.getEncoding((DataSource)this.e.getDataSource());
                }
                object = new byte[]{13, 10};
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(string.getBytes());
                byteArrayOutputStream.write((byte[])object);
                if (string2 != null) {
                    byteArrayOutputStream.write(string2.getBytes());
                    byteArrayOutputStream.write((byte[])object);
                }
                byteArrayOutputStream.write((byte[])object);
                InitBufferedInputStream initBufferedInputStream = new InitBufferedInputStream(this.e.getInputStream(), byteArrayOutputStream.toByteArray());
                this.b.setInputStream((InputStream)initBufferedInputStream);
            }
            if (this.d) {
                this.b.writeTo((OutputStream)new Base64OutputStream(outputStream));
                return;
            }
            this.b.writeTo(outputStream);
            return;
        }
        this.updateHeaders();
        super.writeTo(outputStream);
    }

    public void verify(PublicKey publicKey) throws SignatureException {
        if (this.a.equals(CERTS_ONLY)) {
            throw new SignatureException("S/MIME message contains only certificates!");
        }
        this.b.verify(publicKey);
    }

    public X509Certificate verify() throws SignatureException {
        if (this.a.equals(CERTS_ONLY)) {
            throw new SignatureException("S/MIME message contains only certificates!");
        }
        return this.b.verify();
    }

    public void setText(String string) {
        this.setDataHandler(new DataHandler((Object)string, "text/plain"));
    }

    public void setSigner(RSAPrivateKey rSAPrivateKey, X509Certificate x509Certificate) throws SignatureException, InvalidKeyException {
        try {
            if (this.c) {
                this.b = new SMimeSigned(null, 1);
            } else {
                SMimeBodyPart sMimeBodyPart;
                this.b = new SMimeSigned(null, 2);
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                ContentType contentType = new ContentType(SMimeParameters.a);
                contentType.setParameter("name", "smime.p7s");
                mimeBodyPart.setDisposition("attachment");
                mimeBodyPart.setFileName("smime.p7s");
                mimeBodyPart.setContent((Object)this.b, contentType.toString());
                this.b.c = sMimeBodyPart = new SMimeBodyPart(this.e, this.b);
                this.addBodyPart((BodyPart)sMimeBodyPart, 0);
                this.addBodyPart((BodyPart)mimeBodyPart, 1);
            }
            this.b.setCertificates(this.f);
            this.b.setCRLs(this.i);
            this.b.addSigner(rSAPrivateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException.toString());
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.toString());
        }
        catch (MessagingException messagingException) {
            throw new SignatureException(messagingException.toString());
        }
    }

    public void setHeaders(Message message) {
        try {
            if (this.c) {
                message.setDisposition("attachment");
                if (this.a == CERTS_ONLY) {
                    message.setFileName("smime.p7c");
                    return;
                }
                message.setFileName("smime.p7m");
                return;
            }
        }
        catch (MessagingException messagingException) {
            throw new InternalErrorException((Exception)((Object)messagingException));
        }
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.e = dataHandler;
    }

    public void setContent(Multipart multipart) {
        this.setDataHandler(new DataHandler((Object)multipart, multipart.getContentType()));
    }

    public void setContent(Object object, String string) {
        this.setDataHandler(new DataHandler(object, string));
    }

    public void setCertificates(X509Certificate[] x509CertificateArray) {
        this.f = x509CertificateArray;
    }

    public void setCertificates(X509CRL[] x509CRLArray) {
        this.i = x509CRLArray;
    }

    public SignerInfo[] getSignerInfos() {
        return this.b.getSignerInfos();
    }

    public String getSMimeType() {
        return this.a;
    }

    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.e == null) {
            MimeMessage mimeMessage = new MimeMessage(null, this.b.getInputStream());
            this.e = mimeMessage.getDataHandler();
        }
        return this.e;
    }

    public InputStream getContentInputStream() throws IOException {
        try {
            if (this.e == null) {
                this.e = this.getDataHandler();
            }
            if (this.h == null) {
                throw new IOException("No message to read!");
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            d d2 = new d(this.h, pipedOutputStream);
            d2.start();
            return pipedInputStream;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public Object getContent() throws MessagingException, IOException {
        return this.getDataHandler().getContent();
    }

    public X509Certificate[] getCertificates() {
        return this.b.getCertificates();
    }

    public X509CRL[] getCRLs() {
        return this.b.getCRLs();
    }

    public SignedContent(boolean bl, String string) {
        super("signed");
        this.c = bl;
        if (bl) {
            ContentType contentType = new ContentType("application", SMimeParameters.b, null);
            contentType.setParameter("name", "smime.p7m");
            if (string != null) {
                this.a = string.trim();
                if (this.a.length() > 0) {
                    contentType.setParameter("smime-type", this.a);
                    if (this.a == CERTS_ONLY) {
                        contentType.setParameter("name", "smime.p7c");
                    }
                }
            }
            ((Multipart)this).contentType = contentType.toString();
            return;
        }
        try {
            ContentType contentType = new ContentType(((Multipart)this).contentType);
            contentType.setParameter("protocol", SMimeParameters.a);
            contentType.setParameter("micalg", "SHA-1");
            ((Multipart)this).contentType = contentType.toString();
            return;
        }
        catch (ParseException parseException) {
            throw new InternalErrorException((Exception)((Object)parseException));
        }
    }

    public SignedContent(boolean bl) {
        this(bl, null);
    }

    public SignedContent(DataSource dataSource) throws IOException {
        try {
            ContentType contentType = new ContentType(dataSource.getContentType());
            ((Multipart)this).contentType = contentType.toString();
            this.a = contentType.getParameter("smime-type");
            if (this.a == null) {
                this.a = SIGNED_DATA;
            }
            if (contentType.match("multipart/signed")) {
                String string;
                String string2 = contentType.getParameter("boundary");
                String string3 = contentType.getParameter("micalg");
                AlgorithmID algorithmID = null;
                if (string3.equalsIgnoreCase("SHA") || string3.equalsIgnoreCase("SHA-1") || string3.equalsIgnoreCase("SHA1") || string3.equalsIgnoreCase("RSA-SHA1")) {
                    algorithmID = AlgorithmID.sha1;
                } else if (string3.equalsIgnoreCase("MD5") || string3.equalsIgnoreCase("RSA-MD5")) {
                    algorithmID = AlgorithmID.md5;
                } else {
                    throw new IOException("Unknown MIC algorithm: " + string3);
                }
                LineInputStream lineInputStream = new LineInputStream(dataSource.getInputStream());
                iaik.security.smime.a.skipToNextBoundary(lineInputStream, string2);
                this.b = new SMimeSigned((InputStream)new c(lineInputStream, string2), new AlgorithmID[]{algorithmID});
                this.h = new MimeMessage(null, this.b.getInputStream());
                this.e = this.h.getDataHandler();
                this.d = false;
                boolean bl = true;
                do {
                    String string4;
                    if ((string4 = (string = lineInputStream.readLine()).toLowerCase()).indexOf("content-transfer-encoding") == -1 || string4.indexOf("binary") == -1 && string4.indexOf("binary") == -1) continue;
                    bl = false;
                } while (string.length() > 0);
                if (bl) {
                    this.b.decode((InputStream)new Base64InputStream((InputStream)lineInputStream));
                    return;
                }
                this.b.decode((InputStream)lineInputStream);
                return;
            }
            if (contentType.match("application/x-pkcs7-mime") || contentType.match("application/pkcs7-mime")) {
                this.b = new SMimeSigned(dataSource.getInputStream());
                if (this.a.equals(CERTS_ONLY)) {
                    this.e = null;
                } else {
                    this.h = new MimeMessage(null, this.b.getInputStream());
                    this.e = this.h.getDataHandler();
                }
                this.d = true;
                return;
            }
            throw new IOException("Unknown mime type: " + ((Multipart)this).contentType);
        }
        catch (MessagingException messagingException) {
            throw new IOException("Error reading message content.");
        }
    }
}

