/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.smime;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.security.random.SecRandom;
import iaik.security.smime.SMimeException;
import iaik.utils.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class SMimeEncrypted
extends EnvelopedDataStream {
    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo((ASN1Object)new ContentInfoStream((ContentStream)this).toASN1Object(), (OutputStream)outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public byte[] toByteArray() throws SMimeException {
        try {
            return DerCoder.encode((ASN1Object)new ContentInfoStream((ContentStream)this).toASN1Object());
        }
        catch (PKCSException pKCSException) {
            throw new SMimeException(pKCSException.toString());
        }
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(2048);
    }

    private void a(AlgorithmID algorithmID, int n) throws NoSuchAlgorithmException {
        SEQUENCE sEQUENCE;
        AlgorithmParameterSpec algorithmParameterSpec = null;
        SecureRandom secureRandom = SecRandom.getDefault();
        String string = algorithmID.getImplementationName();
        int n2 = string.indexOf(47);
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string.substring(0, n2));
        int n3 = 58;
        if (algorithmID.equals((Object)AlgorithmID.rc2_CBC)) {
            switch (n) {
                case 40: {
                    n3 = 160;
                    break;
                }
                case 64: {
                    n3 = 120;
                    break;
                }
                default: {
                    n3 = 58;
                    n = 128;
                }
            }
        }
        keyGenerator.init(n);
        this.symmetric_key = keyGenerator.generateKey();
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        if (algorithmID.equals((Object)AlgorithmID.rc2_CBC)) {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new INTEGER(n3));
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray));
            algorithmID.setParameter((ASN1Object)sEQUENCE);
            algorithmParameterSpec = new RC2ParameterSpec(n, byArray);
        } else if (algorithmID.equals((Object)AlgorithmID.des_EDE3_CBC) || algorithmID.equals((Object)AlgorithmID.des_CBC)) {
            sEQUENCE = new OCTET_STRING(byArray);
            algorithmID.setParameter((ASN1Object)sEQUENCE);
            algorithmParameterSpec = new IvParameterSpec(byArray);
        } else {
            throw new NoSuchAlgorithmException("No implementation for: " + algorithmID.getName());
        }
        try {
            this.encrypted_content_info.setupCipher(algorithmID, (Key)this.symmetric_key, algorithmParameterSpec);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalErrorException((Exception)invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException((Exception)invalidAlgorithmParameterException);
        }
    }

    public AlgorithmID getEncryptionAlgorithm() {
        return this.encrypted_content_info.getContentEncryptionAlgorithm();
    }

    public int decryptSymmetricKey(PrivateKey privateKey, int n) throws InvalidKeyException, SMimeException {
        try {
            SecretKey secretKey = ((RecipientInfo)this.recipient_infos.elementAt(n)).decryptKey(privateKey);
            AlgorithmID algorithmID = this.encrypted_content_info.getContentEncryptionAlgorithm();
            AlgorithmParameterSpec algorithmParameterSpec = null;
            int n2 = 0;
            if (algorithmID.equals((Object)AlgorithmID.rc2_CBC)) {
                n2 = secretKey.getEncoded().length * 8;
                int n3 = 32;
                ASN1Object aSN1Object = algorithmID.getParameter();
                try {
                    int n4 = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
                    switch (n4) {
                        case 160: {
                            n3 = 40;
                            break;
                        }
                        case 120: {
                            n3 = 64;
                            break;
                        }
                        case 58: {
                            n3 = 128;
                            break;
                        }
                        default: {
                            throw new SMimeException("Invalid rc2ParameterVersion " + n4 + " for S/Mime!");
                        }
                    }
                    algorithmParameterSpec = new RC2ParameterSpec(n3, (byte[])aSN1Object.getComponentAt(1).getValue());
                }
                catch (CodingException codingException) {
                    throw new SMimeException("Unable to parse algorithm parameters!");
                }
            } else if (algorithmID.equals((Object)AlgorithmID.des_EDE3_CBC)) {
                ASN1Object aSN1Object = algorithmID.getParameter();
                algorithmParameterSpec = new IvParameterSpec((byte[])aSN1Object.getValue());
                n2 = 168;
            } else if (algorithmID.equals((Object)AlgorithmID.des_CBC)) {
                ASN1Object aSN1Object = algorithmID.getParameter();
                algorithmParameterSpec = new IvParameterSpec((byte[])aSN1Object.getValue());
                n2 = 56;
            } else {
                throw new SMimeException("Unknown encryption algorithm: " + algorithmID.getName());
            }
            this.encrypted_content_info.setupCipher((Key)secretKey, algorithmParameterSpec);
            return n2;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new SMimeException("Unable to decrypt symmetric key.");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        DerInputStream derInputStream;
        ObjectID objectID;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if (!(objectID = (derInputStream = ((DerInputStream)inputStream).readSequence()).readObjectID()).equals((Object)ObjectID.pkcs7_envelopedData)) {
            throw new IOException("Content type not EnvelopedData!");
        }
        DerInputStream derInputStream2 = derInputStream.readContextSpecific();
        try {
            super.decode((InputStream)derInputStream2);
            return;
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new IOException("Error parsing enveloped data!");
        }
    }

    public void addRecipient(X509Certificate x509Certificate, AlgorithmID algorithmID) throws NoSuchAlgorithmException, SMimeException {
        RecipientInfo recipientInfo = new RecipientInfo(x509Certificate, algorithmID);
        try {
            recipientInfo.encryptKey(this.symmetric_key);
        }
        catch (PKCSException pKCSException) {
            throw new SMimeException("Error encrypting symmetric key!");
        }
        this.addRecipientInfo(recipientInfo);
    }

    public SMimeEncrypted(byte[] byArray, AlgorithmID algorithmID, int n) throws NoSuchAlgorithmException {
        this(new ByteArrayInputStream(byArray), algorithmID, n);
    }

    public SMimeEncrypted(InputStream inputStream, AlgorithmID algorithmID, int n) throws NoSuchAlgorithmException {
        this.encrypted_content_info = new EncryptedContentInfoStream(ObjectID.pkcs7_data, inputStream);
        this.a(algorithmID, n);
    }

    public SMimeEncrypted(InputStream inputStream) throws IOException {
        this.decode(inputStream);
    }
}

