/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.keystore.IaikKeyStore;
import demo.smime.SMimeStream$Writer;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.security.provider.IAIK;
import iaik.security.smime.SMimeEncrypted;
import iaik.security.smime.SMimeSigned;
import iaik.utils.CryptoUtils;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.PrivateKey;
import java.util.Random;

public class SMimeStream {
    static final int BUF_SIZE = 10000;
    byte[] buffer = new byte[10000];
    X509Certificate[] certificates;
    X509Certificate[] recipientCertificates;
    PrivateKey[] recipientPrivateKeys;
    X509Certificate signerCertificate;
    PrivateKey signerPrivateKey;

    public void testSMimeSignedAndEncrypted() throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.buffer));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        SMimeSigned sMimeSigned = new SMimeSigned((InputStream)bufferedInputStream, 1);
        sMimeSigned.setCertificates(this.certificates);
        sMimeSigned.addSigner(this.signerPrivateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)this.signerCertificate));
        SMimeStream$Writer sMimeStream$Writer = new SMimeStream$Writer(this, sMimeSigned, pipedOutputStream);
        sMimeStream$Writer.start();
        SMimeEncrypted sMimeEncrypted = new SMimeEncrypted(pipedInputStream, AlgorithmID.des_CBC, -1);
        sMimeEncrypted.addRecipient((java.security.cert.X509Certificate)this.recipientCertificates[0], AlgorithmID.rsaEncryption);
        sMimeEncrypted.addRecipient((java.security.cert.X509Certificate)this.recipientCertificates[1], AlgorithmID.rsaEncryption);
        sMimeEncrypted.writeTo(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        sMimeEncrypted = new SMimeEncrypted(bufferedInputStream);
        sMimeEncrypted.decryptSymmetricKey(this.recipientPrivateKeys[1], 1);
        InputStream inputStream = sMimeEncrypted.getInputStream();
        sMimeSigned = new SMimeSigned(inputStream);
        InputStream inputStream2 = sMimeSigned.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        StreamCopier streamCopier = new StreamCopier(inputStream2, (OutputStream)bufferedOutputStream);
        streamCopier.copyStream();
        ((OutputStream)bufferedOutputStream).close();
        X509Certificate x509Certificate = sMimeSigned.verify();
        System.out.println("Signature OK from: " + x509Certificate.getSubjectDN());
        if (!CryptoUtils.equalsBlock((byte[])this.buffer, (byte[])byteArrayOutputStream.toByteArray())) {
            throw new RuntimeException("Error: messages are not equal!");
        }
    }

    public void testSMimeSigned(int n) throws Exception {
        StreamCopier streamCopier;
        BufferedOutputStream bufferedOutputStream;
        Closeable closeable;
        byte[] byArray = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.buffer));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(byteArrayOutputStream);
        SMimeSigned sMimeSigned = new SMimeSigned((InputStream)bufferedInputStream, n);
        sMimeSigned.setCertificates(this.certificates);
        sMimeSigned.addSigner(this.signerPrivateKey, new IssuerAndSerialNumber((java.security.cert.X509Certificate)this.signerCertificate));
        if (n == 2) {
            closeable = new ByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream((OutputStream)closeable);
            streamCopier = new StreamCopier(sMimeSigned.getInputStream(), (OutputStream)bufferedOutputStream);
            streamCopier.copyStream();
            ((OutputStream)bufferedOutputStream).close();
            byArray = closeable.toByteArray();
        }
        sMimeSigned.writeTo(bufferedOutputStream2);
        ((OutputStream)bufferedOutputStream2).close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray2));
        sMimeSigned = n == 1 ? new SMimeSigned(bufferedInputStream) : new SMimeSigned((InputStream)new BufferedInputStream(new ByteArrayInputStream(byArray)), new AlgorithmID[]{AlgorithmID.sha1});
        closeable = sMimeSigned.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream2 = new BufferedOutputStream(byteArrayOutputStream);
        bufferedOutputStream = new StreamCopier((InputStream)closeable, (OutputStream)bufferedOutputStream2);
        bufferedOutputStream.copyStream();
        ((OutputStream)bufferedOutputStream2).close();
        if (n == 2) {
            sMimeSigned.decode(bufferedInputStream);
        }
        streamCopier = sMimeSigned.verify();
        System.out.println("Signature OK from: " + streamCopier.getSubjectDN());
        if (!CryptoUtils.equalsBlock((byte[])this.buffer, (byte[])byteArrayOutputStream.toByteArray())) {
            throw new RuntimeException("Error: messages are not equal!");
        }
    }

    public void testSMimeEncrypted() throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.buffer));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        SMimeEncrypted sMimeEncrypted = new SMimeEncrypted(bufferedInputStream, AlgorithmID.des_CBC, -1);
        sMimeEncrypted.addRecipient((java.security.cert.X509Certificate)this.recipientCertificates[0], AlgorithmID.rsaEncryption);
        sMimeEncrypted.addRecipient((java.security.cert.X509Certificate)this.recipientCertificates[1], AlgorithmID.rsaEncryption);
        sMimeEncrypted.writeTo(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        sMimeEncrypted = new SMimeEncrypted(bufferedInputStream);
        sMimeEncrypted.decryptSymmetricKey(this.recipientPrivateKeys[0], 0);
        InputStream inputStream = sMimeEncrypted.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)bufferedOutputStream);
        streamCopier.copyStream();
        ((OutputStream)bufferedOutputStream).close();
        if (!CryptoUtils.equalsBlock((byte[])this.buffer, (byte[])byteArrayOutputStream.toByteArray())) {
            throw new RuntimeException("Error: messages are not equal!");
        }
    }

    public void start() {
        try {
            this.setupCertificates();
            System.out.println("testing an implicit S/MIME signed message...");
            this.testSMimeSigned(1);
            System.out.println("testing an explicit S/MIME signed message...");
            this.testSMimeSigned(2);
            System.out.println("testing a S/MIME encrypted message...");
            this.testSMimeEncrypted();
            System.out.println("testing a S/MIME encrypted and signed message...");
            this.testSMimeSignedAndEncrypted();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void setupCertificates() throws Exception {
        this.certificates = IaikKeyStore.getCertificateChain((int)0, (int)1);
        this.signerPrivateKey = IaikKeyStore.getPrivateKey((int)0, (int)1);
        this.signerCertificate = this.certificates[0];
        this.recipientPrivateKeys = new PrivateKey[2];
        this.recipientPrivateKeys[0] = IaikKeyStore.getPrivateKey((int)0, (int)0);
        this.recipientPrivateKeys[1] = IaikKeyStore.getPrivateKey((int)0, (int)2);
        this.recipientCertificates = new X509Certificate[2];
        this.recipientCertificates[0] = IaikKeyStore.getCertificateChain((int)0, (int)0)[0];
        this.recipientCertificates[1] = IaikKeyStore.getCertificateChain((int)0, (int)2)[0];
    }

    public static void main(String[] stringArray) throws IOException {
        IAIK.addAsProvider((boolean)true);
        new SMimeStream().start();
        System.out.println("ready...");
        System.in.read();
    }

    public SMimeStream() {
        Random random = new Random();
        random.nextBytes(this.buffer);
    }
}

