/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.keystore.IaikKeyStore;
import iaik.security.provider.IAIK;
import iaik.security.smime.EncryptedContent;
import iaik.security.smime.SignedContent;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class SMimeShow {
    PrivateKey privateKey = IaikKeyStore.getPrivateKey((int)0, (int)1);
    boolean verbose = false;
    String url;
    String mbox = "INBOX";
    String password;
    String user;
    String host;
    String protocol;
    String from;

    public void start() throws IOException {
        this.show(new String[0]);
    }

    public void show(String[] stringArray) throws IOException {
        int n = -1;
        int n2 = 0;
        if (stringArray.length > 0) {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-T")) {
                    this.protocol = stringArray[++n2];
                } else if (stringArray[n2].equals("-H")) {
                    this.host = stringArray[++n2];
                } else if (stringArray[n2].equals("-U")) {
                    this.user = stringArray[++n2];
                } else if (stringArray[n2].equals("-P")) {
                    this.password = stringArray[++n2];
                } else if (stringArray[n2].equals("-v")) {
                    this.verbose = true;
                } else if (stringArray[n2].equals("-f")) {
                    this.mbox = stringArray[++n2];
                } else if (stringArray[n2].equals("-L")) {
                    this.url = stringArray[++n2];
                } else {
                    if (stringArray[n2].equals("--")) {
                        ++n2;
                        break;
                    }
                    if (!stringArray[n2].startsWith("-")) break;
                    System.out.println("Usage: SMimeShow [-L url] [-T protocol] [-H host] [-U user] [-P password] [-f mailbox] [msgnum] [-v]");
                    System.exit(1);
                }
                ++n2;
            }
        } else {
            this.protocol = "pop3";
            this.host = "mailhost";
            this.user = "smimetest";
            this.password = "citengis";
            this.verbose = true;
        }
        try {
            URLName uRLName;
            if (n2 < stringArray.length) {
                n = Integer.parseInt(stringArray[n2]);
            }
            Properties properties = System.getProperties();
            Session session = Session.getDefaultInstance((Properties)properties, null);
            Store store = null;
            if (this.url != null) {
                uRLName = new URLName(this.url);
                store = session.getStore(uRLName);
                store.connect();
            } else {
                store = this.protocol != null ? session.getStore(this.protocol) : session.getStore();
                if (this.host != null || this.user != null || this.password != null) {
                    store.connect(this.host, this.user, this.password);
                } else {
                    store.connect();
                }
            }
            uRLName = store.getDefaultFolder();
            if (uRLName == null) {
                System.out.println("No default folder");
                System.exit(1);
            }
            if ((uRLName = uRLName.getFolder(this.mbox)) == null) {
                System.out.println("Invalid folder");
                System.exit(1);
            }
            uRLName.open(1);
            int n3 = uRLName.getMessageCount();
            if (n3 == 0) {
                System.out.println("Empty folder");
                uRLName.close(false);
                store.close();
                System.exit(1);
            }
            if (this.verbose) {
                int n4 = uRLName.getNewMessageCount();
                System.out.println("Total messages = " + n3);
                System.out.println("New messages = " + n4);
                System.out.println("-------------------------------");
            }
            if (n == -1) {
                Message[] messageArray = uRLName.getMessages();
                FetchProfile fetchProfile = new FetchProfile();
                fetchProfile.add(FetchProfile.Item.ENVELOPE);
                fetchProfile.add(FetchProfile.Item.FLAGS);
                fetchProfile.add("X-Mailer");
                uRLName.fetch(messageArray, fetchProfile);
                int n5 = 0;
                while (n5 < messageArray.length) {
                    System.out.println("--------------------------");
                    System.out.println("MESSAGE #" + (n5 + 1) + ":");
                    this.dump(messageArray[n5]);
                    ++n5;
                }
            } else {
                System.out.println("Getting message number: " + n);
                Message message = uRLName.getMessage(n);
                this.from = message.getFrom()[0].toString();
                this.dump(message);
            }
            uRLName.close(false);
            store.close();
        }
        catch (Exception exception) {
            System.out.println("Oops, got exception! " + exception.getMessage());
            exception.printStackTrace();
        }
        System.out.println("Ready! Press the space bar...");
        System.in.read();
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        IAIK.addAsProvider((boolean)true);
        new SMimeShow().show(stringArray);
        System.out.println("Ready!");
    }

    public static void dumpEnvelope(Message message) throws MessagingException {
        Object object;
        int n;
        System.out.println("This is the message envelope");
        System.out.println("---------------------------");
        Address[] addressArray = message.getFrom();
        if (addressArray != null) {
            n = 0;
            while (n < addressArray.length) {
                System.out.println("FROM: " + addressArray[n].toString());
                ++n;
            }
        }
        if ((addressArray = message.getRecipients(Message.RecipientType.TO)) != null) {
            n = 0;
            while (n < addressArray.length) {
                System.out.println("TO: " + addressArray[n].toString());
                ++n;
            }
        }
        System.out.println("SUBJECT: " + message.getSubject());
        Date date = message.getSentDate();
        System.out.println("SendDate: " + (date != null ? date.toString() : "UNKNOWN"));
        System.out.println("Size: " + message.getSize());
        Flags flags = message.getFlags();
        StringBuffer stringBuffer = new StringBuffer();
        Flags.Flag[] flagArray = flags.getSystemFlags();
        boolean bl = true;
        int n2 = 0;
        while (n2 < flagArray.length) {
            block20: {
                block15: {
                    Flags.Flag flag;
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        flag = flagArray[n2];
                                        if (flag != Flags.Flag.ANSWERED) break block14;
                                        object = "\\Answered";
                                        break block15;
                                    }
                                    if (flag != Flags.Flag.DELETED) break block16;
                                    object = "\\Deleted";
                                    break block15;
                                }
                                if (flag != Flags.Flag.DRAFT) break block17;
                                object = "\\Draft";
                                break block15;
                            }
                            if (flag != Flags.Flag.FLAGGED) break block18;
                            object = "\\Flagged";
                            break block15;
                        }
                        if (flag != Flags.Flag.RECENT) break block19;
                        object = "\\Recent";
                        break block15;
                    }
                    if (flag != Flags.Flag.SEEN) break block20;
                    object = "\\Seen";
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(' ');
                }
                stringBuffer.append((String)object);
            }
            ++n2;
        }
        object = flags.getUserFlags();
        int n3 = 0;
        while (n3 < ((String[])object).length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(object[n3]);
            ++n3;
        }
        System.out.println("FLAGS = " + stringBuffer.toString());
        String[] stringArray = message.getHeader("X-Mailer");
        if (stringArray != null) {
            System.out.println("X-Mailer: " + stringArray[0]);
            return;
        }
        System.out.println("X-Mailer NOT available");
    }

    public void dump(Object object) throws Exception {
        if (object instanceof Message) {
            SMimeShow.dumpEnvelope((Message)object);
        }
        if (object instanceof Part) {
            System.out.println("CONTENT-TYPE: " + ((Part)object).getContentType());
            object = ((Part)object).getContent();
        }
        if (object instanceof EncryptedContent) {
            System.out.println("This message is encrypted!");
            EncryptedContent encryptedContent = (EncryptedContent)object;
            encryptedContent.decryptSymmetricKey(this.privateKey, 0);
            this.dump(encryptedContent.getContent());
            return;
        }
        if (object instanceof SignedContent) {
            System.out.println("This message is signed!");
            SignedContent signedContent = (SignedContent)((Object)object);
            if (signedContent.getSMimeType().equals("certs-only")) {
                System.out.println("This message contains only certificates!");
                X509Certificate[] x509CertificateArray = signedContent.getCertificates();
                int n = 0;
                while (n < x509CertificateArray.length) {
                    System.out.println(x509CertificateArray[n].toString(true));
                    ++n;
                }
                return;
            }
            try {
                X509Certificate x509Certificate = signedContent.verify();
                System.out.println("This message is signed from: " + x509Certificate.getSubjectDN());
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature verification error!");
            }
            this.dump(signedContent.getContent());
            return;
        }
        if (object instanceof String) {
            System.out.println("Content is a String");
            System.out.println("---------------------------");
            System.out.println((String)object);
            return;
        }
        if (object instanceof Multipart) {
            System.out.println("----------------> Content is a Multipart");
            Multipart multipart = (Multipart)object;
            int n = multipart.getCount();
            int n2 = 0;
            while (n2 < n) {
                System.out.println("----------------> Multipart: " + (n2 + 1));
                this.dump(multipart.getBodyPart(n2));
                ++n2;
            }
            System.out.println("----------------> End of Multipart");
            return;
        }
        if (object instanceof Message) {
            System.out.println("Content is a Nested Message");
            System.out.println("---------------------------");
            this.dump(object);
            return;
        }
        if (object instanceof InputStream) {
            int n;
            System.out.println("Content is just an input stream: " + object);
            System.out.println("---------------------------");
            InputStream inputStream = (InputStream)object;
            int n3 = 0;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                n3 += n;
            }
            System.out.println("Length of data: " + n3 + " bytes");
        }
    }
}

