/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.keystore.IaikKeyStore;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.provider.IAIK;
import iaik.security.smime.EncryptedContent;
import iaik.security.smime.SMimeMultipart;
import iaik.security.smime.SMimeParameters;
import iaik.security.smime.SignedContent;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SMimeSend {
    PrivateKey signerPrivateKey;
    X509Certificate signerCertificate;
    X509Certificate recipientCertificate;
    X509Certificate[] certificates = IaikKeyStore.getCertificateChain((int)0, (int)1);
    String host = "mailhost";
    String from = "smimetest@iaik.tu-graz.ac.at";
    String to = "smimetest@iaik.tu-graz.ac.at";

    public void start() throws IOException {
        block2: {
            Properties properties = new Properties();
            ((Hashtable)properties).put("mail.smtp.host", this.host);
            Session session = Session.getDefaultInstance((Properties)properties, null);
            try {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText("This is a Test of the IAIK S/MIME implementation!\n\n");
                MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
                URL uRL = new URL("http://www.iaik.tu-graz.ac.at/");
                mimeBodyPart2.setDataHandler(new DataHandler((DataSource)new URLDataSource(uRL)));
                mimeBodyPart2.setFileName("index.html");
                SMimeMultipart sMimeMultipart = new SMimeMultipart();
                sMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                sMimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
                DataHandler dataHandler = new DataHandler((Object)sMimeMultipart, sMimeMultipart.getContentType());
                Message message = this.createPlainMessage(session, dataHandler);
                System.out.println("sending plain message...");
                Transport.send((Message)message);
                message = this.createSignedMessage(session, dataHandler, false);
                System.out.println("sending explicitly signed message...");
                Transport.send((Message)message);
                message = this.createSignedMessage(session, dataHandler, true);
                System.out.println("sending implicitly signed message...");
                Transport.send((Message)message);
                message = this.createEncryptedMessage(session, AlgorithmID.rc2_CBC, 40);
                System.out.println("sending encrypted message [RC2/40]...");
                Transport.send((Message)message);
                message = this.createEncryptedMessage(session, AlgorithmID.rc2_CBC, 64);
                System.out.println("sending encrypted message [RC2/64]...");
                Transport.send((Message)message);
                message = this.createEncryptedMessage(session, AlgorithmID.rc2_CBC, 128);
                System.out.println("sending encrypted message [RC2/128]...");
                Transport.send((Message)message);
                message = this.createEncryptedMessage(session, AlgorithmID.des_CBC, 0);
                System.out.println("sending encrypted message [DES]...");
                Transport.send((Message)message);
                message = this.createEncryptedMessage(session, AlgorithmID.des_EDE3_CBC, 0);
                System.out.println("sending encrypted message [TripleDES]...");
                Transport.send((Message)message);
                message = this.createSignedAndEncryptedMessage(session, dataHandler, true);
                System.out.println("sending implicitly signed and encrypted message [RC2/40]...");
                Transport.send((Message)message);
                message = this.createSignedAndEncryptedMessage(session, dataHandler, false);
                System.out.println("sending explicitly signed and encrypted message [RC2/40]...");
                Transport.send((Message)message);
                message = this.createCertsOnlyMessage(session);
                System.out.println("sending certs-only message");
                Transport.send((Message)message);
                message = this.createCertsOnlyMultiPartMessage(session);
                System.out.println("sending message with certs-only part");
                Transport.send((Message)message);
            }
            catch (MessagingException messagingException) {
                messagingException.printStackTrace();
                Exception exception = null;
                exception = messagingException.getNextException();
                if (exception == null) break block2;
                exception.printStackTrace();
            }
        }
        System.out.println("OK!");
        System.in.read();
    }

    public static void main(String[] stringArray) throws IOException {
        IAIK.addAsProvider((boolean)true);
        new SMimeSend().start();
        System.exit(0);
    }

    public Message createSignedMessage(Session session, DataHandler dataHandler, boolean bl) throws MessagingException {
        Message message = this.createMessage(session);
        SignedContent signedContent = new SignedContent(bl);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            message.setSubject("IAIK-S/MIME: Implicitly Signed");
            stringBuffer.append("TEST");
        } else {
            message.setSubject("IAIK-S/MIME: Explicitly Signed");
            stringBuffer.append("This message is explicitly signed!\n");
            stringBuffer.append("Every mail client can view this message.\n");
            stringBuffer.append("Non S/MIME mail clients will show the signature as attachment.\n");
            stringBuffer.append("\n\n");
        }
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(stringBuffer.toString());
        }
        signedContent.setCertificates(this.certificates);
        try {
            signedContent.setSigner((RSAPrivateKey)this.signerPrivateKey, this.signerCertificate);
        }
        catch (SignatureException signatureException) {
            throw new MessagingException("Error signing content!", (Exception)signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new MessagingException("Invalid Key!", (Exception)invalidKeyException);
        }
        message.setContent((Object)signedContent, signedContent.getContentType());
        return message;
    }

    public Message createSignedAndEncryptedMessage(Session session, DataHandler dataHandler, boolean bl) throws MessagingException {
        Message message = this.createMessage(session);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            message.setSubject("IAIK-S/MIME: Implicitly Signed and Encrypted");
            stringBuffer.append("TEST");
        } else {
            message.setSubject("IAIK-S/MIME: Explicitly Signed and Encrypted");
            stringBuffer.append("This message is explicitly signed and encrypted!\n");
            stringBuffer.append("\n\n");
        }
        SignedContent signedContent = new SignedContent(bl);
        if (dataHandler != null) {
            signedContent.setDataHandler(dataHandler);
        } else {
            signedContent.setText(stringBuffer.toString());
        }
        signedContent.setCertificates(this.certificates);
        try {
            signedContent.setSigner((RSAPrivateKey)this.signerPrivateKey, this.signerCertificate);
        }
        catch (SignatureException signatureException) {
            throw new MessagingException("Error signing content!", (Exception)signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new MessagingException("Invalid Key!", (Exception)invalidKeyException);
        }
        EncryptedContent encryptedContent = new EncryptedContent(signedContent);
        encryptedContent.addRecipient(this.recipientCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.addRecipient(this.signerCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.setEncryptionAlgorithm(AlgorithmID.rc2_CBC, 40);
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders(message);
        return message;
    }

    public Message createPlainMessage(Session session, DataHandler dataHandler) throws MessagingException {
        Message message = this.createMessage(session);
        message.setSubject("IAIK-S/MIME: Plain");
        if (dataHandler != null) {
            message.setDataHandler(dataHandler);
        } else {
            message.setText("This is a plain message!\nIt is wether signed nor encrypted!\n");
        }
        return message;
    }

    public Message createMessage(Session session) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.from));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to, (boolean)false));
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }

    public Message createEncryptedMessage(Session session, AlgorithmID algorithmID, int n) throws MessagingException {
        Message message = this.createMessage(session);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IAIK-S/MIME: Encrypted [" + algorithmID.getName());
        if (n > 0) {
            stringBuffer.append("/" + n);
        }
        stringBuffer.append("]");
        message.setSubject(stringBuffer.toString());
        EncryptedContent encryptedContent = new EncryptedContent();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("This is the encrypted content!\n");
        stringBuffer2.append("Content encryption algorithm: " + algorithmID.getName());
        stringBuffer2.append("\n\n");
        encryptedContent.setText(stringBuffer2.toString());
        encryptedContent.addRecipient(this.recipientCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.addRecipient(this.signerCertificate, AlgorithmID.rsaEncryption);
        encryptedContent.setEncryptionAlgorithm(algorithmID, n);
        message.setContent((Object)encryptedContent, encryptedContent.getContentType());
        encryptedContent.setHeaders(message);
        return message;
    }

    public Message createCertsOnlyMultiPartMessage(Session session) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText("This is a test where the certs-only message is included in the second part!\n\n");
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        SMimeParameters.useNewContentTypes(true);
        SignedContent signedContent = new SignedContent(true, "certs-only");
        signedContent.setCertificates(this.certificates);
        mimeBodyPart2.setContent((Multipart)signedContent);
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        Message message = this.createMessage(session);
        message.setSubject("IAIK S/MIME: Certs-only message");
        message.setContent((Object)mimeMultipart, mimeMultipart.getContentType());
        return message;
    }

    public Message createCertsOnlyMessage(Session session) throws MessagingException {
        Message message = this.createMessage(session);
        message.setSubject("IAIK S/MIME: Certs-only message");
        SMimeParameters.useNewContentTypes(true);
        SignedContent signedContent = new SignedContent(true, "certs-only");
        signedContent.setCertificates(this.certificates);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders(message);
        return message;
    }

    public SMimeSend() {
        this.signerPrivateKey = IaikKeyStore.getPrivateKey((int)0, (int)1);
        this.recipientCertificate = this.signerCertificate = this.certificates[0];
    }
}

