/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;

public class ESDHParameterSpec
extends DHParameterSpec {
    private int c;
    private byte[] a;
    private BigInteger e;
    private BigInteger b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("q: " + this.b.toString(16));
        if (this.e != null) {
            stringBuffer.append("j: " + this.e.toString(16));
        }
        if (this.a != null) {
            stringBuffer.append("seed: " + this.a.toString());
            stringBuffer.append("pgenCounter: " + this.c);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n2 = this.p.hashCode() ^ this.g.hashCode() ^ this.b.hashCode();
        if (this.e != null) {
            n2 ^= this.e.hashCode();
        }
        if (this.a != null) {
            n2 ^= Util.calculateHashCode(this.a);
        }
        return n2 ^ this.c;
    }

    public byte[] getSeed() {
        return this.a;
    }

    public BigInteger getQ() {
        return this.b;
    }

    public int getPGenCounter() {
        return this.c;
    }

    public int getL() {
        return 0;
    }

    public BigInteger getJ() {
        return this.e;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ESDHParameterSpec)) {
            return false;
        }
        ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)object;
        if (!this.getP().equals(eSDHParameterSpec.getP())) {
            return false;
        }
        if (!this.getG().equals(eSDHParameterSpec.getG())) {
            return false;
        }
        if (!this.b.equals(eSDHParameterSpec.b)) {
            return false;
        }
        if (this.e != null && eSDHParameterSpec.e != null ? !this.e.equals(eSDHParameterSpec.e) : this.e != null || eSDHParameterSpec.e != null) {
            return false;
        }
        if (this.a != null && eSDHParameterSpec.a != null ? !CryptoUtils.equalsBlock(this.a, eSDHParameterSpec.a) : this.a != null || eSDHParameterSpec.a != null) {
            return false;
        }
        return this.c == eSDHParameterSpec.c;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n2) {
        super(bigInteger, bigInteger2);
        this.b = bigInteger3;
        this.a = byArray;
        this.c = n2;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n2) {
        super(bigInteger, bigInteger2);
        this.b = bigInteger3;
        this.e = bigInteger4;
        this.a = byArray;
        this.c = n2;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2);
        this.b = bigInteger3;
        this.e = bigInteger4;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(bigInteger, bigInteger2);
        this.b = bigInteger3;
    }
}

