/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.utils.InternalErrorException;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;

public class SignedData
extends SignedDataStream
implements Content {
    private ContentInfo a;
    byte[] b;

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        AlgorithmID[] algorithmIDArray = ((SignedDataStream)this).a.a();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        if (this.a == null) {
            stringBuffer.append("ContentInfo: yet not set\n");
        } else {
            stringBuffer.append("ContentInfo: {\n" + this.a.toString(bl));
            stringBuffer.append("\n}\n");
        }
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(String.valueOf(((SignerInfo)enumeration.nextElement()).toString(true)) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        this.a = this.mode == 1 && this.b != null ? new ContentInfo(new Data(this.b, n2)) : new ContentInfo(ObjectID.pkcs7_data);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent(new INTEGER(this.version));
            if (this.version == 2) {
                Object object;
                sEQUENCE.addComponent(ASN.createSequenceOf(((SignedDataStream)this).a.a()));
                sEQUENCE.addComponent(this.a.toASN1Object());
                if (this.certificates != null) {
                    object = ASN.createSequenceOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(2, (ASN1Object)object, true));
                }
                if (this.crls != null) {
                    object = ASN.createSequenceOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object, true));
                }
                object = this.signer_infos.elements();
                while (object.hasMoreElements()) {
                    ((SignerInfo)object.nextElement()).a = 2;
                }
                sEQUENCE.addComponent(ASN.createSequenceOf(this.signer_infos));
            } else {
                ASN1Object aSN1Object;
                sEQUENCE.addComponent(ASN.createSetOf(((SignedDataStream)this).a.a()));
                sEQUENCE.addComponent(this.a.toASN1Object());
                if (this.certificates != null) {
                    aSN1Object = ASN.createSetOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
                }
                if (this.crls != null) {
                    aSN1Object = ASN.createSetOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
                }
                sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
            }
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    protected void setupMessageDigests() throws NoSuchAlgorithmException {
        if (this.version == 2) {
            ((SignedDataStream)this).a.a(DerCoder.encode(new OCTET_STRING(this.b)));
            return;
        }
        ((SignedDataStream)this).a.a(this.b);
    }

    public void setVersion(int n2) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
        this.version = n2;
    }

    public void setInputStream(InputStream inputStream) {
        this.input_stream = inputStream;
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                StreamCopier streamCopier = new StreamCopier(this.input_stream, byteArrayOutputStream);
                streamCopier.copyStream();
                this.b = byteArrayOutputStream.toByteArray();
                return;
            }
            catch (Exception exception) {
                throw new InternalErrorException("Error reading from stream!", exception);
            }
        }
    }

    public InputStream getInputStream() {
        if (this.b == null) {
            return null;
        }
        return new ByteArrayInputStream(this.b);
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        return this.b;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            ((SignedDataStream)this).a.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), SignedDataStream.c != null ? SignedDataStream.c : (SignedDataStream.c = SignedDataStream.a("iaik.asn1.structures.AlgorithmID"))));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms!");
        }
        this.a = new ContentInfo(this.this_object);
        this.content_type = this.a.getContentType();
        if (!this.a.hasContent()) {
            this.mode = 2;
            this.notifyEOF();
            return;
        }
        if (!this.content_type.equals(ObjectID.pkcs7_data)) {
            throw new PKCSParsingException("SignedData only for content type Data at this time!");
        }
        Data data = (Data)this.a.getContent();
        this.b = data.getData();
        try {
            this.setupMessageDigests();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSParsingException(noSuchAlgorithmException.getMessage());
        }
        this.notifyEOF();
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        signerInfo.f = this;
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        if (!((SignedDataStream)this).a.b(algorithmID)) {
            MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
            byte[] byArray = this.version == 2 ? messageDigest.digest(DerCoder.encode(new OCTET_STRING(this.b))) : messageDigest.digest(this.b);
            ((SignedDataStream)this).a.a(algorithmID, byArray);
        }
        this.signer_infos.addElement(signerInfo);
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray, int n2) throws NoSuchAlgorithmException {
        this();
        this.b = byArray;
        this.mode = 2;
        if (n2 == 2) {
            this.version = 2;
        } else if (n2 != 1) {
            throw new IllegalArgumentException("Invalid version: " + n2);
        }
        ((SignedDataStream)this).a.a(algorithmIDArray);
        this.setupMessageDigests();
    }

    public SignedData(byte[] byArray, AlgorithmID[] algorithmIDArray) throws NoSuchAlgorithmException {
        this();
        this.b = byArray;
        this.mode = 2;
        ((SignedDataStream)this).a.a(algorithmIDArray);
        this.setupMessageDigests();
    }

    public SignedData(byte[] byArray, int n2) {
        this();
        this.b = byArray;
        this.mode = n2;
        this.content_type = ObjectID.pkcs7_data;
    }

    public SignedData(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public SignedData(ObjectID objectID) {
        this();
        this.content_type = objectID;
    }

    public SignedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected SignedData() {
        this.block_size = -1;
    }
}

