/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GeneralName {
    private int f = -1;
    private static final int e = 1;
    private static final int d = 0;
    private Object b;
    private int a = -1;
    public static final int registeredID = 8;
    public static final int iPAddress = 7;
    public static final int uniformResourceIdentifier = 6;
    public static final int ediPartyName = 5;
    public static final int directoryName = 4;
    public static final int x400Address = 3;
    public static final int dNSName = 2;
    public static final int rfc822Name = 1;
    public static final int otherName = 0;
    private static final boolean c = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a) {
            case 0: {
                stringBuffer.append("otherName: ");
                break;
            }
            case 1: {
                stringBuffer.append("rfc822Name: ");
                break;
            }
            case 2: {
                stringBuffer.append("dNSName: ");
                break;
            }
            case 3: {
                stringBuffer.append("x400Address: ");
                break;
            }
            case 4: {
                stringBuffer.append("directoryName: ");
                break;
            }
            case 5: {
                stringBuffer.append("ediPartyName: ");
                break;
            }
            case 6: {
                stringBuffer.append("uniformResourceIdentifier: ");
                break;
            }
            case 7: {
                stringBuffer.append("iPAddress: ");
                break;
            }
            case 8: {
                stringBuffer.append("registeredID: ");
                break;
            }
            default: {
                stringBuffer.append("undefined");
            }
        }
        if (this.a >= 0) {
            if (this.a == 7) {
                String string = GeneralName.a((byte[])this.b);
                if (string != null) {
                    stringBuffer.append(string);
                }
            } else {
                stringBuffer.append(this.b.toString());
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        ASN1Object aSN1Object = null;
        boolean bl = true;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                aSN1Object = (ASN1Object)this.b;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                aSN1Object = new OCTET_STRING(Util.toASCIIBytes((String)this.b));
                break;
            }
            case 7: {
                aSN1Object = new OCTET_STRING((byte[])this.b);
                break;
            }
            case 4: {
                aSN1Object = ((Name)this.b).toASN1Object();
                bl = false;
                break;
            }
            case 8: {
                aSN1Object = (ObjectID)this.b;
                break;
            }
            default: {
                throw new CodingException("GeneralName: type " + this.a + " not implemented yet!");
            }
        }
        if (this.f > -1) {
            bl = this.f == 0;
        }
        return new CON_SPEC(this.a, aSN1Object, bl);
    }

    private static String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (byArray.length == 4) {
                int n2 = 0;
                while (n2 < byArray.length) {
                    if (n2 > 0) {
                        stringBuffer.append(".");
                    }
                    stringBuffer.append(Integer.toString(byArray[n2] & 0xFF));
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < byArray.length) {
                    if (n3 > 0) {
                        stringBuffer.append(":");
                    }
                    stringBuffer.append(Integer.toHexString(byArray[n3] << 8 & 0xFF00 | byArray[++n3] & 0xFF));
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public int hashCode() {
        int n2 = this.a;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                n2 += Util.calculateHashCode(DerCoder.encode((ASN1Object)this.b));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 += this.b.hashCode();
                break;
            }
            case 7: {
                n2 += Util.calculateHashCode((byte[])this.b);
                break;
            }
            default: {
                n2 += "undefined".hashCode();
            }
        }
        return n2;
    }

    public int getType() {
        return this.a;
    }

    public Object getName() {
        if (this.a == 7) {
            return GeneralName.a((byte[])this.b);
        }
        return this.b;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralName)) {
            return false;
        }
        GeneralName generalName = (GeneralName)object;
        if (this.a != generalName.a) {
            return false;
        }
        boolean bl = false;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                bl = CryptoUtils.equalsBlock(DerCoder.encode((ASN1Object)this.b), DerCoder.encode((ASN1Object)generalName.b));
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                bl = this.b.equals(generalName.b);
                break;
            }
            case 7: {
                bl = CryptoUtils.equalsBlock((byte[])this.b, (byte[])generalName.b);
                break;
            }
            default: {
                throw new InternalErrorException("GeneralName: type " + this.a + " not implemented yet!");
            }
        }
        return bl;
    }

    public GeneralName(ASN1Object aSN1Object) throws CodingException {
        ASN1Object aSN1Object2 = null;
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new CodingException("No GeneralName structure!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.a = aSN1Object.getAsnType().getTag();
        this.f = 0;
        switch (this.a) {
            case 0: 
            case 3: 
            case 5: {
                if (cON_SPEC.countComponents() > 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                } else {
                    this.f = 1;
                }
                this.b = cON_SPEC.getValue();
                return;
            }
            case 1: 
            case 2: 
            case 6: {
                cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                this.b = Util.toASCIIString((byte[])aSN1Object2.getValue());
                return;
            }
            case 7: {
                cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof OCTET_STRING)) {
                    throw new CodingException("Cannot parse GeneralName. Expected OCTET_STRING!");
                }
                this.b = aSN1Object2.getValue();
                return;
            }
            case 4: {
                Object object = cON_SPEC.getValue();
                if (object instanceof ASN1Object && ((ASN1Object)object).getAsnType().equals(ASN.SEQUENCE)) {
                    this.f = 1;
                } else {
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                }
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof SEQUENCE)) {
                    throw new CodingException("Cannot parse GeneralName of type directoryName!  Name has to be a SEQUENCE!");
                }
                this.b = new Name(aSN1Object2);
                return;
            }
            case 8: {
                Object object = cON_SPEC.getValue();
                if (object instanceof ASN1Object && ((ASN1Object)object).getAsnType().equals(ASN.ObjectID)) {
                    this.f = 1;
                } else {
                    cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
                }
                aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                if (!(aSN1Object2 instanceof ObjectID)) {
                    throw new CodingException("Cannot parse GeneralName of type registeredID. Expected an ObjectID instance!");
                }
                this.b = (ObjectID)aSN1Object2;
                return;
            }
        }
        throw new CodingException("Cannot parse GeneralName! Illegal type specification! Type has to be in the range of 0...8!");
    }

    public GeneralName(int n2, Object object) throws IllegalArgumentException {
        switch (n2) {
            case 0: 
            case 3: 
            case 5: {
                if (object instanceof ASN1Object) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Expecting ASN1Object for type otherName!");
            }
            case 1: 
            case 2: 
            case 6: {
                if (object instanceof String) break;
                throw new IllegalArgumentException("Cannot create GeneralName! Wrong generalName argument! Expected a String instance!");
            }
            case 7: {
                if (object instanceof InetAddress) {
                    this.b = ((InetAddress)object).getAddress();
                    break;
                }
                if (object instanceof byte[]) {
                    this.b = object;
                    break;
                }
                if (object instanceof String) {
                    try {
                        this.b = InetAddress.getByName((String)object).getAddress();
                        break;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException("Cannot create GeneralName from given ipAddress: " + unknownHostException.getMessage());
                    }
                }
                throw new IllegalArgumentException("Cannot create GeneralName! Wrong ipAddress format! Expected InetAddress object or byte array!");
            }
            case 4: {
                if (object instanceof Name) break;
                throw new IllegalArgumentException("Cannot create GeneralName type directoryName! Wrong generalName argument! Expected a Name instance!");
            }
            case 8: {
                if (object instanceof ObjectID) break;
                throw new IllegalArgumentException("Cannot create GeneralName type registeredID! Wrong generalName argument! Expected an ObjectID instance!");
            }
            default: {
                throw new IllegalArgumentException("Cannot create GeneralName! Illegal type specification: " + n2 + "!. " + "Type has to be in the range of 0...8!");
            }
        }
        if (n2 != 7) {
            this.b = object;
        }
        this.a = n2;
    }
}

