/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.utils;

import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.utils.X500Utils;
import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.utils.Base64OutputStream;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.PemOutputStream;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.ExtendedKeyUsage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.crypto.interfaces.DHPublicKey;

public class TrustmanagerUtils {
    private static final boolean DEBUG = false;
    public static final int NOTDECODEABLE = 0;
    public static final int CERTARRAY = 1;
    public static final int CRL = 2;
    public static final int CERT = 3;
    public static final int PKCS12 = 4;
    private static int importFileType = 0;
    private static FileInputStream importStream;
    private static X509Certificate imported_Certificate;
    private static X509Certificate imported_CRL;
    private static Object obj;

    public static String adaptDirectoryName(String directory) {
        if (!(directory = directory.trim()).endsWith(File.separator)) {
            directory = directory.concat(File.separator);
        }
        return directory;
    }

    public static String adaptURLString(String url) {
        if ((url = url.trim()).length() < 1) {
            return null;
        }
        if (!url.endsWith("/")) {
            url = url.concat("/");
        }
        return url;
    }

    public static String formatString(String string) {
        int pos;
        do {
            if ((pos = string.lastIndexOf(32)) <= -1) continue;
            string = String.valueOf(string.substring(0, pos)).concat(String.valueOf(string.substring(pos + 1)));
        } while (pos > -1);
        return string;
    }

    public static void deletePassword(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 32;
        }
    }

    public static byte[] makeCertHash(X509Certificate cert) {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA", "IAIK");
        }
        catch (Exception e2) {
            throw new InternalErrorException("Could not instantiate SHA from Provider IAIK. ");
        }
        try {
            sha.update(cert.getEncoded());
        }
        catch (CertificateEncodingException e3) {
            throw new InternalErrorException(String.valueOf("Could not encode certificate: ").concat(String.valueOf(e3.getMessage())));
        }
        return sha.digest();
    }

    public static X509Certificate[] arrangeCertChain(X509Certificate[] certArray, boolean topdown) {
        if (certArray != null && certArray[0] != null) {
            Vector<X509Certificate> certChainVector = new Vector<X509Certificate>();
            Vector<X509Certificate> certArrayVector = new Vector<X509Certificate>();
            certChainVector.addElement(certArray[0]);
            for (int i = 1; i < certArray.length; ++i) {
                certArrayVector.addElement(certArray[i]);
            }
            boolean eECertFound = false;
            boolean rootCACertFound = false;
            while (!(certArrayVector.size() <= 0 || rootCACertFound && eECertFound)) {
                Name issuer2;
                Name subject1;
                X509Certificate cert2;
                X509Certificate cert1;
                int i;
                boolean certFound = false;
                for (i = 0; i < certArrayVector.size() && !certFound && !eECertFound; ++i) {
                    cert1 = (X509Certificate)certChainVector.elementAt(certChainVector.size() - 1);
                    cert2 = (X509Certificate)certArrayVector.elementAt(i);
                    subject1 = (Name)cert1.getSubjectDN();
                    issuer2 = (Name)cert2.getIssuerDN();
                    if (subject1 == null) break;
                    if (!issuer2.equals((Object)subject1)) continue;
                    try {
                        cert2.verify(cert1.getPublicKey());
                        certFound = true;
                        certArrayVector.removeElementAt(i);
                        certChainVector.addElement(cert2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!certFound) {
                    eECertFound = true;
                }
                certFound = false;
                for (i = 0; i < certArrayVector.size() && !certFound && !rootCACertFound; ++i) {
                    cert1 = (X509Certificate)certArrayVector.elementAt(i);
                    cert2 = (X509Certificate)certChainVector.elementAt(0);
                    subject1 = (Name)cert1.getSubjectDN();
                    issuer2 = (Name)cert2.getIssuerDN();
                    if (!issuer2.equals((Object)subject1)) continue;
                    try {
                        cert2.verify(cert1.getPublicKey());
                        certFound = true;
                        certArrayVector.removeElementAt(i);
                        certChainVector.insertElementAt(cert1, 0);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (certFound) continue;
                rootCACertFound = true;
            }
            if (certArrayVector.size() == 0) {
                X509Certificate[] result = new X509Certificate[certChainVector.size()];
                for (int j = 0; j < result.length; ++j) {
                    result[j] = topdown ? (X509Certificate)certChainVector.elementAt(j) : (X509Certificate)certChainVector.elementAt(certChainVector.size() - 1 - j);
                }
                return result;
            }
            return null;
        }
        return null;
    }

    public static boolean verifyChain(java.security.cert.X509Certificate[] certChain) {
        int n = certChain.length;
        try {
            for (int i = 0; i < n; ++i) {
                if (i <= 0) continue;
                if (!certChain[i].getSubjectDN().equals(certChain[i - 1].getIssuerDN())) {
                    boolean bl = false;
                    return bl;
                }
                certChain[i - 1].verify(certChain[i].getPublicKey());
            }
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public static String[] parseLDAPURL(String url_complete) throws TrustmanagerException {
        if (!(url_complete = url_complete.trim()).startsWith("ldap://")) {
            throw new TrustmanagerException("Directory address invalid. Must begin with <ldap://>. ");
        }
        int semiColon_Position = url_complete.indexOf(":", 7);
        int slash_Position = url_complete.indexOf("/", 7);
        if (semiColon_Position < 0 && slash_Position < 0) {
            String url = url_complete;
            String port = "389";
            String suffix = "";
            String[] result = new String[]{url, port, suffix};
            return result;
        }
        if (semiColon_Position > 7 && slash_Position < 0) {
            String url = url_complete.substring(0, semiColon_Position);
            String port = url_complete.substring(semiColon_Position + 1, url_complete.length());
            String suffix = "";
            String[] result = new String[]{url, port, suffix};
            return result;
        }
        if (semiColon_Position < 0 && slash_Position > 7) {
            String url = url_complete.substring(0, slash_Position);
            String port = "389";
            String suffix = url_complete.substring(slash_Position + 1, url_complete.length());
            String[] result = new String[]{url, port, suffix};
            return result;
        }
        if (semiColon_Position >= slash_Position) {
            throw new TrustmanagerException("Directory address invalid. ");
        }
        String url = url_complete.substring(0, semiColon_Position);
        String port = url_complete.substring(semiColon_Position + 1, slash_Position);
        String suffix = url_complete.substring(slash_Position + 1, url_complete.length());
        String[] result = new String[]{url, port, suffix};
        return result;
    }

    public static int getObjectType() {
        return importFileType;
    }

    public static Object parseImportFile(File file) {
        importFileType = 0;
        imported_CRL = null;
        imported_Certificate = null;
        String extension = null;
        String s = file.getName();
        String fileName = file.getPath();
        int i = s.lastIndexOf(46);
        extension = i > 0 && i < s.length() - 1 ? ((extension = s.substring(i + 1).toLowerCase()).equals("cer") || extension.equals("b64") || extension.equals("pem") || extension.equals("der") ? "der" : (extension.equals("pfx") || extension.equals("p12") ? "p12" : (extension.equals("p7b") || extension.equals("p7c") ? "p7c" : null))) : null;
        FileInputStream importStream = null;
        try {
            if (extension == null || extension.equals("der")) {
                importStream = new FileInputStream(new File(fileName));
                try {
                    X509Certificate cert = new X509Certificate((InputStream)importStream);
                    importFileType = 1;
                    X509Certificate[] certArray = new X509Certificate[]{cert};
                    importStream.close();
                    X509Certificate[] x509CertificateArray = certArray;
                    return x509CertificateArray;
                }
                catch (Exception e2) {
                    importStream.close();
                    importStream = new FileInputStream(new File(fileName));
                    try {
                        X509CRL crl = new X509CRL((InputStream)importStream);
                        importFileType = 2;
                        importStream.close();
                        X509CRL x509CRL = crl;
                        return x509CRL;
                    }
                    catch (Exception e3) {
                        importStream.close();
                    }
                }
            }
            if (extension == null || extension != null && !extension.equals("p12")) {
                importStream = new FileInputStream(new File(fileName));
                try {
                    PKCS7CertList certList = new PKCS7CertList((InputStream)importStream);
                    importFileType = 1;
                    importStream.close();
                    X509Certificate[] x509CertificateArray = certList.getCertificateList();
                    return x509CertificateArray;
                }
                catch (Exception e4) {
                    importStream.close();
                }
            }
            if (extension == null || extension.equals("p12")) {
                importStream = new FileInputStream(new File(fileName));
                try {
                    PKCS12 p12 = new PKCS12((InputStream)importStream);
                    importFileType = 4;
                    importStream.close();
                    PKCS12 pKCS12 = p12;
                    return pKCS12;
                }
                catch (PKCSParsingException e5) {
                    importStream.close();
                }
            }
            imported_CRL = null;
            imported_Certificate = null;
            importFileType = 0;
            Object e5 = null;
            return e5;
        }
        catch (IOException e6) {
            try {
                importStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            imported_CRL = null;
            imported_Certificate = null;
            importFileType = 0;
            Object var7_20 = null;
            return var7_20;
        }
    }

    public static String getKeyAlgorithm(X509Certificate cert) {
        String keyAlgorithm = null;
        PublicKey pki = cert.getPublicKey();
        if (pki instanceof RSAPublicKey) {
            RSAPublicKey pk = (RSAPublicKey)pki;
            keyAlgorithm = String.valueOf(String.valueOf("RSA, ").concat(String.valueOf(pk.getModulus().toString(2).length()))).concat(String.valueOf(" bit"));
        } else if (pki instanceof DSAPublicKey) {
            DSAPublicKey pk = (DSAPublicKey)pki;
            keyAlgorithm = String.valueOf(String.valueOf("DSA, ").concat(String.valueOf(pk.getParams().getP().toString(2).length()))).concat(String.valueOf(" bit"));
        } else if (pki instanceof DHPublicKey) {
            DHPublicKey pk = (DHPublicKey)pki;
            keyAlgorithm = String.valueOf(String.valueOf("Diffie-Hellman, ").concat(String.valueOf(pk.getParams().getP().bitLength()))).concat(String.valueOf(" bit"));
        } else {
            throw new InternalErrorException("Certificate contains unknown public key. ");
        }
        return keyAlgorithm;
    }

    public static boolean isCA(X509Certificate cert) {
        try {
            BasicConstraints bC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (bC != null && bC.ca()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e2) {
            boolean bl = TrustmanagerUtils.isRootCA(cert);
            return bl;
        }
        return TrustmanagerUtils.isRootCA(cert);
    }

    public static boolean isRootCA(X509Certificate cert) {
        try {
            cert.verify();
            boolean bl = true;
            return bl;
        }
        catch (SignatureException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            throw new InternalErrorException(String.valueOf("Could not verify certificate's signature: ").concat(String.valueOf(e2.getMessage())));
        }
    }

    public static void exportFile(Object obj, File file, int objectType) throws TrustmanagerException {
        String extension = "";
        String s = file.getName();
        int i = (s = s.trim()).lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            extension = s.substring(i + 1).toLowerCase();
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            if (objectType == 3) {
                if (extension.equals("p7b") || extension.equals("p7c")) {
                    PKCS7CertList certList = new PKCS7CertList();
                    X509Certificate[] certArray = new X509Certificate[]{(X509Certificate)obj};
                    certList.setCertificateList(certArray);
                    certList.writeTo((OutputStream)outputStream);
                    outputStream.close();
                } else {
                    X509Certificate cert = (X509Certificate)obj;
                    if (extension.equals("pem")) {
                        PemOutputStream pemStream = new PemOutputStream((OutputStream)outputStream, "-----BEGIN PEM-style-B64-encoded X.509 PKI certificate-----", "-----END PEM-style-B64-encoded X.509 PKI certificate-----");
                        pemStream.write(cert.getEncoded());
                        pemStream.flush();
                        pemStream.close();
                    } else if (extension.equals("b64")) {
                        Base64OutputStream b64Stream = new Base64OutputStream((OutputStream)outputStream);
                        b64Stream.write(cert.getEncoded());
                        b64Stream.flush();
                        b64Stream.close();
                    } else {
                        outputStream.write(cert.getEncoded());
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                return;
            }
            if (objectType == 1) {
                PKCS7CertList certList = new PKCS7CertList();
                X509Certificate[] certArray = (X509Certificate[])obj;
                certList.setCertificateList(certArray);
                certList.writeTo((OutputStream)outputStream);
                outputStream.flush();
                outputStream.close();
                return;
            }
            throw new InternalErrorException();
        }
        catch (CertificateEncodingException e2) {
            throw new TrustmanagerException("Cannot write to file. Unable to encode certificate/certificate chain. ");
        }
        catch (IOException e3) {
            throw new TrustmanagerException(String.valueOf("Cannot write to file. Input/Output Error occurd: ").concat(String.valueOf(e3.getMessage())));
        }
    }

    public static boolean areEqual(X509Certificate cert1, X509Certificate cert2) {
        Name subject2;
        if (cert1 == null || cert2 == null) {
            return false;
        }
        Name subject1 = (Name)cert1.getSubjectDN();
        if (subject1.equals((Object)(subject2 = (Name)cert2.getSubjectDN()))) {
            byte[] array2;
            byte[] array1 = DerCoder.encode((ASN1Object)cert1.toASN1Object());
            return CryptoUtils.equalsBlock((byte[])array1, (byte[])(array2 = DerCoder.encode((ASN1Object)cert2.toASN1Object())));
        }
        return false;
    }

    public static String dateToText(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss, MMM d, yyyy");
        return formatter.format(date);
    }

    public static String Base16Encode(byte[] array) {
        String result = new String();
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                byte value = j == 0 ? (byte)((array[i] & 0xF0) >>> 4) : (byte)(array[i] & 0xF);
                if (value == 0) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('0')));
                    continue;
                }
                if (value == 1) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('1')));
                    continue;
                }
                if (value == 2) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('2')));
                    continue;
                }
                if (value == 3) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('3')));
                    continue;
                }
                if (value == 4) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('4')));
                    continue;
                }
                if (value == 5) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('5')));
                    continue;
                }
                if (value == 6) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('6')));
                    continue;
                }
                if (value == 7) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('7')));
                    continue;
                }
                if (value == 8) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('8')));
                    continue;
                }
                if (value == 9) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('9')));
                    continue;
                }
                if (value == 10) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('A')));
                    continue;
                }
                if (value == 11) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('B')));
                    continue;
                }
                if (value == 12) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('C')));
                    continue;
                }
                if (value == 13) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('D')));
                    continue;
                }
                if (value == 14) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('E')));
                    continue;
                }
                if (value == 15) {
                    result = String.valueOf(result).concat(String.valueOf(String.valueOf('F')));
                    continue;
                }
                throw new InternalErrorException();
            }
        }
        return result;
    }

    public static int getExtKeyUsage(X509Certificate cert) {
        ObjectID[] eKU = null;
        try {
            ExtendedKeyUsage eKU_temp = (ExtendedKeyUsage)cert.getExtension(ExtendedKeyUsage.oid);
            if (eKU_temp != null) {
                eKU = eKU_temp.getKeyPurposeIDs();
            }
        }
        catch (X509ExtensionInitException eKU_temp) {
            // empty catch block
        }
        if (eKU == null) {
            return 1;
        }
        int result = 0;
        for (int i = 0; i < eKU.length; ++i) {
            if (eKU[i].equals((Object)ExtendedKeyUsage.clientAuth)) {
                result += 4;
                continue;
            }
            if (eKU[i].equals((Object)ExtendedKeyUsage.serverAuth)) {
                result += 2;
                continue;
            }
            if (eKU[i].equals((Object)ExtendedKeyUsage.codeSigning)) {
                result += 8;
                continue;
            }
            if (eKU[i].equals((Object)ExtendedKeyUsage.emailProtection)) {
                result += 16;
                continue;
            }
            if (!eKU[i].equals((Object)ExtendedKeyUsage.timeStamping)) continue;
            result += 32;
        }
        return result;
    }

    public static String getCertificateName(X509Certificate cert) {
        int i;
        Object result = null;
        String[] cn = X500Utils.getCommonName(cert);
        if (!(cn != null && cn.length != 0 || (cn = X500Utils.getOrganizationalUnit(cert)) != null && cn.length != 0 || (cn = X500Utils.getOrganization(cert)) != null || cn.length != 0)) {
            cn[0] = "THIS CERT DOES NOT CONTAIN ANY CN, OU, NOR O DISTINGUISHED NAME ATTRIBUTES!!! ";
        }
        String[] email = X500Utils.getEMail(cert);
        String[] url = X500Utils.getURL(cert);
        if (email != null) {
            for (i = 0; i < email.length; ++i) {
                cn[0] = String.valueOf(cn[0]).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(email[i]))));
            }
        }
        if (url != null) {
            for (i = 0; i < url.length; ++i) {
                cn[0] = String.valueOf(cn[0]).concat(String.valueOf(String.valueOf(", ").concat(String.valueOf(url[i]))));
            }
        }
        return cn[0];
    }

    public static String byteArrayToString(byte[] array) {
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (char)array[i];
        }
        return new String(result);
    }
}

