/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.trust;

import iaik.apps.trustmanager.TrustmanagerException;
import iaik.apps.trustmanager.api.TrustEnv;
import iaik.apps.trustmanager.trust.CertIdentifier;
import iaik.apps.trustmanager.trust.TrustRecord;
import iaik.apps.trustmanager.utils.Integrity;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.x509.X509Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class TrustStore {
    private static Hashtable hashtable = new Hashtable();
    private static final boolean DEBUG = false;

    public static void load() throws TrustmanagerException, IOException {
        SEQUENCE trustStore;
        hashtable = new Hashtable();
        FileInputStream inStream = new FileInputStream(new File(TrustEnv.trustFile));
        try {
            trustStore = (SEQUENCE)DerCoder.decode((InputStream)inStream);
        }
        catch (CodingException e2) {
            throw new IOException(String.valueOf("Could not decode TrustStore: ").concat(String.valueOf(e2.getMessage())));
        }
        inStream.close();
        SEQUENCE trustRecords = (SEQUENCE)trustStore.getComponentAt(0);
        OCTET_STRING salt_OctetString = (OCTET_STRING)trustStore.getComponentAt(1);
        byte[] salt_ByteArray = (byte[])salt_OctetString.getValue();
        OCTET_STRING hMAC_OctetString = (OCTET_STRING)trustStore.getComponentAt(2);
        byte[] hMAC_ByteArray = (byte[])hMAC_OctetString.getValue();
        Integrity.updatePBEKey(salt_ByteArray);
        if (!Integrity.compare(DerCoder.encode((ASN1Object)trustRecords), hMAC_ByteArray)) {
            throw new TrustmanagerException("Password not valid. Integrity verification failed. ");
        }
        for (int i = 0; i < trustRecords.countComponents(); ++i) {
            SEQUENCE trustRecord_ASN1 = (SEQUENCE)trustRecords.getComponentAt(i);
            TrustRecord trustRecord = new TrustRecord();
            try {
                trustRecord.decode((ASN1Object)trustRecord_ASN1);
            }
            catch (CodingException e3) {
                throw new IOException("Could not parse TrustStore file. ");
            }
            CertIdentifier certIdentifier = trustRecord.getCertIdentifier();
            byte[] certHash = certIdentifier.getCertHash();
            hashtable.put(TrustmanagerUtils.byteArrayToString(certHash), trustRecord);
        }
    }

    public static void store() throws IOException {
        SEQUENCE trustRecords = new SEQUENCE();
        Enumeration e2 = hashtable.elements();
        while (e2.hasMoreElements()) {
            TrustRecord trustRecord = (TrustRecord)e2.nextElement();
            trustRecords.addComponent(trustRecord.toASN1Object());
        }
        byte[] saltMio = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 56, 55, 54, 53, 52, 51, 50};
        byte[] salt_ByteArray = Integrity.updatePBEKey(saltMio);
        byte[] hMAC_ByteArray = Integrity.makeHMAC(DerCoder.encode((ASN1Object)trustRecords));
        SEQUENCE trustStore = new SEQUENCE();
        trustStore.addComponent((ASN1Object)trustRecords);
        trustStore.addComponent((ASN1Object)new OCTET_STRING(salt_ByteArray));
        trustStore.addComponent((ASN1Object)new OCTET_STRING(hMAC_ByteArray));
        String backupFileName = TrustEnv.trustFile;
        backupFileName = backupFileName.substring(0, backupFileName.length() - 1);
        backupFileName = String.valueOf(backupFileName).concat(String.valueOf("~"));
        File backupFile = new File(backupFileName);
        backupFile.delete();
        File trustFile = new File(TrustEnv.trustFile);
        trustFile.renameTo(backupFile);
        FileOutputStream outStream = new FileOutputStream(trustFile);
        DerCoder.encodeTo((ASN1Object)trustStore, (OutputStream)outStream);
        outStream.flush();
        outStream.close();
    }

    public static TrustRecord getTrustRecord(X509Certificate cert) {
        if (cert != null) {
            byte[] certHash = TrustmanagerUtils.makeCertHash(cert);
            TrustRecord trustRecord = (TrustRecord)hashtable.get(TrustmanagerUtils.byteArrayToString(certHash));
            return trustRecord;
        }
        return null;
    }

    public static void putTrustRecord(TrustRecord trustRecord) {
        if (trustRecord != null) {
            CertIdentifier certID = trustRecord.getCertIdentifier();
            byte[] certHash = certID.getCertHash();
            hashtable.put(TrustmanagerUtils.byteArrayToString(certHash), trustRecord);
        }
    }

    public static void removeTrustRecord(X509Certificate cert) {
        if (cert != null) {
            byte[] certHash = TrustmanagerUtils.makeCertHash(cert);
            hashtable.remove(TrustmanagerUtils.byteArrayToString(certHash));
        }
    }

    public static void removeTrustRecord(TrustRecord trustRecord) {
        if (trustRecord != null) {
            CertIdentifier certID = trustRecord.getCertIdentifier();
            byte[] certHash = certID.getCertHash();
            hashtable.remove(TrustmanagerUtils.byteArrayToString(certHash));
        }
    }

    public static Enumeration getTrustRecords() {
        return hashtable.elements();
    }

    public static boolean isEmpty() {
        return hashtable.isEmpty();
    }
}

