/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.trust;

import iaik.apps.trustmanager.trust.CertIdentifier;
import iaik.apps.trustmanager.trust.PurposeProperties;
import iaik.apps.trustmanager.trust.RevocationInfo;
import iaik.apps.trustmanager.trust.TrustProperties;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import java.math.BigInteger;
import java.util.Date;

public final class TrustRecord
implements ASN1Type {
    protected boolean initialized = false;
    protected CertIdentifier certIdentifier = null;
    protected TrustProperties trustProperties = new TrustProperties();
    protected PurposeProperties purposeProperties = null;
    protected RevocationInfo revocationInfo = null;
    protected long date = -1L;

    public TrustRecord() {
    }

    public TrustRecord(X509Certificate cert) {
        this.certIdentifier = new CertIdentifier(cert);
        this.trustProperties = new TrustProperties();
        this.purposeProperties = null;
        this.revocationInfo = null;
        this.date = new Date().getTime();
        this.initialized = true;
    }

    public void setTrustProperties(TrustProperties trustProperties) {
        this.trustProperties = trustProperties;
    }

    public void setPurposeProperties(PurposeProperties purposeProperties) {
        this.purposeProperties = purposeProperties;
    }

    public void setRevocationInfo(RevocationInfo revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public CertIdentifier getCertIdentifier() {
        if (this.initialized) {
            return this.certIdentifier;
        }
        throw new InternalErrorException("TrustRecord is not initialized yet. ");
    }

    public TrustProperties getTrustProperties() {
        if (this.initialized) {
            return this.trustProperties;
        }
        throw new InternalErrorException("TrustRecord is not initialized yet. ");
    }

    public PurposeProperties getPurposeProperties() {
        if (this.initialized) {
            return this.purposeProperties;
        }
        throw new InternalErrorException("TrustRecord is not initialized yet. ");
    }

    public RevocationInfo getRevocationInfo() {
        if (this.initialized) {
            return this.revocationInfo;
        }
        throw new InternalErrorException("TrustRecord is not initialized yet. ");
    }

    public Date getDate() {
        if (this.initialized) {
            return new Date(this.date);
        }
        throw new InternalErrorException("TrustRecord is not initialized yet. ");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void decode(ASN1Object obj) throws CodingException {
        this.initialized = false;
        try {
            this.certIdentifier = new CertIdentifier();
            this.certIdentifier.decode(obj.getComponentAt(0));
            this.trustProperties = new TrustProperties();
            this.trustProperties.decode(obj.getComponentAt(1));
            int count = obj.countComponents();
            for (int i = 2; i < count; ++i) {
                if (i == count - 1) {
                    BigInteger temp = (BigInteger)((INTEGER)obj.getComponentAt(i)).getValue();
                    this.date = temp.longValue();
                    continue;
                }
                CON_SPEC temp_ASN1 = (CON_SPEC)obj.getComponentAt(i);
                int tag = temp_ASN1.getAsnType().getTag();
                if (tag == 0) {
                    this.purposeProperties = new PurposeProperties();
                    this.purposeProperties.decode((ASN1Object)((SEQUENCE)temp_ASN1.getValue()));
                    continue;
                }
                this.revocationInfo = new RevocationInfo();
                this.revocationInfo.decode((ASN1Object)((SEQUENCE)temp_ASN1.getValue()));
            }
        }
        catch (Exception e2) {
            throw new CodingException("Not an ASN.1 encoded TrustRecord object. ");
        }
        this.initialized = true;
    }

    public ASN1Object toASN1Object() {
        if (this.initialized) {
            SEQUENCE seq = new SEQUENCE();
            seq.addComponent(this.certIdentifier.toASN1Object());
            seq.addComponent(this.trustProperties.toASN1Object());
            if (this.purposeProperties != null) {
                CON_SPEC pP_tagged = new CON_SPEC(0, this.purposeProperties.toASN1Object(), false);
                seq.addComponent((ASN1Object)pP_tagged);
            }
            if (this.revocationInfo != null) {
                CON_SPEC rI_tagged = new CON_SPEC(1, this.revocationInfo.toASN1Object(), false);
                seq.addComponent((ASN1Object)rI_tagged);
            }
            INTEGER date_ASN1 = new INTEGER(BigInteger.valueOf(this.date));
            seq.addComponent((ASN1Object)date_ASN1);
            return seq;
        }
        throw new InternalErrorException("TrustRecord is not initialized yet. ");
    }
}

