/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.trust;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.ENUMERATED;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;

public final class TrustProperties
implements ASN1Type {
    protected static final int TRUSTED = 0;
    protected static final int NEUTRAL = 1;
    protected static final int MISTRUSTED = 2;
    protected int trustStatus = 1;
    protected boolean revVerification = true;
    protected boolean revVerificationIssuedCerts = true;
    protected boolean alwaysGetLatestRevInfo = false;
    protected String note;

    public boolean isTrusted() {
        return this.trustStatus == 0;
    }

    public boolean isMistrusted() {
        return this.trustStatus == 2;
    }

    public boolean isNeutral() {
        return this.trustStatus == 1;
    }

    public void setTrusted() {
        this.trustStatus = 0;
    }

    public void setMistrusted() {
        this.trustStatus = 2;
    }

    public void setNeutral() {
        this.trustStatus = 1;
    }

    public boolean isRevVerificationSet() {
        return this.revVerification;
    }

    public boolean isRevVerificationIssuedCerts() {
        return this.revVerificationIssuedCerts;
    }

    public boolean isAlwaysGetLatestRevInfo() {
        return this.alwaysGetLatestRevInfo;
    }

    public void setRevVerification(boolean policy) {
        this.revVerification = policy;
    }

    public void setRevVerificationIssuedCerts(boolean policy) {
        this.revVerificationIssuedCerts = policy;
    }

    public void setAlwaysGetLatestRevInfo(boolean policy) {
        this.alwaysGetLatestRevInfo = policy;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getNote() {
        return this.note;
    }

    public void decode(ASN1Object obj) throws CodingException {
        if (obj.getAsnType() != ASN.SEQUENCE && obj.countComponents() != 5) {
            throw new CodingException("Not a TrustProperties object. ");
        }
        try {
            ENUMERATED trustStatus_ASN1 = (ENUMERATED)obj.getComponentAt(0);
            int trustStatus_temp = (Integer)trustStatus_ASN1.getValue();
            this.trustStatus = trustStatus_temp == 0 ? 0 : (trustStatus_temp == 2 ? 2 : 1);
            BOOLEAN revVerification_ASN1 = (BOOLEAN)obj.getComponentAt(1);
            this.revVerification = (Boolean)revVerification_ASN1.getValue();
            BOOLEAN revVerificationIssuedCerts_ASN1 = (BOOLEAN)obj.getComponentAt(2);
            this.revVerificationIssuedCerts = (Boolean)revVerificationIssuedCerts_ASN1.getValue();
            BOOLEAN alwaysGetLatestRevInfo_ASN1 = (BOOLEAN)obj.getComponentAt(3);
            this.alwaysGetLatestRevInfo = (Boolean)alwaysGetLatestRevInfo_ASN1.getValue();
            UTF8String note_ASN1 = (UTF8String)obj.getComponentAt(4);
            this.note = (String)note_ASN1.getValue();
        }
        catch (Exception e2) {
            throw new CodingException("Not a TrustProperties object. ");
        }
    }

    public ASN1Object toASN1Object() {
        ENUMERATED trustStatus_ASN1 = new ENUMERATED(this.trustStatus);
        BOOLEAN revVerification_ASN1 = new BOOLEAN(this.revVerification);
        BOOLEAN revVerificationIssuedCerts_ASN1 = new BOOLEAN(this.revVerificationIssuedCerts);
        BOOLEAN alwaysGetLatestRevInfo_ASN1 = new BOOLEAN(this.alwaysGetLatestRevInfo);
        if (this.note == null || this.note.length() == 0) {
            this.note = String.valueOf(' ');
        }
        UTF8String note_ASN1 = new UTF8String(this.note);
        SEQUENCE trustProp = new SEQUENCE();
        trustProp.addComponent((ASN1Object)trustStatus_ASN1);
        trustProp.addComponent((ASN1Object)revVerification_ASN1);
        trustProp.addComponent((ASN1Object)revVerificationIssuedCerts_ASN1);
        trustProp.addComponent((ASN1Object)alwaysGetLatestRevInfo_ASN1);
        trustProp.addComponent((ASN1Object)note_ASN1);
        return trustProp;
    }
}

