/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.trust;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import java.util.Enumeration;

public final class PurposeProperties
implements ASN1Type {
    protected boolean keyAgreement = false;
    protected boolean encipherOnly = false;
    protected boolean decipherOnly = false;
    protected boolean keyEncipherment = false;
    protected boolean dataEncipherment = false;
    protected boolean digitalSignature = false;
    protected boolean nonRepudiation = false;
    protected boolean keyCertSign = false;
    protected boolean cRLSign = false;
    protected boolean webServerAuthen = false;
    protected boolean webClientAuthen = false;
    protected boolean codeSigning = false;
    protected boolean eMailProtection = false;
    protected boolean timeStamping = false;

    public boolean isKeyAgreement() {
        return this.keyAgreement;
    }

    public boolean isEncipherOnly() {
        return this.encipherOnly;
    }

    public boolean isDecipherOnly() {
        return this.decipherOnly;
    }

    public boolean isKeyEncipherment() {
        return this.keyEncipherment;
    }

    public boolean isDataEncipherment() {
        return this.dataEncipherment;
    }

    public boolean isDigitalSignature() {
        return this.digitalSignature;
    }

    public boolean isNonRepudiation() {
        return this.nonRepudiation;
    }

    public boolean isKeyCertSign() {
        return this.keyCertSign;
    }

    public boolean isCRLSign() {
        return this.cRLSign;
    }

    public boolean isWebServerAuthen() {
        return this.webServerAuthen;
    }

    public boolean isWebClientAuthen() {
        return this.webClientAuthen;
    }

    public boolean isCodeSigning() {
        return this.codeSigning;
    }

    public boolean isEMailProtection() {
        return this.eMailProtection;
    }

    public boolean isTimeStamping() {
        return this.timeStamping;
    }

    public void setKeyAgreement() {
        this.keyAgreement = true;
    }

    public void setEncipherOnly() {
        this.encipherOnly = true;
    }

    public void setDecipherOnly() {
        this.decipherOnly = true;
    }

    public void setKeyEncipherment() {
        this.keyEncipherment = true;
    }

    public void setDataEncipherment() {
        this.dataEncipherment = true;
    }

    public void setDigitalSignature() {
        this.digitalSignature = true;
    }

    public void setNonRepudiation() {
        this.nonRepudiation = true;
    }

    public void setKeyCertSign() {
        this.keyCertSign = true;
    }

    public void setCRLSign() {
        this.cRLSign = true;
    }

    public void setWebServerAuthen() {
        this.webServerAuthen = true;
    }

    public void setWebClientAuthen() {
        this.webClientAuthen = true;
    }

    public void setCodeSigning() {
        this.codeSigning = true;
    }

    public void setEMailProtection() {
        this.eMailProtection = true;
    }

    public void setTimeStamping() {
        this.timeStamping = true;
    }

    public void clearKeyAgreement() {
        this.keyAgreement = false;
    }

    public void clearEncipherOnly() {
        this.encipherOnly = false;
    }

    public void clearDecipherOnly() {
        this.decipherOnly = false;
    }

    public void clearKeyEncipherment() {
        this.keyEncipherment = false;
    }

    public void clearDataEncipherment() {
        this.dataEncipherment = false;
    }

    public void clearDigitalSignature() {
        this.digitalSignature = false;
    }

    public void clearNonRepudiation() {
        this.nonRepudiation = false;
    }

    public void clearKeyCertSign() {
        this.keyCertSign = false;
    }

    public void clearCRLSign() {
        this.cRLSign = false;
    }

    public void clearWebServerAuthen() {
        this.webServerAuthen = false;
    }

    public void clearWebClientAuthen() {
        this.webClientAuthen = false;
    }

    public void clearCodeSigning() {
        this.codeSigning = false;
    }

    public void clearEMailProtection() {
        this.eMailProtection = false;
    }

    public void clearTimeStamping() {
        this.timeStamping = false;
    }

    public void decode(ASN1Object obj) throws CodingException {
        this.keyAgreement = false;
        this.encipherOnly = false;
        this.decipherOnly = false;
        this.keyEncipherment = false;
        this.dataEncipherment = false;
        this.digitalSignature = false;
        this.nonRepudiation = false;
        this.keyCertSign = false;
        this.cRLSign = false;
        this.webServerAuthen = false;
        this.webClientAuthen = false;
        this.codeSigning = false;
        this.eMailProtection = false;
        this.timeStamping = false;
        try {
            Enumeration e2 = ((SEQUENCE)obj).getComponents();
            block18: while (e2.hasMoreElements()) {
                CON_SPEC purpose = (CON_SPEC)e2.nextElement();
                int tag = purpose.getAsnType().getTag();
                BOOLEAN tagValueASN1 = (BOOLEAN)purpose.getValue();
                boolean pProperty = (Boolean)tagValueASN1.getValue();
                switch (tag) {
                    case 0: {
                        this.keyAgreement = pProperty;
                        continue block18;
                    }
                    case 1: {
                        this.encipherOnly = pProperty;
                        continue block18;
                    }
                    case 2: {
                        this.decipherOnly = pProperty;
                        continue block18;
                    }
                    case 3: {
                        this.keyEncipherment = pProperty;
                        continue block18;
                    }
                    case 4: {
                        this.dataEncipherment = pProperty;
                        continue block18;
                    }
                    case 5: {
                        this.digitalSignature = pProperty;
                        continue block18;
                    }
                    case 6: {
                        this.nonRepudiation = pProperty;
                        continue block18;
                    }
                    case 7: {
                        this.keyCertSign = pProperty;
                        continue block18;
                    }
                    case 8: {
                        this.cRLSign = pProperty;
                        continue block18;
                    }
                    case 9: {
                        this.webServerAuthen = pProperty;
                        continue block18;
                    }
                    case 10: {
                        this.webClientAuthen = pProperty;
                        continue block18;
                    }
                    case 11: {
                        this.codeSigning = pProperty;
                        continue block18;
                    }
                    case 12: {
                        this.eMailProtection = pProperty;
                        continue block18;
                    }
                    case 13: {
                        this.timeStamping = pProperty;
                        continue block18;
                    }
                }
                throw new CodingException("Not a PurposeProperties object. ");
            }
        }
        catch (Exception e3) {
            throw new CodingException("Not a PurposeProperties object. ");
        }
    }

    public ASN1Object toASN1Object() {
        CON_SPEC tempCON;
        BOOLEAN tempBOOL;
        SEQUENCE purpProp = new SEQUENCE();
        if (this.keyAgreement) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(0, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.encipherOnly) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(1, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.decipherOnly) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(2, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.keyEncipherment) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(3, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.dataEncipherment) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(4, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.digitalSignature) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(5, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.nonRepudiation) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(6, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.keyCertSign) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(7, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.cRLSign) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(8, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.webServerAuthen) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(9, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.webClientAuthen) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(10, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.codeSigning) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(11, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.eMailProtection) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(12, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        if (this.timeStamping) {
            tempBOOL = new BOOLEAN(true);
            tempCON = new CON_SPEC(13, (ASN1Object)tempBOOL, false);
            purpProp.addComponent((ASN1Object)tempCON);
        }
        return purpProp;
    }
}

