/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.net;

import iaik.x509.X509CRL;
import java.security.cert.CRLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class ReceiveCRLoverLDAP {
    private static final boolean DEBUG = false;
    private String uRLString;
    private String dNString;
    private Vector authorityCRLs;
    private Vector userCRLs;
    private String errorMessage;
    private boolean finished = false;

    public ReceiveCRLoverLDAP(String uRL, String dN) {
        this.uRLString = uRL;
        this.dNString = dN;
    }

    public void go() {
        InitialDirContext ctx = null;
        DirContext subCtx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.uRLString);
            env.put("java.naming.security.authentication", "none");
            ctx = new InitialDirContext(env);
            subCtx = (DirContext)ctx.lookup(this.dNString);
            String[] returningAttributes = new String[]{"certificateRevocationList;binary", "certificateRevocationList", "authorityRevocationList;binary", "authorityRevocationList"};
            Attributes attributes = subCtx.getAttributes("", returningAttributes);
            NamingEnumeration<String> attrEnum = attributes.getIDs();
            this.authorityCRLs = new Vector();
            this.userCRLs = new Vector();
            boolean crl_found = false;
            while (attrEnum.hasMore()) {
                String attributeID = (String)attrEnum.nextElement();
                Attribute attribute = attributes.get(attributeID);
                byte[] crl_encoded = (byte[])attribute.get();
                try {
                    X509CRL crl = new X509CRL(crl_encoded);
                    if (attributeID.startsWith("certificateRevocationList")) {
                        this.userCRLs.addElement(crl);
                        crl_found = true;
                        continue;
                    }
                    this.authorityCRLs.addElement(crl);
                    crl_found = true;
                }
                catch (CRLException cRLException) {}
            }
            if (!crl_found) {
                this.errorMessage = "Directory entry has no CRL attached. ";
            }
            if (ctx != null) {
                ctx.close();
            }
            if (subCtx != null) {
                subCtx.close();
            }
            this.finished = true;
        }
        catch (CommunicationException e2) {
            this.errorMessage = String.valueOf(String.valueOf("Cannot connect to host ").concat(String.valueOf(this.uRLString))).concat(String.valueOf(". "));
            this.finished = true;
        }
        catch (NameNotFoundException e3) {
            this.errorMessage = String.valueOf(String.valueOf(String.valueOf("Cannot find ").concat(String.valueOf(this.dNString))).concat(String.valueOf(" in directory "))).concat(String.valueOf(this.uRLString));
            this.finished = true;
        }
        catch (NamingException e4) {
            this.errorMessage = String.valueOf(String.valueOf("Cannot connect to host ").concat(String.valueOf(this.uRLString))).concat(String.valueOf(". "));
            this.finished = true;
        }
    }

    public boolean done() {
        return this.finished;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public X509CRL getCRL() {
        if (this.userCRLs != null && this.userCRLs.size() > 0) {
            return (X509CRL)this.userCRLs.elementAt(0);
        }
        if (this.authorityCRLs != null && this.authorityCRLs.size() > 0) {
            return (X509CRL)this.authorityCRLs.elementAt(0);
        }
        return null;
    }
}

