/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.net;

import iaik.apps.trustmanager.utils.SwingWorker;
import iaik.x509.X509CRL;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;

public class ReceiveCRLoverHTTP {
    private int lengthOfTask = 100;
    private int current = 0;
    private String statMessage;
    private String uRLString;
    private X509CRL cRL;
    private String malformedURLException_msg;
    private String cRLException_msg;

    public ReceiveCRLoverHTTP(String uRL) {
        this.uRLString = uRL;
    }

    public void go() {
        this.current = 0;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new ActualTask(ReceiveCRLoverHTTP.this);
            }
        };
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.current = this.lengthOfTask;
    }

    public boolean done() {
        return this.current >= this.lengthOfTask;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public String getCRLExceptionMessage() {
        return this.cRLException_msg;
    }

    public String getMalformedURLExceptionMessage() {
        return this.malformedURLException_msg;
    }

    public X509CRL getCRL() {
        return this.cRL;
    }

    class ActualTask {
        ActualTask(ReceiveCRLoverHTTP this$0) {
            while (this$0.current < this$0.lengthOfTask) {
                try {
                    int c2;
                    this$0.statMessage = String.valueOf(String.valueOf("Connecting to ").concat(String.valueOf(this$0.uRLString))).concat(String.valueOf(". "));
                    URL uRL = new URL(this$0.uRLString);
                    URLConnection uRLConnection = uRL.openConnection();
                    int contentLength = uRLConnection.getContentLength();
                    if (contentLength < 1000) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        contentLength = uRLConnection.getContentLength();
                    }
                    this$0.current = 0;
                    this$0.lengthOfTask = contentLength + 1;
                    InputStream inStream = uRLConnection.getInputStream();
                    this$0.statMessage = String.valueOf(String.valueOf("Transferring data from ").concat(String.valueOf(this$0.uRLString))).concat(String.valueOf(". "));
                    byte[] data = new byte[contentLength];
                    this$0.current = 0;
                    while ((c2 = inStream.read()) != -1) {
                        data[((ReceiveCRLoverHTTP)this$0).current] = (byte)c2;
                        ++this$0.current;
                    }
                    inStream.close();
                    this$0.statMessage = "Decoding CRL... ";
                    this$0.cRL = new X509CRL(data);
                    this$0.statMessage = "CRL is now available. ";
                    this$0.current = this$0.lengthOfTask;
                }
                catch (MalformedURLException e2) {
                    this$0.current = this$0.lengthOfTask;
                    this$0.malformedURLException_msg = String.valueOf(String.valueOf("Connecting to ").concat(String.valueOf(this$0.uRLString))).concat(String.valueOf(" failed. "));
                }
                catch (SocketException e3) {
                    this$0.current = this$0.lengthOfTask;
                    this$0.malformedURLException_msg = String.valueOf(String.valueOf("Connecting to ").concat(String.valueOf(this$0.uRLString))).concat(String.valueOf(" failed. "));
                }
                catch (Exception e4) {
                    this$0.current = this$0.lengthOfTask;
                    this$0.cRLException_msg = String.valueOf(String.valueOf("Decoding CRL from ").concat(String.valueOf(this$0.uRLString))).concat(String.valueOf(" failed. "));
                }
            }
        }
    }
}

