/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.ldap;

import iaik.apps.trustmanager.api.Trustmanager;
import iaik.apps.trustmanager.ldap.Utils;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.x509.X509Certificate;
import java.util.Vector;

public class LocalLDAP {
    private Vector errorMessages;
    private Vector certVectors;
    private int arrayLength;
    private int certType;
    private CertificateThread[] threadArray;
    private boolean[] finished;
    private ThreadGroup threadGroup;
    private String[][] localDirs;

    public void establishConnection(int certType) {
        int i;
        this.certType = certType;
        this.errorMessages = new Vector();
        this.certVectors = new Vector();
        this.localDirs = Trustmanager.getLocalDirectories();
        this.arrayLength = this.localDirs.length;
        this.threadArray = new CertificateThread[this.arrayLength];
        this.finished = new boolean[this.arrayLength];
        for (i = 0; i < this.arrayLength; ++i) {
            this.finished[i] = false;
        }
        this.threadGroup = new ThreadGroup("GetCerts");
        for (i = 0; i < this.arrayLength; ++i) {
            this.threadArray[i] = new CertificateThread(this.threadGroup, String.valueOf("thread").concat(String.valueOf(String.valueOf(i))), i);
            this.threadArray[i].start();
        }
    }

    public boolean done() {
        int i;
        for (i = 0; i < this.finished.length && this.finished[i]; ++i) {
        }
        return i == this.finished.length;
    }

    public void stop() {
        this.threadGroup.stop();
    }

    public Vector getCertificates() {
        Vector<X509Certificate> result = new Vector<X509Certificate>();
        for (int i = 0; i < this.certVectors.size(); ++i) {
            Vector tempVector = (Vector)this.certVectors.elementAt(i);
            for (int j = 0; j < tempVector.size(); ++j) {
                X509Certificate cert = (X509Certificate)tempVector.elementAt(j);
                if (this.certType == 3) {
                    result.addElement(cert);
                    continue;
                }
                boolean isCACert = TrustmanagerUtils.isCA(cert);
                if (this.certType == 2 && isCACert) {
                    result.addElement(cert);
                    continue;
                }
                if (this.certType != 1 || isCACert) continue;
                result.addElement(cert);
            }
        }
        return result;
    }

    public Vector getErrorMessages() {
        return this.errorMessages;
    }

    class CertificateThread
    extends Thread {
        private int number;

        public CertificateThread(ThreadGroup group, String str, int number) {
            super(group, str);
            this.number = number;
        }

        public void run() {
            Utils utils = new Utils();
            try {
                String[] localDir = LocalLDAP.this.localDirs[this.number];
                Vector vector = utils.getCertificates(localDir[0], localDir[1], localDir[2], localDir[3].toCharArray(), localDir[4], LocalLDAP.this.certType);
                LocalLDAP.this.certVectors.addElement(vector);
                ((LocalLDAP)LocalLDAP.this).finished[this.number] = true;
            }
            catch (Exception e2) {
                LocalLDAP.this.errorMessages.addElement(e2.getMessage());
                ((LocalLDAP)LocalLDAP.this).finished[this.number] = true;
            }
        }
    }
}

