/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.ldap;

import iaik.apps.trustmanager.utils.X500Utils;
import iaik.utils.InternalErrorException;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPInterface {
    private static final boolean DEBUG = false;
    public static final String NO_AUTHENTICATION = "none";
    public static final String SIMPLE_AUTHENTICATION = "simple";
    public static final String CRAM_MD5_AUTHENTICATION = "CRAM-MD5";
    private DirContext rootCtx = null;
    private DirContext subCtx = null;
    private boolean initialized = false;
    private String initialRootContext = null;
    private String lDAP_URL = null;
    private int countLimit = 20;
    private int timeLimit = 30000;
    private String certAttribute = "userCertificate;binary";
    private String certAttributeNetscape = "userSMIMECertificate;binary";

    public void init(String lDAP_URL, String dN, String userName, char[] password, String version) throws ConfigurationException {
    }

    private void pathFinder_Country(String rDNAttributeValue) {
        try {
            this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("c=").concat(String.valueOf(rDNAttributeValue)));
        }
        catch (NamingException e2) {
            String dn = String.valueOf(String.valueOf("\"c=").concat(String.valueOf(rDNAttributeValue))).concat(String.valueOf("\""));
            BasicAttribute objectClass = new BasicAttribute("objectclass");
            objectClass.add("top");
            objectClass.add("country");
            BasicAttribute at_c = new BasicAttribute("c", rDNAttributeValue);
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(objectClass);
            attrs.put(at_c);
            try {
                this.subCtx.createSubcontext(dn, (Attributes)attrs);
                this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("c=").concat(String.valueOf(rDNAttributeValue)));
            }
            catch (NamingException ex) {
                throw new InternalErrorException(String.valueOf("Writing to LDAP failed: ").concat(String.valueOf(ex.getMessage())));
            }
        }
    }

    private void pathFinder_Organization(String rDNAttributeValue) {
        try {
            this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("o=").concat(String.valueOf(rDNAttributeValue)));
        }
        catch (NamingException e2) {
            String dn = String.valueOf(String.valueOf("\"o=").concat(String.valueOf(rDNAttributeValue))).concat(String.valueOf("\""));
            BasicAttribute objectClass = new BasicAttribute("objectclass");
            objectClass.add("top");
            objectClass.add("organization");
            BasicAttribute at_o = new BasicAttribute("o", rDNAttributeValue);
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(objectClass);
            attrs.put(at_o);
            try {
                this.subCtx.createSubcontext(dn, (Attributes)attrs);
                this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("o=").concat(String.valueOf(rDNAttributeValue)));
            }
            catch (NamingException ex) {
                throw new InternalErrorException(String.valueOf("Writing to LDAP failed: ").concat(String.valueOf(ex.getMessage())));
            }
        }
    }

    private void pathFinder_OrganizationalUnit(String rDNAttributeValue) {
        try {
            this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("ou=").concat(String.valueOf(rDNAttributeValue)));
        }
        catch (NamingException e2) {
            String dn = String.valueOf(String.valueOf("\"ou=").concat(String.valueOf(rDNAttributeValue))).concat(String.valueOf("\""));
            BasicAttribute objectClass = new BasicAttribute("objectclass");
            objectClass.add("top");
            objectClass.add("organizationalUnit");
            BasicAttribute at_ou = new BasicAttribute("ou", rDNAttributeValue);
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(objectClass);
            attrs.put(at_ou);
            try {
                this.subCtx.createSubcontext(dn, (Attributes)attrs);
                this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("ou=").concat(String.valueOf(rDNAttributeValue)));
            }
            catch (NamingException ex) {
                throw new InternalErrorException(String.valueOf("Writing to LDAP failed: ").concat(String.valueOf(ex.getMessage())));
            }
        }
    }

    private void pathFinder_CommonName(String rDNAttributeValue) {
        try {
            this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("cn=").concat(String.valueOf(rDNAttributeValue)));
        }
        catch (NamingException e2) {
            String dn = String.valueOf(String.valueOf("\"cn=").concat(String.valueOf(rDNAttributeValue))).concat(String.valueOf("\""));
            BasicAttribute objectClass = new BasicAttribute("objectclass");
            objectClass.add("top");
            objectClass.add("person");
            BasicAttribute at_cn = new BasicAttribute("cn", rDNAttributeValue);
            BasicAttribute at_sn = new BasicAttribute("sn", rDNAttributeValue);
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(objectClass);
            attrs.put(at_cn);
            attrs.put(at_sn);
            try {
                this.subCtx.createSubcontext(dn, (Attributes)attrs);
                this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf("cn=").concat(String.valueOf(rDNAttributeValue)));
            }
            catch (NamingException ex) {
                throw new InternalErrorException(String.valueOf("Writing to LDAP failed: ").concat(String.valueOf(ex.getMessage())));
            }
        }
    }

    public void putCert(X509Certificate cert) throws NamingException {
        int i;
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server is not initialized. ");
        }
        this.subCtx = this.rootCtx;
        Vector<String> attr = new Vector<String>();
        Vector<String> attrValue = new Vector<String>();
        String[] rdn = X500Utils.getCountry(cert);
        if (rdn != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("c");
                attrValue.addElement(rdn[i]);
            }
        }
        if ((rdn = X500Utils.getOrganization(cert)) != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("o");
                attrValue.addElement(rdn[i]);
            }
        }
        if ((rdn = X500Utils.getOrganizationalUnit(cert)) != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("ou");
                attrValue.addElement(rdn[i]);
            }
        }
        if ((rdn = X500Utils.getCommonName(cert)) != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("cn");
                attrValue.addElement(rdn[i]);
            }
        }
        attr.trimToSize();
        attrValue.trimToSize();
        for (i = 0; i < attr.size() - 1; ++i) {
            if ((String)attr.elementAt(i) == "c") {
                this.pathFinder_Country((String)attrValue.elementAt(i));
            }
            if ((String)attr.elementAt(i) == "o") {
                this.pathFinder_Organization((String)attrValue.elementAt(i));
            }
            if ((String)attr.elementAt(i) == "ou") {
                this.pathFinder_OrganizationalUnit((String)attrValue.elementAt(i));
            }
            if ((String)attr.elementAt(i) != "cn") continue;
            this.pathFinder_CommonName((String)attrValue.elementAt(i));
        }
        String commonName = String.valueOf(String.valueOf((String)attrValue.elementAt(attrValue.size() - 1)).concat(String.valueOf("---id-"))).concat(String.valueOf(cert.getSerialNumber()));
        try {
            this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf(String.valueOf((String)attr.elementAt(attrValue.size() - 1)).concat(String.valueOf("="))).concat(String.valueOf(commonName)));
        }
        catch (NamingException e2) {
            BasicAttribute objectClass = new BasicAttribute("objectclass");
            objectClass.add("top");
            objectClass.add("person");
            objectClass.add("inetOrgPerson");
            BasicAttribute at_cn = new BasicAttribute("cn", (String)attrValue.elementAt(attrValue.size() - 1));
            BasicAttribute at_sn = new BasicAttribute("sn", (String)attrValue.elementAt(attrValue.size() - 1));
            byte[] cert_encoded = null;
            try {
                cert_encoded = cert.getEncoded();
            }
            catch (CertificateEncodingException ex) {
                throw new InternalErrorException(String.valueOf("Could not encode certificate: ").concat(String.valueOf(ex.getMessage())));
            }
            BasicAttribute at_cert = new BasicAttribute("userCertificate;binary", cert_encoded);
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(objectClass);
            attrs.put(at_cn);
            attrs.put(at_sn);
            attrs.put(at_cert);
            String[] email = X500Utils.getEMail(cert);
            if (email != null && email.length > 0) {
                for (i = 0; i < email.length; ++i) {
                    BasicAttribute at_mail = new BasicAttribute("mail", email[i]);
                    attrs.put(at_mail);
                }
            }
            String dn = String.valueOf(String.valueOf(String.valueOf(String.valueOf("\"").concat(String.valueOf((String)attr.elementAt(attrValue.size() - 1)))).concat(String.valueOf("="))).concat(String.valueOf(commonName))).concat(String.valueOf("\""));
            try {
                this.subCtx.createSubcontext(dn, (Attributes)attrs);
                this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf(String.valueOf((String)attr.elementAt(attrValue.size() - 1)).concat(String.valueOf("="))).concat(String.valueOf(commonName)));
            }
            catch (NamingException ex) {
                throw new InternalErrorException(String.valueOf("Writing to LDAP failed: ").concat(String.valueOf(ex.getMessage())));
            }
        }
    }

    public void putCertChain(X509Certificate[] cert) throws NamingException {
        if (cert != null && cert.length > 0) {
            for (int i = 0; i < cert.length; ++i) {
                this.putCert(cert[i]);
            }
        }
    }

    public void setSearchConstraints(int timeLimit, int countLimit) {
        if (timeLimit == 0) {
            this.timeLimit = timeLimit;
        }
        if (countLimit == 0) {
            this.countLimit = countLimit;
        }
    }

    public X509Certificate[] getCertbyEmail(String email, boolean netscapeDirectory) throws NamingException {
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server not is not correctly initialized. ");
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.timeLimit);
        constraints.setCountLimit(this.countLimit);
        if (netscapeDirectory) {
            constraints.setReturningAttributes(new String[]{this.certAttributeNetscape});
        } else {
            constraints.setReturningAttributes(new String[]{this.certAttribute});
        }
        email = email.trim();
        String filter = String.valueOf(String.valueOf("(mail=").concat(String.valueOf(email))).concat(String.valueOf(")"));
        Vector<X509Certificate> certVector = new Vector<X509Certificate>();
        try {
            NamingEnumeration<SearchResult> results = this.rootCtx.search(this.initialRootContext, filter, constraints);
            while (results.hasMore()) {
                SearchResult si = results.next();
                Attributes attributes = si.getAttributes();
                Attribute attribute = netscapeDirectory ? attributes.get(this.certAttributeNetscape) : attributes.get(this.certAttribute);
                NamingEnumeration<?> aCert = attribute.getAll();
                while (aCert.hasMoreElements()) {
                    certVector.addElement(new X509Certificate((byte[])aCert.nextElement()));
                }
            }
        }
        catch (NamingException e1) {
            if (certVector.size() == 0) {
                X509Certificate[] si = null;
                return si;
            }
        }
        catch (CertificateException e2) {
            throw new InternalErrorException("Could not decode received certificate. ");
        }
        if (certVector.size() == 0) {
            return null;
        }
        int size = certVector.size();
        X509Certificate[] certArray = new X509Certificate[size];
        for (int i = 0; i < size; ++i) {
            certArray[i] = (X509Certificate)certVector.elementAt(i);
        }
        return certArray;
    }

    public X509CRL[] getCRLbyCN(String crl) throws NamingException {
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server not is not correctly initialized. ");
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.timeLimit);
        constraints.setCountLimit(this.countLimit);
        constraints.setReturningAttributes(new String[]{"certificateRevocationList;binary"});
        crl = crl.trim();
        String filter = String.valueOf(String.valueOf("(cn=").concat(String.valueOf(crl))).concat(String.valueOf(")"));
        Vector<X509CRL> cRLVector = new Vector<X509CRL>();
        try {
            NamingEnumeration<SearchResult> results = this.rootCtx.search(this.initialRootContext, filter, constraints);
            while (results.hasMore()) {
                SearchResult si = results.next();
                Attributes attributes = si.getAttributes();
                Attribute attribute = attributes.get("certificateRevocationList;binary");
                NamingEnumeration<?> aCRL = attribute.getAll();
                while (aCRL.hasMoreElements()) {
                    cRLVector.addElement(new X509CRL((byte[])aCRL.nextElement()));
                }
            }
        }
        catch (NamingException e1) {
            if (cRLVector.size() == 0) {
                X509CRL[] si = null;
                return si;
            }
        }
        catch (CRLException e2) {
            throw new InternalErrorException("Could not decode received certificate. ");
        }
        if (cRLVector.size() == 0) {
            return null;
        }
        int size = cRLVector.size();
        X509CRL[] certArray = new X509CRL[size];
        for (int i = 0; i < size; ++i) {
            certArray[i] = (X509CRL)cRLVector.elementAt(i);
        }
        return certArray;
    }

    public X509CRL[] getCRL() throws NamingException {
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server not is not correctly initialized. ");
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.timeLimit);
        constraints.setCountLimit(this.countLimit);
        constraints.setReturningAttributes(new String[]{"certificateRevocationList;binary"});
        String filter = "(certificateRevocationList=*)";
        Vector<X509CRL> cRLVector = new Vector<X509CRL>();
        try {
            NamingEnumeration<SearchResult> results = this.rootCtx.search(this.initialRootContext, filter, constraints);
            while (results.hasMore()) {
                SearchResult si = results.next();
                Attributes attributes = si.getAttributes();
                Attribute attribute = attributes.get("certificateRevocationList;binary");
                NamingEnumeration<?> aCRL = attribute.getAll();
                while (aCRL.hasMoreElements()) {
                    cRLVector.addElement(new X509CRL((byte[])aCRL.nextElement()));
                }
            }
        }
        catch (NamingException e1) {
            if (cRLVector.size() == 0) {
                X509CRL[] si = null;
                return si;
            }
        }
        catch (CRLException e2) {
            throw new InternalErrorException("Could not decode received certificate. ");
        }
        if (cRLVector.size() == 0) {
            return null;
        }
        int size = cRLVector.size();
        X509CRL[] certArray = new X509CRL[size];
        for (int i = 0; i < size; ++i) {
            certArray[i] = (X509CRL)cRLVector.elementAt(i);
        }
        return certArray;
    }

    public X509Certificate[] getCert() throws NamingException {
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server not is not correctly initialized. ");
        }
        DirContext schema = this.rootCtx.getSchema("dc=verisign, dc=com");
        NamingEnumeration<NameClassPair> namingEnumeration = this.rootCtx.list("dc=verisign, dc=com");
        while (namingEnumeration.hasMoreElements()) {
            System.out.println(namingEnumeration.nextElement());
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.timeLimit);
        constraints.setCountLimit(this.countLimit);
        constraints.setReturningAttributes(new String[0]);
        String filter = "(userSMIMECertificate;binary=*)";
        Vector<X509Certificate> certVector = new Vector<X509Certificate>();
        try {
            NamingEnumeration<SearchResult> results = this.rootCtx.search(this.initialRootContext, filter, constraints);
            while (results.hasMore()) {
                SearchResult si = results.next();
                Attributes attributes = si.getAttributes();
                Attribute attribute = attributes.get("certAttributeNetscape;binary");
                NamingEnumeration<?> aCert = attribute.getAll();
                while (aCert.hasMoreElements()) {
                    certVector.addElement(new X509Certificate((byte[])aCert.nextElement()));
                }
            }
        }
        catch (NamingException e1) {
            if (certVector.size() == 0) {
                X509Certificate[] si = null;
                return si;
            }
        }
        catch (CertificateException e2) {
            throw new InternalErrorException("Could not decode received certificate. ");
        }
        if (certVector.size() == 0) {
            return null;
        }
        int size = certVector.size();
        X509Certificate[] certArray = new X509Certificate[size];
        for (int i = 0; i < size; ++i) {
            certArray[i] = (X509Certificate)certVector.elementAt(i);
        }
        return certArray;
    }

    public X509Certificate[] getCertbyCN(String cn, boolean netscapeDirectory) throws NamingException {
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server not is not correctly initialized. ");
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setTimeLimit(this.timeLimit);
        constraints.setCountLimit(this.countLimit);
        if (netscapeDirectory) {
            constraints.setReturningAttributes(new String[]{this.certAttributeNetscape});
        } else {
            constraints.setReturningAttributes(new String[]{this.certAttribute});
        }
        cn = cn.trim();
        String filter = String.valueOf(String.valueOf("(cn=").concat(String.valueOf(cn))).concat(String.valueOf(")"));
        Vector<X509Certificate> certVector = new Vector<X509Certificate>();
        try {
            NamingEnumeration<SearchResult> results = this.rootCtx.search(this.initialRootContext, filter, constraints);
            while (results.hasMore()) {
                SearchResult si = results.next();
                Attributes attributes = si.getAttributes();
                Attribute attribute = attributes.get(this.certAttribute);
                NamingEnumeration<?> aCert = attribute.getAll();
                while (aCert.hasMoreElements()) {
                    certVector.addElement(new X509Certificate((byte[])aCert.nextElement()));
                }
            }
        }
        catch (NamingException e1) {
            if (certVector.size() == 0) {
                X509Certificate[] si = null;
                return si;
            }
        }
        catch (CertificateException e2) {
            throw new InternalErrorException("Could not decode received certificate. ");
        }
        if (certVector.size() == 0) {
            return null;
        }
        int size = certVector.size();
        X509Certificate[] certArray = new X509Certificate[size];
        for (int i = 0; i < size; ++i) {
            certArray[i] = (X509Certificate)certVector.elementAt(i);
        }
        return certArray;
    }

    public void removeCert(X509Certificate cert) throws NamingException {
        int i;
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server not is not correctly initialized. ");
        }
        this.subCtx = this.rootCtx;
        Vector<String> attr = new Vector<String>();
        Vector<String> attrValue = new Vector<String>();
        Vector<DirContext> ctxArray = new Vector<DirContext>();
        String[] rdn = X500Utils.getCountry(cert);
        if (rdn != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("c");
                attrValue.addElement(rdn[i]);
            }
        }
        if ((rdn = X500Utils.getOrganization(cert)) != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("o");
                attrValue.addElement(rdn[i]);
            }
        }
        if ((rdn = X500Utils.getOrganizationalUnit(cert)) != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("ou");
                attrValue.addElement(rdn[i]);
            }
        }
        if ((rdn = X500Utils.getCommonName(cert)) != null) {
            for (i = 0; i < rdn.length; ++i) {
                attr.addElement("cn");
                attrValue.addElement(rdn[i]);
            }
        }
        attr.trimToSize();
        attrValue.trimToSize();
        boolean cert_present = true;
        Object ctx = null;
        for (i = 0; i < attr.size() - 1; ++i) {
            try {
                ctxArray.addElement(this.subCtx);
                this.subCtx = (DirContext)this.subCtx.lookup(String.valueOf(String.valueOf((String)attr.elementAt(i)).concat(String.valueOf("="))).concat(String.valueOf((String)attrValue.elementAt(i))));
                continue;
            }
            catch (NamingException e2) {
                cert_present = false;
            }
        }
        String subContextName = String.valueOf(String.valueOf(String.valueOf(String.valueOf((String)attr.elementAt(i)).concat(String.valueOf("="))).concat(String.valueOf((String)attrValue.elementAt(i)))).concat(String.valueOf("---id-"))).concat(String.valueOf(cert.getSerialNumber()));
        if (cert_present) {
            try {
                ctxArray.addElement(this.subCtx);
                this.subCtx = (DirContext)this.subCtx.lookup(subContextName);
            }
            catch (NamingException e3) {
                cert_present = false;
            }
        }
        if (cert_present) {
            try {
                ((DirContext)ctxArray.elementAt(ctxArray.size() - 1)).destroySubcontext(subContextName);
            }
            catch (NamingException ex) {
                throw new InternalErrorException(String.valueOf("Removing LDAP entry failed: ").concat(String.valueOf(ex.getMessage())));
            }
        }
        for (i = ctxArray.size() - 1; i > 0; --i) {
            NamingEnumeration<NameClassPair> nEnum = ((DirContext)ctxArray.elementAt(i)).list("");
            if (nEnum.hasMoreElements()) continue;
            ((DirContext)ctxArray.elementAt(i - 1)).destroySubcontext(String.valueOf(String.valueOf(attr.elementAt(i - 1)).concat(String.valueOf("="))).concat(String.valueOf(attrValue.elementAt(i - 1))));
        }
    }

    public void putUserCert(X509Certificate cert, boolean netscapeDirectory) throws NamingException {
        if (!this.initialized) {
            throw new ConfigurationException("Connection to LDAP-Server is not initialized. ");
        }
        String[] commonName = X500Utils.getCommonName(cert);
        String[] array = X500Utils.splitCommonName(commonName[0]);
        String surName = array[1];
        String[] mails = X500Utils.getEMail(cert);
        byte[] cert_encoded = null;
        try {
            cert_encoded = cert.getEncoded();
        }
        catch (CertificateEncodingException ex) {
            throw new InternalErrorException(String.valueOf("Could not encode certificate: ").concat(String.valueOf(ex.getMessage())));
        }
        BasicAttribute objectClass = new BasicAttribute("objectclass");
        objectClass.add("top");
        objectClass.add("person");
        objectClass.add("inetOrgPerson");
        BasicAttribute at_cn = new BasicAttribute("cn", commonName[0]);
        BasicAttribute at_sn = new BasicAttribute("sn", surName);
        BasicAttribute at_cert = netscapeDirectory ? new BasicAttribute(this.certAttributeNetscape, cert_encoded) : new BasicAttribute(this.certAttribute, cert_encoded);
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(objectClass);
        attrs.put(at_cn);
        attrs.put(at_sn);
        attrs.put(at_cert);
        if (mails != null && mails.length > 0) {
            for (int i = 0; i < mails.length; ++i) {
                BasicAttribute at_mail = new BasicAttribute("mail", mails[i]);
                attrs.put(at_mail);
            }
        }
        String dn = String.valueOf(String.valueOf(String.valueOf("cn=").concat(String.valueOf(commonName[0]))).concat(String.valueOf(", "))).concat(String.valueOf(this.initialRootContext));
        dn = String.valueOf(String.valueOf("\"").concat(String.valueOf(dn))).concat(String.valueOf("\""));
        try {
            this.rootCtx.createSubcontext(dn, (Attributes)attrs);
        }
        catch (NamingException ex) {
            throw new InternalErrorException(String.valueOf("Writing to LDAP failed: ").concat(String.valueOf(ex.getMessage())));
        }
    }

    public void close() throws NamingException {
        if (this.subCtx != null) {
            this.subCtx.close();
        }
        if (this.rootCtx != null) {
            this.rootCtx.close();
        }
    }
}

