/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.ldap;

import iaik.apps.trustmanager.api.Trustmanager;
import iaik.apps.trustmanager.ldap.Utils;
import iaik.x509.X509Certificate;
import java.util.Vector;

public class GlobalLDAP {
    private Vector errorMessages;
    private Vector certVectors;
    private int arrayLength;
    private CertificateThread[] threadArray;
    private boolean[] finished;
    private ThreadGroup threadGroup;
    private String searchString;
    private int certType;
    private int timeLimit;
    private int countLimit;
    private String[][] globalDirs;

    public void establishConnection(String searchString, int certType, int timeLimit, int countLimit) {
        int i;
        this.searchString = searchString;
        this.certType = certType;
        this.timeLimit = timeLimit;
        this.countLimit = countLimit;
        this.errorMessages = new Vector();
        this.certVectors = new Vector();
        this.globalDirs = Trustmanager.getGlobalDirectories();
        this.arrayLength = this.globalDirs.length;
        this.threadArray = new CertificateThread[this.arrayLength];
        this.finished = new boolean[this.arrayLength];
        for (i = 0; i < this.arrayLength; ++i) {
            this.finished[i] = false;
        }
        this.threadGroup = new ThreadGroup("SearchCerts");
        for (i = 0; i < this.arrayLength; ++i) {
            this.threadArray[i] = new CertificateThread(this.threadGroup, String.valueOf("thread").concat(String.valueOf(String.valueOf(i))), i);
            this.threadArray[i].start();
        }
    }

    public boolean done() {
        int i;
        for (i = 0; i < this.finished.length && this.finished[i]; ++i) {
        }
        return i == this.finished.length;
    }

    public void stop() {
        this.threadGroup.stop();
    }

    public Vector getCertificates() {
        Vector<X509Certificate> result = new Vector<X509Certificate>();
        for (int i = 0; i < this.certVectors.size(); ++i) {
            Vector tempVector = (Vector)this.certVectors.elementAt(i);
            for (int j = 0; j < tempVector.size(); ++j) {
                result.addElement((X509Certificate)tempVector.elementAt(j));
            }
        }
        return result;
    }

    public Vector getErrorMessages() {
        return this.errorMessages;
    }

    class CertificateThread
    extends Thread {
        private int number;

        public CertificateThread(ThreadGroup group, String str, int number) {
            super(group, str);
            this.number = number;
        }

        public void run() {
            Utils utils = new Utils();
            try {
                String[] localDir = GlobalLDAP.this.globalDirs[this.number];
                Vector vector = utils.searchCertificates(localDir[0], localDir[1], localDir[2], localDir[3].toCharArray(), localDir[4], GlobalLDAP.this.searchString, GlobalLDAP.this.certType, GlobalLDAP.this.countLimit, GlobalLDAP.this.timeLimit);
                GlobalLDAP.this.certVectors.addElement(vector);
                ((GlobalLDAP)GlobalLDAP.this).finished[this.number] = true;
            }
            catch (Exception e2) {
                GlobalLDAP.this.errorMessages.addElement(e2.getMessage());
                ((GlobalLDAP)GlobalLDAP.this).finished[this.number] = true;
            }
        }
    }
}

