/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.crl;

import iaik.apps.trustmanager.crl.CRLDistributionPoint;
import iaik.apps.trustmanager.time.TrustedTime;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.DistributionPoint;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.CRLDistributionPoints;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;

public class CRLUtils {
    private static final boolean DEBUG = false;

    public static CRLDistributionPoint getCertificatesCRLDistributionPoint(X509Certificate cert) {
        int reasonFlags;
        CRLDistributionPoints extension = null;
        try {
            extension = (CRLDistributionPoints)cert.getExtension(CRLDistributionPoints.oid);
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            // empty catch block
        }
        if (extension == null) {
            return null;
        }
        Enumeration enumeration = extension.getDistributionPoints();
        DistributionPoint distributionPoint = (DistributionPoint)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            // empty if block
        }
        if ((reasonFlags = distributionPoint.getReasonFlags()) != -1) {
            throw new InternalErrorException("The certificate's CRL distribution point extension uses ReasonFlags which can't be processed by Trustmanager. Please reject the certificate and contact http://www.iaik.at ");
        }
        CRLDistributionPoint cRLDistributionPoint = new CRLDistributionPoint();
        GeneralNames cRLIssuers = distributionPoint.getCrlIssuer();
        if (cRLIssuers != null) {
            Name cRLIssuerDN;
            Enumeration enum2 = cRLIssuers.getNames();
            GeneralName cRLIssuer = (GeneralName)enum2.nextElement();
            if (enum2.hasMoreElements()) {
                // empty if block
            }
            cRLDistributionPoint.issuer = cRLIssuerDN = (Name)cRLIssuer.getName();
        }
        try {
            ASN1Type asn1Type = distributionPoint.getDistributionPointName();
            SEQUENCE sequence = (SEQUENCE)asn1Type.toASN1Object();
            CON_SPEC con_spec = (CON_SPEC)sequence.getComponentAt(0);
            int tag = con_spec.getAsnType().getTag();
            ASN1Object asn1Object = con_spec.getComponentAt(0);
            if (tag == GeneralName.directoryName) {
                Name distName = new Name(asn1Object);
                cRLDistributionPoint.dN = distName.toString();
            } else if (tag == GeneralName.uniformResourceIdentifier) {
                if (asn1Object instanceof OCTET_STRING) {
                    cRLDistributionPoint.hTTP_URL = new String((byte[])((OCTET_STRING)asn1Object).getValue());
                } else if (asn1Object instanceof IA5String) {
                    cRLDistributionPoint.hTTP_URL = ((IA5String)asn1Object).toString();
                }
            }
        }
        catch (CodingException e2) {
            CRLDistributionPoint cRLDistributionPoint2 = null;
            return cRLDistributionPoint2;
        }
        return cRLDistributionPoint;
    }

    public static String makeIssuerFingerprint(Name issuer) {
        try {
            String fp;
            MessageDigest md = MessageDigest.getInstance("MD5", "IAIK");
            String string = fp = TrustmanagerUtils.Base16Encode(md.digest(issuer.getEncoded()));
            return string;
        }
        catch (Exception e2) {
            throw new InternalErrorException(e2.getMessage());
        }
    }

    public static boolean isUptoDate(X509CRL crl) {
        Date crlDate = crl.getNextUpdate();
        Date currentDate = TrustedTime.getCurrentTime();
        return currentDate.getTime() < crlDate.getTime();
    }
}

