/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.crl;

import iaik.apps.trustmanager.api.TrustEnv;
import iaik.apps.trustmanager.crl.CRLException;
import iaik.apps.trustmanager.crl.CRLUtils;
import iaik.apps.trustmanager.time.TrustedTime;
import iaik.asn1.ASN1Object;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.RevokedCertificate;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class CRLStore {
    private static final boolean DEBUG = false;
    private static boolean initialized = false;

    private X509CRL readCRL(Name issuer) throws CRLException, IOException {
        String fileName = CRLUtils.makeIssuerFingerprint(issuer);
        fileName = String.valueOf(String.valueOf("crl").concat(String.valueOf(fileName))).concat(String.valueOf(".dat"));
        File file = new File(String.valueOf(TrustEnv.cRLDirectory).concat(String.valueOf(fileName)));
        if (file.isFile() && file.canRead()) {
            FileInputStream inStream = new FileInputStream(file);
            try {
                X509CRL x509CRL = new X509CRL((InputStream)inStream);
                return x509CRL;
            }
            catch (java.security.cert.CRLException e2) {
                throw new CRLException(e2.getMessage());
            }
        }
        return null;
    }

    public void init() throws IOException {
        File file = new File(TrustEnv.cRLDirectory);
        try {
            if (!file.isDirectory() || !file.canWrite()) {
                throw new IOException("Cannot access CRL-store's directory. ");
            }
            initialized = true;
        }
        catch (SecurityException e2) {
            throw new IOException("Cannot access CRL-store's directory. ");
        }
    }

    public void putCRL(X509CRL crl) throws IOException {
        if (!initialized) {
            throw new InternalErrorException("CRL store is not initialized. ");
        }
        Name issuer = (Name)crl.getIssuerDN();
        String fileString = CRLUtils.makeIssuerFingerprint(issuer);
        fileString = String.valueOf(String.valueOf("crl").concat(String.valueOf(fileString))).concat(String.valueOf(".dat"));
        File fileName = new File(String.valueOf(TrustEnv.cRLDirectory).concat(String.valueOf(fileString)));
        X509CRL presentCRL = null;
        if (fileName.exists() && crl.getNextUpdate().getTime() < TrustedTime.getCurrentTime().getTime()) {
            FileInputStream inStream = new FileInputStream(fileName);
            try {
                presentCRL = new X509CRL((InputStream)inStream);
            }
            catch (Exception e2) {
                throw new IOException("Could not read already present CRL. ");
            }
            Name presentIssuer = (Name)presentCRL.getIssuerDN();
            Date presentDate = presentCRL.getThisUpdate();
            Date date = crl.getThisUpdate();
            if (presentDate.after(date)) {
                crl = presentCRL;
            }
            inStream.close();
            fileName.delete();
        }
        FileOutputStream outStream = new FileOutputStream(fileName);
        crl.writeTo((OutputStream)outStream);
        outStream.close();
    }

    public int containsCRL(X509Certificate cert, Date date) throws IOException, CRLException {
        if (!initialized) {
            throw new InternalErrorException("CRL store is not initialized. ");
        }
        if (cert == null || date == null) {
            throw new CRLException("Certificate and date must be specified. ");
        }
        Name issuer = (Name)cert.getIssuerDN();
        X509CRL crl = this.readCRL(issuer);
        if (crl != null) {
            Date crlDate = crl.getNextUpdate();
            if (date.before(crlDate)) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public boolean isRevoked(X509Certificate cert, Date date) throws IOException, CRLException {
        if (!initialized) {
            throw new InternalErrorException("CRL store is not initialized. ");
        }
        if (cert == null || date == null) {
            throw new CRLException("Certificate and date must be specified. ");
        }
        X509CRL crl = this.readCRL((Name)cert.getIssuerDN());
        if (crl == null) {
            throw new CRLException("No CRL available for this certificate. ");
        }
        Date crlDate = crl.getNextUpdate();
        if (crlDate != null && crlDate.before(date)) {
            throw new CRLException("No up-to-date CRL available");
        }
        RevokedCertificate revokedCert = crl.containsCertificate(cert);
        return revokedCert != null;
    }

    public Date getNextCRLUpdate(X509Certificate cert) throws CRLException, IOException {
        if (!initialized) {
            throw new InternalErrorException("CRL store is not initialized. ");
        }
        if (cert == null) {
            throw new CRLException("Certificate must be specified. ");
        }
        X509CRL crl = this.readCRL((Name)cert.getIssuerDN());
        if (crl == null) {
            throw new CRLException("No CRL available. ");
        }
        return crl.getNextUpdate();
    }

    public Date getExpiration(X509Certificate cert) throws IOException, CRLException {
        if (!initialized) {
            throw new InternalErrorException("CRL store is not initialized. ");
        }
        X509CRL crl = this.readCRL((Name)cert.getIssuerDN());
        if (crl == null) {
            throw new CRLException("No CRL available. ");
        }
        RevokedCertificate rCert = crl.containsCertificate(cert);
        if (rCert == null) {
            return cert.getNotAfter();
        }
        Date rDate = rCert.getRevocationDate();
        ObjectID iDateOID = new ObjectID("2.5.29.24", "invalidityDate");
        ASN1Object time = null;
        ChoiceOfTime timeObject = null;
        try {
            V3Extension extension = rCert.getExtension(iDateOID);
            time = extension.toASN1Object();
            timeObject = new ChoiceOfTime(time);
        }
        catch (Exception e2) {
            throw new CRLException("Could not parse invalidityDate CRLEntryExtension. ");
        }
        Date iDate = timeObject.getDate();
        if (iDate != null) {
            return iDate;
        }
        return rDate;
    }

    public X509CRL getCRL(X509Certificate cACertificate) throws IOException {
        X509CRL crl = null;
        try {
            crl = this.readCRL((Name)cACertificate.getSubjectDN());
        }
        catch (CRLException e2) {
            throw new IOException("Cannot decode CRL. ");
        }
        if (crl != null) {
            try {
                crl.verify(cACertificate.getPublicKey(), "IAIK");
            }
            catch (Exception e3) {
                throw new InternalErrorException(e3.getMessage());
            }
            return crl;
        }
        return null;
    }
}

