/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.crl;

import iaik.apps.trustmanager.api.TrustEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class CRLDictionary {
    public static Hashtable table_LDAP_issuer;
    public static Hashtable table_DN_issuer;
    public static Hashtable table_HTTP_issuer;
    public static Hashtable table_issuer_LDAP;
    public static Hashtable table_issuer_HTTP;
    public static Hashtable table_issuer_DN;

    public CRLDictionary() {
        table_LDAP_issuer = new Hashtable();
        table_DN_issuer = new Hashtable();
        table_HTTP_issuer = new Hashtable();
        table_issuer_LDAP = new Hashtable();
        table_issuer_HTTP = new Hashtable();
        table_issuer_DN = new Hashtable();
    }

    public void load() throws IOException {
        FileInputStream stream = new FileInputStream(new File(TrustEnv.cRLFile));
        ObjectInputStream in = new ObjectInputStream(stream);
        try {
            table_LDAP_issuer = (Hashtable)in.readObject();
            table_DN_issuer = (Hashtable)in.readObject();
            table_HTTP_issuer = (Hashtable)in.readObject();
            table_issuer_LDAP = (Hashtable)in.readObject();
            table_issuer_HTTP = (Hashtable)in.readObject();
            table_issuer_DN = (Hashtable)in.readObject();
        }
        catch (ClassNotFoundException e2) {
            throw new IOException("Cannot innitialize CRLManager. ");
        }
        in.close();
    }

    public void store() throws IOException {
        String backupFileName = TrustEnv.cRLFile;
        backupFileName = backupFileName.substring(0, backupFileName.length() - 1);
        backupFileName = String.valueOf(backupFileName).concat(String.valueOf("~"));
        File backupFile = new File(backupFileName);
        backupFile.delete();
        File cRLFile = new File(TrustEnv.cRLFile);
        cRLFile.renameTo(backupFile);
        FileOutputStream outStream = new FileOutputStream(cRLFile);
        ObjectOutputStream out = new ObjectOutputStream(outStream);
        out.writeObject(table_LDAP_issuer);
        out.writeObject(table_DN_issuer);
        out.writeObject(table_HTTP_issuer);
        out.writeObject(table_issuer_LDAP);
        out.writeObject(table_issuer_HTTP);
        out.writeObject(table_issuer_DN);
        out.flush();
        out.close();
    }
}

