/*
 * Decompiled with CFR 0.152.
 */
package iaik.apps.trustmanager.cert;

import iaik.apps.trustmanager.api.TrustEnv;
import iaik.apps.trustmanager.utils.TrustmanagerUtils;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.SubjectAltName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CertStore {
    private static Hashtable hashtable = new Hashtable();
    private static final boolean DEBUG = false;

    private static String[] makeAlias(X509Certificate cert) {
        String[] aliases;
        block20: {
            if (TrustmanagerUtils.isCA(cert)) {
                Name subject = (Name)cert.getSubjectDN();
                byte[] subjectArray = null;
                if (subject == null) {
                    throw new InternalErrorException("CA certificate contains an empty subject field. ");
                }
                subjectArray = subject.getEncoded();
                String[] alias_Array = new String[]{TrustmanagerUtils.byteArrayToString(subjectArray)};
                return alias_Array;
            }
            String[] emails = null;
            Name subject = (Name)cert.getSubjectDN();
            if (subject != null) {
                emails = subject.getRDNs(ObjectID.emailAddress);
            }
            if (emails == null) {
                emails = new String[]{};
            }
            Vector<Object> emailVector = new Vector<Object>();
            try {
                SubjectAltName subjectalt = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
                if (subjectalt != null) {
                    GeneralNames generalNames = subjectalt.getGeneralNames();
                    Enumeration e2 = generalNames.getNames();
                    while (e2.hasMoreElements()) {
                        GeneralName generalName = (GeneralName)e2.nextElement();
                        if (generalName.getType() != GeneralName.rfc822Name) continue;
                        emailVector.addElement(generalName.getName());
                    }
                }
            }
            catch (X509ExtensionInitException subjectalt) {
                // empty catch block
            }
            emailVector.trimToSize();
            subject = (Name)cert.getSubjectDN();
            byte[] subjectArray = null;
            if (subject != null) {
                subjectArray = subject.getEncoded();
            }
            SubjectAltName subjectAlt = null;
            try {
                subjectAlt = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
            }
            catch (X509ExtensionInitException e2) {
                // empty catch block
            }
            byte[] subjectAltArray = null;
            if (subjectAlt != null) {
                ASN1Object subjectAltASN1 = null;
                try {
                    subjectAltASN1 = subjectAlt.toASN1Object();
                }
                catch (X509ExtensionException e3) {
                    throw new InternalErrorException(e3.getMessage());
                }
                subjectAltArray = DerCoder.encode((ASN1Object)subjectAltASN1);
            }
            for (int i = 0; i < emails.length; ++i) {
                emails[i] = emails[i].toLowerCase();
                emails[i] = emails[i].trim();
            }
            for (int j = 0; j < emailVector.size(); ++j) {
                String tempString = ((String)emailVector.elementAt(j)).toLowerCase();
                tempString = tempString.trim();
                emailVector.setElementAt(tempString, j);
            }
            int aliasCount = emails.length + emailVector.size();
            if (subjectArray != null) {
                ++aliasCount;
            }
            if (subjectAltArray != null) {
                ++aliasCount;
            }
            aliases = new String[aliasCount];
            System.arraycopy(emails, 0, aliases, 0, emails.length);
            for (int k = emails.length; k < emails.length + emailVector.size(); ++k) {
                aliases[k] = (String)emailVector.elementAt(k - emails.length);
            }
            if (subjectArray != null) {
                aliases[emails.length + emailVector.size()] = TrustmanagerUtils.byteArrayToString(subjectArray);
            }
            if (subjectAltArray == null) break block20;
            aliases[aliases.length - 1] = TrustmanagerUtils.byteArrayToString(subjectAltArray);
        }
        return aliases;
    }

    private static X509Certificate[] getCerts(String alias) {
        Vector certVector = (Vector)hashtable.get(alias);
        if (certVector != null) {
            X509Certificate[] certArray = new X509Certificate[certVector.size()];
            for (int i = 0; i < certArray.length; ++i) {
                certArray[i] = (X509Certificate)certVector.elementAt(i);
            }
            return certArray;
        }
        return new X509Certificate[0];
    }

    public static boolean containsCertificate(String emailaddress) {
        if (emailaddress == null) {
            return false;
        }
        emailaddress = emailaddress.trim();
        emailaddress = emailaddress.toLowerCase();
        return hashtable.containsKey(emailaddress);
    }

    public static boolean containsCertificate(Name subject) {
        if (subject == null) {
            return false;
        }
        byte[] subject_Array = subject.getEncoded();
        return hashtable.containsKey(TrustmanagerUtils.byteArrayToString(subject_Array));
    }

    public static boolean containsCertificate(SubjectAltName subjectAltName) {
        if (subjectAltName == null) {
            return false;
        }
        ASN1Object subjectAltNameASN1 = null;
        try {
            subjectAltNameASN1 = subjectAltName.toASN1Object();
        }
        catch (X509ExtensionException e2) {
            throw new InternalErrorException(e2.getMessage());
        }
        byte[] subjectAlt_Array = DerCoder.encode((ASN1Object)subjectAltNameASN1);
        return hashtable.containsKey(TrustmanagerUtils.byteArrayToString(subjectAlt_Array));
    }

    public static X509Certificate[] getCertificates(String emailaddress) {
        if (emailaddress == null) {
            return new X509Certificate[0];
        }
        emailaddress = emailaddress.trim();
        emailaddress = emailaddress.toLowerCase();
        return CertStore.getCerts(emailaddress);
    }

    public static X509Certificate[] getCertificates(Name subject) {
        if (subject == null) {
            return null;
        }
        byte[] subjectArray = subject.getEncoded();
        String alias = TrustmanagerUtils.byteArrayToString(subjectArray);
        return CertStore.getCerts(alias);
    }

    public static X509Certificate[] getCertificates(SubjectAltName subjectAlt) {
        if (subjectAlt == null) {
            return new X509Certificate[0];
        }
        ASN1Object subjectAltASN1 = null;
        try {
            subjectAltASN1 = subjectAlt.toASN1Object();
        }
        catch (X509ExtensionException e2) {
            throw new InternalErrorException(e2.getMessage());
        }
        byte[] subjectAltArray = DerCoder.encode((ASN1Object)subjectAltASN1);
        String alias = TrustmanagerUtils.byteArrayToString(subjectAltArray);
        return CertStore.getCerts(alias);
    }

    public static void putCertificate(X509Certificate cert) {
        if (cert != null) {
            byte[] cert_DER = null;
            try {
                cert_DER = cert.getEncoded();
            }
            catch (CertificateEncodingException e2) {
                throw new InternalErrorException("Could not DER encode certificate. ");
            }
            String[] aliasArray = CertStore.makeAlias(cert);
            for (int i = 0; i < aliasArray.length; ++i) {
                Vector vect = (Vector)hashtable.get(aliasArray[i]);
                if (vect != null) {
                    boolean finished = false;
                    int certCounter = 0;
                    while (!finished && certCounter < vect.size()) {
                        X509Certificate certTemp = (X509Certificate)vect.elementAt(certCounter);
                        try {
                            if (CryptoUtils.equalsBlock((byte[])certTemp.getEncoded(), (byte[])cert_DER)) {
                                finished = true;
                                continue;
                            }
                            ++certCounter;
                        }
                        catch (CertificateEncodingException e3) {
                            throw new InternalErrorException("Could not DER encode certificate. ");
                        }
                    }
                    if (finished) continue;
                    vect.addElement(cert);
                    hashtable.put(aliasArray[i], vect);
                    continue;
                }
                Vector<X509Certificate> newRecord = new Vector<X509Certificate>();
                newRecord.addElement(cert);
                hashtable.put(aliasArray[i], newRecord);
            }
        }
    }

    public static void putCertificateChain(X509Certificate[] certArray) {
        if (certArray != null) {
            for (int j = 0; j < certArray.length; ++j) {
                CertStore.putCertificate(certArray[j]);
            }
        }
    }

    public static int size() {
        Hashtable<String, X509Certificate> temp = new Hashtable<String, X509Certificate>();
        Enumeration e2 = hashtable.elements();
        while (e2.hasMoreElements()) {
            Vector certVector = (Vector)e2.nextElement();
            for (int i = 0; i < certVector.size(); ++i) {
                X509Certificate cert = (X509Certificate)certVector.elementAt(i);
                String alias = TrustmanagerUtils.byteArrayToString(TrustmanagerUtils.makeCertHash(cert));
                temp.put(alias, cert);
            }
        }
        return temp.size();
    }

    public static void removeCertificate(X509Certificate cert) {
        if (cert != null) {
            byte[] cert_DER = null;
            try {
                cert_DER = cert.getEncoded();
            }
            catch (CertificateEncodingException e2) {
                throw new InternalErrorException("Could not DER encode certificate. ");
            }
            String[] aliasArray = CertStore.makeAlias(cert);
            for (int i = 0; i < aliasArray.length; ++i) {
                Vector vect = (Vector)hashtable.remove(aliasArray[i]);
                if (vect == null) continue;
                boolean modified = false;
                int certCounter = 0;
                while (certCounter < vect.size()) {
                    X509Certificate certTemp = (X509Certificate)vect.elementAt(certCounter);
                    try {
                        if (CryptoUtils.equalsBlock((byte[])certTemp.getEncoded(), (byte[])cert_DER)) {
                            modified = true;
                            vect.removeElementAt(certCounter);
                            vect.trimToSize();
                            continue;
                        }
                        ++certCounter;
                    }
                    catch (CertificateEncodingException e3) {
                        throw new InternalErrorException("Could not DER encode certificate. ");
                    }
                }
                if (!modified || vect.size() <= 0) continue;
                hashtable.put(aliasArray[i], vect);
            }
        }
    }

    public static Hashtable getCertificates() {
        Hashtable<String, X509Certificate> temp = new Hashtable<String, X509Certificate>();
        Enumeration e2 = hashtable.elements();
        while (e2.hasMoreElements()) {
            Vector certVector = (Vector)e2.nextElement();
            for (int i = 0; i < certVector.size(); ++i) {
                X509Certificate cert = (X509Certificate)certVector.elementAt(i);
                String alias = TrustmanagerUtils.byteArrayToString(TrustmanagerUtils.makeCertHash(cert));
                temp.put(alias, cert);
            }
        }
        return temp;
    }

    public static boolean isEmpty() {
        return hashtable.isEmpty();
    }

    public static void load() throws IOException {
        hashtable = new Hashtable();
        FileInputStream stream = new FileInputStream(new File(TrustEnv.certFile));
        int length = stream.available();
        byte[] fileArray = new byte[length];
        stream.read(fileArray);
        SEQUENCE certStore = null;
        try {
            certStore = (SEQUENCE)DerCoder.decode((byte[])fileArray);
        }
        catch (CodingException e2) {
            throw new IOException("Unable to decode certificate store. ");
        }
        stream.close();
        int size = certStore.countComponents();
        for (int i = 0; i < size; ++i) {
            SEQUENCE record = (SEQUENCE)certStore.getComponentAt(i);
            UTF8String alias_ASN1 = (UTF8String)record.getComponentAt(0);
            SEQUENCE certificates_ASN1 = (SEQUENCE)record.getComponentAt(1);
            String alias = (String)alias_ASN1.getValue();
            Vector<X509Certificate> certVector = new Vector<X509Certificate>();
            int certSEQUENCESize = certificates_ASN1.countComponents();
            for (int j = 0; j < certSEQUENCESize; ++j) {
                X509Certificate cert = new X509Certificate();
                try {
                    cert.decode(certificates_ASN1.getComponentAt(j));
                }
                catch (CodingException e3) {
                    throw new IOException("Unable to decode certificate store. ");
                }
                certVector.addElement(cert);
            }
            hashtable.put(alias, certVector);
        }
    }

    public static void store() throws IOException {
        SEQUENCE certStore = new SEQUENCE();
        Enumeration key_enum = hashtable.keys();
        while (key_enum.hasMoreElements()) {
            String alias = (String)key_enum.nextElement();
            UTF8String alias_ASN1 = new UTF8String(alias);
            SEQUENCE certificateSEQUENCE = new SEQUENCE();
            Vector certVector = (Vector)hashtable.get(alias);
            for (int i = 0; i < certVector.size(); ++i) {
                X509Certificate x509cert = (X509Certificate)certVector.elementAt(i);
                ASN1Object cert = x509cert.toASN1Object();
                certificateSEQUENCE.addComponent(cert);
            }
            SEQUENCE record = new SEQUENCE();
            record.addComponent((ASN1Object)alias_ASN1);
            record.addComponent((ASN1Object)certificateSEQUENCE);
            certStore.addComponent((ASN1Object)record);
        }
        String backupFileName = TrustEnv.certFile;
        backupFileName = backupFileName.substring(0, backupFileName.length() - 1);
        backupFileName = String.valueOf(backupFileName).concat(String.valueOf("~"));
        File backupFile = new File(backupFileName);
        backupFile.delete();
        File certFile = new File(TrustEnv.certFile);
        certFile.renameTo(backupFile);
        FileOutputStream outStream = new FileOutputStream(certFile);
        DerCoder.encodeTo((ASN1Object)certStore, (OutputStream)outStream);
        outStream.flush();
        outStream.close();
    }
}

